/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDescriptorPoolSize;

public class VkDescriptorPoolCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int MAXSETS;
    public static final int POOLSIZECOUNT;
    public static final int PPOOLSIZES;

    VkDescriptorPoolCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDescriptorPoolCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDescriptorPoolCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDescriptorPoolCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDescriptorPoolCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkDescriptorPoolCreateFlags")
    public int flags() {
        return VkDescriptorPoolCreateInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxSets() {
        return VkDescriptorPoolCreateInfo.nmaxSets(this.address());
    }

    @NativeType(value="uint32_t")
    public int poolSizeCount() {
        return VkDescriptorPoolCreateInfo.npoolSizeCount(this.address());
    }

    @NativeType(value="VkDescriptorPoolSize const *")
    public VkDescriptorPoolSize.Buffer pPoolSizes() {
        return VkDescriptorPoolCreateInfo.npPoolSizes(this.address());
    }

    public VkDescriptorPoolCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDescriptorPoolCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkDescriptorPoolCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkDescriptorPoolCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkDescriptorPoolCreateInfo flags(@NativeType(value="VkDescriptorPoolCreateFlags") int value) {
        VkDescriptorPoolCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkDescriptorPoolCreateInfo maxSets(@NativeType(value="uint32_t") int value) {
        VkDescriptorPoolCreateInfo.nmaxSets(this.address(), value);
        return this;
    }

    public VkDescriptorPoolCreateInfo pPoolSizes(@NativeType(value="VkDescriptorPoolSize const *") VkDescriptorPoolSize.Buffer value) {
        VkDescriptorPoolCreateInfo.npPoolSizes(this.address(), value);
        return this;
    }

    public VkDescriptorPoolCreateInfo set(int sType, long pNext, int flags, int maxSets, VkDescriptorPoolSize.Buffer pPoolSizes) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.maxSets(maxSets);
        this.pPoolSizes(pPoolSizes);
        return this;
    }

    public VkDescriptorPoolCreateInfo set(VkDescriptorPoolCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDescriptorPoolCreateInfo malloc() {
        return VkDescriptorPoolCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDescriptorPoolCreateInfo calloc() {
        return VkDescriptorPoolCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDescriptorPoolCreateInfo create() {
        return new VkDescriptorPoolCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDescriptorPoolCreateInfo create(long address) {
        return new VkDescriptorPoolCreateInfo(address, null);
    }

    @Nullable
    public static VkDescriptorPoolCreateInfo createSafe(long address) {
        return address == 0L ? null : VkDescriptorPoolCreateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDescriptorPoolCreateInfo.create(VkDescriptorPoolCreateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDescriptorPoolCreateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDescriptorPoolCreateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDescriptorPoolCreateInfo.create(address, capacity);
    }

    public static VkDescriptorPoolCreateInfo mallocStack() {
        return VkDescriptorPoolCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorPoolCreateInfo callocStack() {
        return VkDescriptorPoolCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorPoolCreateInfo mallocStack(MemoryStack stack) {
        return VkDescriptorPoolCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDescriptorPoolCreateInfo callocStack(MemoryStack stack) {
        return VkDescriptorPoolCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDescriptorPoolCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDescriptorPoolCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorPoolCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorPoolCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nmaxSets(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXSETS);
    }

    public static int npoolSizeCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)POOLSIZECOUNT);
    }

    public static VkDescriptorPoolSize.Buffer npPoolSizes(long struct) {
        return VkDescriptorPoolSize.create(MemoryUtil.memGetAddress(struct + (long)PPOOLSIZES), VkDescriptorPoolCreateInfo.npoolSizeCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nmaxSets(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAXSETS, value);
    }

    public static void npoolSizeCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)POOLSIZECOUNT, value);
    }

    public static void npPoolSizes(long struct, VkDescriptorPoolSize.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPOOLSIZES, value.address());
        VkDescriptorPoolCreateInfo.npoolSizeCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PPOOLSIZES));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDescriptorPoolCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDescriptorPoolCreateInfo.__struct(VkDescriptorPoolCreateInfo.__member(4), VkDescriptorPoolCreateInfo.__member(POINTER_SIZE), VkDescriptorPoolCreateInfo.__member(4), VkDescriptorPoolCreateInfo.__member(4), VkDescriptorPoolCreateInfo.__member(4), VkDescriptorPoolCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        MAXSETS = layout.offsetof(3);
        POOLSIZECOUNT = layout.offsetof(4);
        PPOOLSIZES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorPoolCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDescriptorPoolCreateInfo newInstance(long address) {
            return new VkDescriptorPoolCreateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDescriptorPoolCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDescriptorPoolCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkDescriptorPoolCreateFlags")
        public int flags() {
            return VkDescriptorPoolCreateInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxSets() {
            return VkDescriptorPoolCreateInfo.nmaxSets(this.address());
        }

        @NativeType(value="uint32_t")
        public int poolSizeCount() {
            return VkDescriptorPoolCreateInfo.npoolSizeCount(this.address());
        }

        @NativeType(value="VkDescriptorPoolSize const *")
        public VkDescriptorPoolSize.Buffer pPoolSizes() {
            return VkDescriptorPoolCreateInfo.npPoolSizes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDescriptorPoolCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDescriptorPoolCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkDescriptorPoolCreateFlags") int value) {
            VkDescriptorPoolCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer maxSets(@NativeType(value="uint32_t") int value) {
            VkDescriptorPoolCreateInfo.nmaxSets(this.address(), value);
            return this;
        }

        public Buffer pPoolSizes(@NativeType(value="VkDescriptorPoolSize const *") VkDescriptorPoolSize.Buffer value) {
            VkDescriptorPoolCreateInfo.npPoolSizes(this.address(), value);
            return this;
        }
    }
}

