/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDescriptorBufferInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFER;
    public static final int OFFSET;
    public static final int RANGE;

    VkDescriptorBufferInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDescriptorBufferInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDescriptorBufferInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkDescriptorBufferInfo.nbuffer(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VkDescriptorBufferInfo.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long range() {
        return VkDescriptorBufferInfo.nrange(this.address());
    }

    public VkDescriptorBufferInfo buffer(@NativeType(value="VkBuffer") long value) {
        VkDescriptorBufferInfo.nbuffer(this.address(), value);
        return this;
    }

    public VkDescriptorBufferInfo offset(@NativeType(value="VkDeviceSize") long value) {
        VkDescriptorBufferInfo.noffset(this.address(), value);
        return this;
    }

    public VkDescriptorBufferInfo range(@NativeType(value="VkDeviceSize") long value) {
        VkDescriptorBufferInfo.nrange(this.address(), value);
        return this;
    }

    public VkDescriptorBufferInfo set(long buffer, long offset, long range) {
        this.buffer(buffer);
        this.offset(offset);
        this.range(range);
        return this;
    }

    public VkDescriptorBufferInfo set(VkDescriptorBufferInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDescriptorBufferInfo malloc() {
        return VkDescriptorBufferInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDescriptorBufferInfo calloc() {
        return VkDescriptorBufferInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDescriptorBufferInfo create() {
        return new VkDescriptorBufferInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDescriptorBufferInfo create(long address) {
        return new VkDescriptorBufferInfo(address, null);
    }

    @Nullable
    public static VkDescriptorBufferInfo createSafe(long address) {
        return address == 0L ? null : VkDescriptorBufferInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDescriptorBufferInfo.create(VkDescriptorBufferInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDescriptorBufferInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDescriptorBufferInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDescriptorBufferInfo.create(address, capacity);
    }

    public static VkDescriptorBufferInfo mallocStack() {
        return VkDescriptorBufferInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorBufferInfo callocStack() {
        return VkDescriptorBufferInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorBufferInfo mallocStack(MemoryStack stack) {
        return VkDescriptorBufferInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDescriptorBufferInfo callocStack(MemoryStack stack) {
        return VkDescriptorBufferInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDescriptorBufferInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDescriptorBufferInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorBufferInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorBufferInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BUFFER);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OFFSET);
    }

    public static long nrange(long struct) {
        return MemoryUtil.memGetLong(struct + (long)RANGE);
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BUFFER, value);
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)OFFSET, value);
    }

    public static void nrange(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)RANGE, value);
    }

    static {
        Struct.Layout layout = VkDescriptorBufferInfo.__struct(VkDescriptorBufferInfo.__member(8), VkDescriptorBufferInfo.__member(8), VkDescriptorBufferInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFER = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        RANGE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorBufferInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDescriptorBufferInfo newInstance(long address) {
            return new VkDescriptorBufferInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkDescriptorBufferInfo.nbuffer(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VkDescriptorBufferInfo.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long range() {
            return VkDescriptorBufferInfo.nrange(this.address());
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkDescriptorBufferInfo.nbuffer(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="VkDeviceSize") long value) {
            VkDescriptorBufferInfo.noffset(this.address(), value);
            return this;
        }

        public Buffer range(@NativeType(value="VkDeviceSize") long value) {
            VkDescriptorBufferInfo.nrange(this.address(), value);
            return this;
        }
    }
}

