/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkRect2D;

public class VkClearRect
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RECT;
    public static final int BASEARRAYLAYER;
    public static final int LAYERCOUNT;

    VkClearRect(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkClearRect(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkClearRect.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkRect2D rect() {
        return VkClearRect.nrect(this.address());
    }

    public VkClearRect rect(Consumer<VkRect2D> consumer) {
        consumer.accept(this.rect());
        return this;
    }

    @NativeType(value="uint32_t")
    public int baseArrayLayer() {
        return VkClearRect.nbaseArrayLayer(this.address());
    }

    @NativeType(value="uint32_t")
    public int layerCount() {
        return VkClearRect.nlayerCount(this.address());
    }

    public VkClearRect rect(VkRect2D value) {
        VkClearRect.nrect(this.address(), value);
        return this;
    }

    public VkClearRect baseArrayLayer(@NativeType(value="uint32_t") int value) {
        VkClearRect.nbaseArrayLayer(this.address(), value);
        return this;
    }

    public VkClearRect layerCount(@NativeType(value="uint32_t") int value) {
        VkClearRect.nlayerCount(this.address(), value);
        return this;
    }

    public VkClearRect set(VkRect2D rect, int baseArrayLayer, int layerCount) {
        this.rect(rect);
        this.baseArrayLayer(baseArrayLayer);
        this.layerCount(layerCount);
        return this;
    }

    public VkClearRect set(VkClearRect src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkClearRect malloc() {
        return VkClearRect.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkClearRect calloc() {
        return VkClearRect.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkClearRect create() {
        return new VkClearRect(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkClearRect create(long address) {
        return new VkClearRect(address, null);
    }

    @Nullable
    public static VkClearRect createSafe(long address) {
        return address == 0L ? null : VkClearRect.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkClearRect.create(VkClearRect.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkClearRect.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkClearRect.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkClearRect.create(address, capacity);
    }

    public static VkClearRect mallocStack() {
        return VkClearRect.mallocStack(MemoryStack.stackGet());
    }

    public static VkClearRect callocStack() {
        return VkClearRect.callocStack(MemoryStack.stackGet());
    }

    public static VkClearRect mallocStack(MemoryStack stack) {
        return VkClearRect.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkClearRect callocStack(MemoryStack stack) {
        return VkClearRect.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkClearRect.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkClearRect.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkClearRect.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkClearRect.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkRect2D nrect(long struct) {
        return VkRect2D.create(struct + (long)RECT);
    }

    public static int nbaseArrayLayer(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BASEARRAYLAYER);
    }

    public static int nlayerCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LAYERCOUNT);
    }

    public static void nrect(long struct, VkRect2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)RECT, VkRect2D.SIZEOF);
    }

    public static void nbaseArrayLayer(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BASEARRAYLAYER, value);
    }

    public static void nlayerCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LAYERCOUNT, value);
    }

    static {
        Struct.Layout layout = VkClearRect.__struct(VkClearRect.__member(VkRect2D.SIZEOF, VkRect2D.ALIGNOF), VkClearRect.__member(4), VkClearRect.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RECT = layout.offsetof(0);
        BASEARRAYLAYER = layout.offsetof(1);
        LAYERCOUNT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkClearRect, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkClearRect newInstance(long address) {
            return new VkClearRect(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public VkRect2D rect() {
            return VkClearRect.nrect(this.address());
        }

        public Buffer rect(Consumer<VkRect2D> consumer) {
            consumer.accept(this.rect());
            return this;
        }

        @NativeType(value="uint32_t")
        public int baseArrayLayer() {
            return VkClearRect.nbaseArrayLayer(this.address());
        }

        @NativeType(value="uint32_t")
        public int layerCount() {
            return VkClearRect.nlayerCount(this.address());
        }

        public Buffer rect(VkRect2D value) {
            VkClearRect.nrect(this.address(), value);
            return this;
        }

        public Buffer baseArrayLayer(@NativeType(value="uint32_t") int value) {
            VkClearRect.nbaseArrayLayer(this.address(), value);
            return this;
        }

        public Buffer layerCount(@NativeType(value="uint32_t") int value) {
            VkClearRect.nlayerCount(this.address(), value);
            return this;
        }
    }
}

