/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBindImagePlaneMemoryInfo;

public class VkBindImagePlaneMemoryInfoKHR
extends VkBindImagePlaneMemoryInfo {
    VkBindImagePlaneMemoryInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkBindImagePlaneMemoryInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkBindImagePlaneMemoryInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkBindImagePlaneMemoryInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkBindImagePlaneMemoryInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkBindImagePlaneMemoryInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkBindImagePlaneMemoryInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkBindImagePlaneMemoryInfoKHR planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
        VkBindImagePlaneMemoryInfoKHR.nplaneAspect(this.address(), value);
        return this;
    }

    @Override
    public VkBindImagePlaneMemoryInfoKHR set(int sType, long pNext, int planeAspect) {
        this.sType(sType);
        this.pNext(pNext);
        this.planeAspect(planeAspect);
        return this;
    }

    public VkBindImagePlaneMemoryInfoKHR set(VkBindImagePlaneMemoryInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindImagePlaneMemoryInfoKHR malloc() {
        return VkBindImagePlaneMemoryInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBindImagePlaneMemoryInfoKHR calloc() {
        return VkBindImagePlaneMemoryInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBindImagePlaneMemoryInfoKHR create() {
        return new VkBindImagePlaneMemoryInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkBindImagePlaneMemoryInfoKHR create(long address) {
        return new VkBindImagePlaneMemoryInfoKHR(address, null);
    }

    @Nullable
    public static VkBindImagePlaneMemoryInfoKHR createSafe(long address) {
        return address == 0L ? null : VkBindImagePlaneMemoryInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkBindImagePlaneMemoryInfoKHR.create(VkBindImagePlaneMemoryInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBindImagePlaneMemoryInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkBindImagePlaneMemoryInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBindImagePlaneMemoryInfoKHR.create(address, capacity);
    }

    public static VkBindImagePlaneMemoryInfoKHR mallocStack() {
        return VkBindImagePlaneMemoryInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkBindImagePlaneMemoryInfoKHR callocStack() {
        return VkBindImagePlaneMemoryInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkBindImagePlaneMemoryInfoKHR mallocStack(MemoryStack stack) {
        return VkBindImagePlaneMemoryInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBindImagePlaneMemoryInfoKHR callocStack(MemoryStack stack) {
        return VkBindImagePlaneMemoryInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBindImagePlaneMemoryInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBindImagePlaneMemoryInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindImagePlaneMemoryInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindImagePlaneMemoryInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkBindImagePlaneMemoryInfo.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkBindImagePlaneMemoryInfoKHR newInstance(long address) {
            return new VkBindImagePlaneMemoryInfoKHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindImagePlaneMemoryInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindImagePlaneMemoryInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
            VkBindImagePlaneMemoryInfoKHR.nplaneAspect(this.address(), value);
            return this;
        }
    }
}

