/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBindBufferMemoryInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int BUFFER;
    public static final int MEMORY;
    public static final int MEMORYOFFSET;

    VkBindBufferMemoryInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkBindBufferMemoryInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkBindBufferMemoryInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBindBufferMemoryInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBindBufferMemoryInfo.npNext(this.address());
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkBindBufferMemoryInfo.nbuffer(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkBindBufferMemoryInfo.nmemory(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long memoryOffset() {
        return VkBindBufferMemoryInfo.nmemoryOffset(this.address());
    }

    public VkBindBufferMemoryInfo sType(@NativeType(value="VkStructureType") int value) {
        VkBindBufferMemoryInfo.nsType(this.address(), value);
        return this;
    }

    public VkBindBufferMemoryInfo pNext(@NativeType(value="void const *") long value) {
        VkBindBufferMemoryInfo.npNext(this.address(), value);
        return this;
    }

    public VkBindBufferMemoryInfo buffer(@NativeType(value="VkBuffer") long value) {
        VkBindBufferMemoryInfo.nbuffer(this.address(), value);
        return this;
    }

    public VkBindBufferMemoryInfo memory(@NativeType(value="VkDeviceMemory") long value) {
        VkBindBufferMemoryInfo.nmemory(this.address(), value);
        return this;
    }

    public VkBindBufferMemoryInfo memoryOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBindBufferMemoryInfo.nmemoryOffset(this.address(), value);
        return this;
    }

    public VkBindBufferMemoryInfo set(int sType, long pNext, long buffer, long memory, long memoryOffset) {
        this.sType(sType);
        this.pNext(pNext);
        this.buffer(buffer);
        this.memory(memory);
        this.memoryOffset(memoryOffset);
        return this;
    }

    public VkBindBufferMemoryInfo set(VkBindBufferMemoryInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindBufferMemoryInfo malloc() {
        return VkBindBufferMemoryInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBindBufferMemoryInfo calloc() {
        return VkBindBufferMemoryInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBindBufferMemoryInfo create() {
        return new VkBindBufferMemoryInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkBindBufferMemoryInfo create(long address) {
        return new VkBindBufferMemoryInfo(address, null);
    }

    @Nullable
    public static VkBindBufferMemoryInfo createSafe(long address) {
        return address == 0L ? null : VkBindBufferMemoryInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkBindBufferMemoryInfo.create(VkBindBufferMemoryInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBindBufferMemoryInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkBindBufferMemoryInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBindBufferMemoryInfo.create(address, capacity);
    }

    public static VkBindBufferMemoryInfo mallocStack() {
        return VkBindBufferMemoryInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkBindBufferMemoryInfo callocStack() {
        return VkBindBufferMemoryInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkBindBufferMemoryInfo mallocStack(MemoryStack stack) {
        return VkBindBufferMemoryInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBindBufferMemoryInfo callocStack(MemoryStack stack) {
        return VkBindBufferMemoryInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBindBufferMemoryInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBindBufferMemoryInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindBufferMemoryInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindBufferMemoryInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BUFFER);
    }

    public static long nmemory(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MEMORY);
    }

    public static long nmemoryOffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MEMORYOFFSET);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BUFFER, value);
    }

    public static void nmemory(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MEMORY, value);
    }

    public static void nmemoryOffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MEMORYOFFSET, value);
    }

    static {
        Struct.Layout layout = VkBindBufferMemoryInfo.__struct(VkBindBufferMemoryInfo.__member(4), VkBindBufferMemoryInfo.__member(POINTER_SIZE), VkBindBufferMemoryInfo.__member(8), VkBindBufferMemoryInfo.__member(8), VkBindBufferMemoryInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        BUFFER = layout.offsetof(2);
        MEMORY = layout.offsetof(3);
        MEMORYOFFSET = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkBindBufferMemoryInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkBindBufferMemoryInfo newInstance(long address) {
            return new VkBindBufferMemoryInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBindBufferMemoryInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBindBufferMemoryInfo.npNext(this.address());
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkBindBufferMemoryInfo.nbuffer(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkBindBufferMemoryInfo.nmemory(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long memoryOffset() {
            return VkBindBufferMemoryInfo.nmemoryOffset(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindBufferMemoryInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindBufferMemoryInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkBindBufferMemoryInfo.nbuffer(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkBindBufferMemoryInfo.nmemory(this.address(), value);
            return this;
        }

        public Buffer memoryOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBindBufferMemoryInfo.nmemoryOffset(this.address(), value);
            return this;
        }
    }
}

