/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBindBufferMemoryDeviceGroupInfo;

public class VkBindBufferMemoryDeviceGroupInfoKHR
extends VkBindBufferMemoryDeviceGroupInfo {
    VkBindBufferMemoryDeviceGroupInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkBindBufferMemoryDeviceGroupInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkBindBufferMemoryDeviceGroupInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkBindBufferMemoryDeviceGroupInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkBindBufferMemoryDeviceGroupInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkBindBufferMemoryDeviceGroupInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkBindBufferMemoryDeviceGroupInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkBindBufferMemoryDeviceGroupInfoKHR pDeviceIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkBindBufferMemoryDeviceGroupInfoKHR.npDeviceIndices(this.address(), value);
        return this;
    }

    @Override
    public VkBindBufferMemoryDeviceGroupInfoKHR set(int sType, long pNext, @Nullable IntBuffer pDeviceIndices) {
        this.sType(sType);
        this.pNext(pNext);
        this.pDeviceIndices(pDeviceIndices);
        return this;
    }

    public VkBindBufferMemoryDeviceGroupInfoKHR set(VkBindBufferMemoryDeviceGroupInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindBufferMemoryDeviceGroupInfoKHR malloc() {
        return VkBindBufferMemoryDeviceGroupInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBindBufferMemoryDeviceGroupInfoKHR calloc() {
        return VkBindBufferMemoryDeviceGroupInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBindBufferMemoryDeviceGroupInfoKHR create() {
        return new VkBindBufferMemoryDeviceGroupInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkBindBufferMemoryDeviceGroupInfoKHR create(long address) {
        return new VkBindBufferMemoryDeviceGroupInfoKHR(address, null);
    }

    @Nullable
    public static VkBindBufferMemoryDeviceGroupInfoKHR createSafe(long address) {
        return address == 0L ? null : VkBindBufferMemoryDeviceGroupInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkBindBufferMemoryDeviceGroupInfoKHR.create(VkBindBufferMemoryDeviceGroupInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBindBufferMemoryDeviceGroupInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkBindBufferMemoryDeviceGroupInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBindBufferMemoryDeviceGroupInfoKHR.create(address, capacity);
    }

    public static VkBindBufferMemoryDeviceGroupInfoKHR mallocStack() {
        return VkBindBufferMemoryDeviceGroupInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkBindBufferMemoryDeviceGroupInfoKHR callocStack() {
        return VkBindBufferMemoryDeviceGroupInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkBindBufferMemoryDeviceGroupInfoKHR mallocStack(MemoryStack stack) {
        return VkBindBufferMemoryDeviceGroupInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBindBufferMemoryDeviceGroupInfoKHR callocStack(MemoryStack stack) {
        return VkBindBufferMemoryDeviceGroupInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBindBufferMemoryDeviceGroupInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBindBufferMemoryDeviceGroupInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindBufferMemoryDeviceGroupInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindBufferMemoryDeviceGroupInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkBindBufferMemoryDeviceGroupInfo.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkBindBufferMemoryDeviceGroupInfoKHR newInstance(long address) {
            return new VkBindBufferMemoryDeviceGroupInfoKHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindBufferMemoryDeviceGroupInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindBufferMemoryDeviceGroupInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer pDeviceIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkBindBufferMemoryDeviceGroupInfoKHR.npDeviceIndices(this.address(), value);
            return this;
        }
    }
}

