/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSampleLocationsInfoEXT;

public class VkAttachmentSampleLocationsEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ATTACHMENTINDEX;
    public static final int SAMPLELOCATIONSINFO;

    VkAttachmentSampleLocationsEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkAttachmentSampleLocationsEXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkAttachmentSampleLocationsEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int attachmentIndex() {
        return VkAttachmentSampleLocationsEXT.nattachmentIndex(this.address());
    }

    public VkSampleLocationsInfoEXT sampleLocationsInfo() {
        return VkAttachmentSampleLocationsEXT.nsampleLocationsInfo(this.address());
    }

    public VkAttachmentSampleLocationsEXT sampleLocationsInfo(Consumer<VkSampleLocationsInfoEXT> consumer) {
        consumer.accept(this.sampleLocationsInfo());
        return this;
    }

    public VkAttachmentSampleLocationsEXT attachmentIndex(@NativeType(value="uint32_t") int value) {
        VkAttachmentSampleLocationsEXT.nattachmentIndex(this.address(), value);
        return this;
    }

    public VkAttachmentSampleLocationsEXT sampleLocationsInfo(VkSampleLocationsInfoEXT value) {
        VkAttachmentSampleLocationsEXT.nsampleLocationsInfo(this.address(), value);
        return this;
    }

    public VkAttachmentSampleLocationsEXT set(int attachmentIndex, VkSampleLocationsInfoEXT sampleLocationsInfo) {
        this.attachmentIndex(attachmentIndex);
        this.sampleLocationsInfo(sampleLocationsInfo);
        return this;
    }

    public VkAttachmentSampleLocationsEXT set(VkAttachmentSampleLocationsEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAttachmentSampleLocationsEXT malloc() {
        return VkAttachmentSampleLocationsEXT.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkAttachmentSampleLocationsEXT calloc() {
        return VkAttachmentSampleLocationsEXT.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkAttachmentSampleLocationsEXT create() {
        return new VkAttachmentSampleLocationsEXT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkAttachmentSampleLocationsEXT create(long address) {
        return new VkAttachmentSampleLocationsEXT(address, null);
    }

    @Nullable
    public static VkAttachmentSampleLocationsEXT createSafe(long address) {
        return address == 0L ? null : VkAttachmentSampleLocationsEXT.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkAttachmentSampleLocationsEXT.create(VkAttachmentSampleLocationsEXT.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkAttachmentSampleLocationsEXT.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkAttachmentSampleLocationsEXT.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkAttachmentSampleLocationsEXT.create(address, capacity);
    }

    public static VkAttachmentSampleLocationsEXT mallocStack() {
        return VkAttachmentSampleLocationsEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkAttachmentSampleLocationsEXT callocStack() {
        return VkAttachmentSampleLocationsEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkAttachmentSampleLocationsEXT mallocStack(MemoryStack stack) {
        return VkAttachmentSampleLocationsEXT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAttachmentSampleLocationsEXT callocStack(MemoryStack stack) {
        return VkAttachmentSampleLocationsEXT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkAttachmentSampleLocationsEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkAttachmentSampleLocationsEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkAttachmentSampleLocationsEXT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkAttachmentSampleLocationsEXT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nattachmentIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ATTACHMENTINDEX);
    }

    public static VkSampleLocationsInfoEXT nsampleLocationsInfo(long struct) {
        return VkSampleLocationsInfoEXT.create(struct + (long)SAMPLELOCATIONSINFO);
    }

    public static void nattachmentIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ATTACHMENTINDEX, value);
    }

    public static void nsampleLocationsInfo(long struct, VkSampleLocationsInfoEXT value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SAMPLELOCATIONSINFO, VkSampleLocationsInfoEXT.SIZEOF);
    }

    public static void validate(long struct) {
        VkSampleLocationsInfoEXT.validate(struct + (long)SAMPLELOCATIONSINFO);
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkAttachmentSampleLocationsEXT.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkAttachmentSampleLocationsEXT.__struct(VkAttachmentSampleLocationsEXT.__member(4), VkAttachmentSampleLocationsEXT.__member(VkSampleLocationsInfoEXT.SIZEOF, VkSampleLocationsInfoEXT.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ATTACHMENTINDEX = layout.offsetof(0);
        SAMPLELOCATIONSINFO = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkAttachmentSampleLocationsEXT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkAttachmentSampleLocationsEXT newInstance(long address) {
            return new VkAttachmentSampleLocationsEXT(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint32_t")
        public int attachmentIndex() {
            return VkAttachmentSampleLocationsEXT.nattachmentIndex(this.address());
        }

        public VkSampleLocationsInfoEXT sampleLocationsInfo() {
            return VkAttachmentSampleLocationsEXT.nsampleLocationsInfo(this.address());
        }

        public Buffer sampleLocationsInfo(Consumer<VkSampleLocationsInfoEXT> consumer) {
            consumer.accept(this.sampleLocationsInfo());
            return this;
        }

        public Buffer attachmentIndex(@NativeType(value="uint32_t") int value) {
            VkAttachmentSampleLocationsEXT.nattachmentIndex(this.address(), value);
            return this;
        }

        public Buffer sampleLocationsInfo(VkSampleLocationsInfoEXT value) {
            VkAttachmentSampleLocationsEXT.nsampleLocationsInfo(this.address(), value);
            return this;
        }
    }
}

