/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAllocationFunction;
import org.lwjgl.vulkan.VkAllocationFunctionI;
import org.lwjgl.vulkan.VkFreeFunction;
import org.lwjgl.vulkan.VkFreeFunctionI;
import org.lwjgl.vulkan.VkInternalAllocationNotification;
import org.lwjgl.vulkan.VkInternalAllocationNotificationI;
import org.lwjgl.vulkan.VkInternalFreeNotification;
import org.lwjgl.vulkan.VkInternalFreeNotificationI;
import org.lwjgl.vulkan.VkReallocationFunction;
import org.lwjgl.vulkan.VkReallocationFunctionI;

public class VkAllocationCallbacks
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PUSERDATA;
    public static final int PFNALLOCATION;
    public static final int PFNREALLOCATION;
    public static final int PFNFREE;
    public static final int PFNINTERNALALLOCATION;
    public static final int PFNINTERNALFREE;

    VkAllocationCallbacks(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkAllocationCallbacks(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkAllocationCallbacks.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long pUserData() {
        return VkAllocationCallbacks.npUserData(this.address());
    }

    @NativeType(value="PFN_vkAllocationFunction")
    public VkAllocationFunction pfnAllocation() {
        return VkAllocationCallbacks.npfnAllocation(this.address());
    }

    @NativeType(value="PFN_vkReallocationFunction")
    public VkReallocationFunction pfnReallocation() {
        return VkAllocationCallbacks.npfnReallocation(this.address());
    }

    @NativeType(value="PFN_vkFreeFunction")
    public VkFreeFunction pfnFree() {
        return VkAllocationCallbacks.npfnFree(this.address());
    }

    @Nullable
    @NativeType(value="PFN_vkInternalAllocationNotification")
    public VkInternalAllocationNotification pfnInternalAllocation() {
        return VkAllocationCallbacks.npfnInternalAllocation(this.address());
    }

    @Nullable
    @NativeType(value="PFN_vkInternalFreeNotification")
    public VkInternalFreeNotification pfnInternalFree() {
        return VkAllocationCallbacks.npfnInternalFree(this.address());
    }

    public VkAllocationCallbacks pUserData(@NativeType(value="void *") long value) {
        VkAllocationCallbacks.npUserData(this.address(), value);
        return this;
    }

    public VkAllocationCallbacks pfnAllocation(@NativeType(value="PFN_vkAllocationFunction") VkAllocationFunctionI value) {
        VkAllocationCallbacks.npfnAllocation(this.address(), value);
        return this;
    }

    public VkAllocationCallbacks pfnReallocation(@NativeType(value="PFN_vkReallocationFunction") VkReallocationFunctionI value) {
        VkAllocationCallbacks.npfnReallocation(this.address(), value);
        return this;
    }

    public VkAllocationCallbacks pfnFree(@NativeType(value="PFN_vkFreeFunction") VkFreeFunctionI value) {
        VkAllocationCallbacks.npfnFree(this.address(), value);
        return this;
    }

    public VkAllocationCallbacks pfnInternalAllocation(@Nullable @NativeType(value="PFN_vkInternalAllocationNotification") VkInternalAllocationNotificationI value) {
        VkAllocationCallbacks.npfnInternalAllocation(this.address(), value);
        return this;
    }

    public VkAllocationCallbacks pfnInternalFree(@Nullable @NativeType(value="PFN_vkInternalFreeNotification") VkInternalFreeNotificationI value) {
        VkAllocationCallbacks.npfnInternalFree(this.address(), value);
        return this;
    }

    public VkAllocationCallbacks set(long pUserData, VkAllocationFunctionI pfnAllocation, VkReallocationFunctionI pfnReallocation, VkFreeFunctionI pfnFree, VkInternalAllocationNotificationI pfnInternalAllocation, VkInternalFreeNotificationI pfnInternalFree) {
        this.pUserData(pUserData);
        this.pfnAllocation(pfnAllocation);
        this.pfnReallocation(pfnReallocation);
        this.pfnFree(pfnFree);
        this.pfnInternalAllocation(pfnInternalAllocation);
        this.pfnInternalFree(pfnInternalFree);
        return this;
    }

    public VkAllocationCallbacks set(VkAllocationCallbacks src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAllocationCallbacks malloc() {
        return VkAllocationCallbacks.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkAllocationCallbacks calloc() {
        return VkAllocationCallbacks.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkAllocationCallbacks create() {
        return new VkAllocationCallbacks(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkAllocationCallbacks create(long address) {
        return new VkAllocationCallbacks(address, null);
    }

    @Nullable
    public static VkAllocationCallbacks createSafe(long address) {
        return address == 0L ? null : VkAllocationCallbacks.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkAllocationCallbacks.create(VkAllocationCallbacks.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkAllocationCallbacks.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkAllocationCallbacks.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkAllocationCallbacks.create(address, capacity);
    }

    public static VkAllocationCallbacks mallocStack() {
        return VkAllocationCallbacks.mallocStack(MemoryStack.stackGet());
    }

    public static VkAllocationCallbacks callocStack() {
        return VkAllocationCallbacks.callocStack(MemoryStack.stackGet());
    }

    public static VkAllocationCallbacks mallocStack(MemoryStack stack) {
        return VkAllocationCallbacks.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAllocationCallbacks callocStack(MemoryStack stack) {
        return VkAllocationCallbacks.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkAllocationCallbacks.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkAllocationCallbacks.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkAllocationCallbacks.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkAllocationCallbacks.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long npUserData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PUSERDATA);
    }

    public static VkAllocationFunction npfnAllocation(long struct) {
        return VkAllocationFunction.create(MemoryUtil.memGetAddress(struct + (long)PFNALLOCATION));
    }

    public static VkReallocationFunction npfnReallocation(long struct) {
        return VkReallocationFunction.create(MemoryUtil.memGetAddress(struct + (long)PFNREALLOCATION));
    }

    public static VkFreeFunction npfnFree(long struct) {
        return VkFreeFunction.create(MemoryUtil.memGetAddress(struct + (long)PFNFREE));
    }

    @Nullable
    public static VkInternalAllocationNotification npfnInternalAllocation(long struct) {
        return VkInternalAllocationNotification.createSafe(MemoryUtil.memGetAddress(struct + (long)PFNINTERNALALLOCATION));
    }

    @Nullable
    public static VkInternalFreeNotification npfnInternalFree(long struct) {
        return VkInternalFreeNotification.createSafe(MemoryUtil.memGetAddress(struct + (long)PFNINTERNALFREE));
    }

    public static void npUserData(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PUSERDATA, value);
    }

    public static void npfnAllocation(long struct, VkAllocationFunctionI value) {
        MemoryUtil.memPutAddress(struct + (long)PFNALLOCATION, value.address());
    }

    public static void npfnReallocation(long struct, VkReallocationFunctionI value) {
        MemoryUtil.memPutAddress(struct + (long)PFNREALLOCATION, value.address());
    }

    public static void npfnFree(long struct, VkFreeFunctionI value) {
        MemoryUtil.memPutAddress(struct + (long)PFNFREE, value.address());
    }

    public static void npfnInternalAllocation(long struct, @Nullable VkInternalAllocationNotificationI value) {
        MemoryUtil.memPutAddress(struct + (long)PFNINTERNALALLOCATION, MemoryUtil.memAddressSafe(value));
    }

    public static void npfnInternalFree(long struct, @Nullable VkInternalFreeNotificationI value) {
        MemoryUtil.memPutAddress(struct + (long)PFNINTERNALFREE, MemoryUtil.memAddressSafe(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PFNALLOCATION));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PFNREALLOCATION));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PFNFREE));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkAllocationCallbacks.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkAllocationCallbacks.__struct(VkAllocationCallbacks.__member(POINTER_SIZE), VkAllocationCallbacks.__member(POINTER_SIZE), VkAllocationCallbacks.__member(POINTER_SIZE), VkAllocationCallbacks.__member(POINTER_SIZE), VkAllocationCallbacks.__member(POINTER_SIZE), VkAllocationCallbacks.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PUSERDATA = layout.offsetof(0);
        PFNALLOCATION = layout.offsetof(1);
        PFNREALLOCATION = layout.offsetof(2);
        PFNFREE = layout.offsetof(3);
        PFNINTERNALALLOCATION = layout.offsetof(4);
        PFNINTERNALFREE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkAllocationCallbacks, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkAllocationCallbacks newInstance(long address) {
            return new VkAllocationCallbacks(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="void *")
        public long pUserData() {
            return VkAllocationCallbacks.npUserData(this.address());
        }

        @NativeType(value="PFN_vkAllocationFunction")
        public VkAllocationFunction pfnAllocation() {
            return VkAllocationCallbacks.npfnAllocation(this.address());
        }

        @NativeType(value="PFN_vkReallocationFunction")
        public VkReallocationFunction pfnReallocation() {
            return VkAllocationCallbacks.npfnReallocation(this.address());
        }

        @NativeType(value="PFN_vkFreeFunction")
        public VkFreeFunction pfnFree() {
            return VkAllocationCallbacks.npfnFree(this.address());
        }

        @Nullable
        @NativeType(value="PFN_vkInternalAllocationNotification")
        public VkInternalAllocationNotification pfnInternalAllocation() {
            return VkAllocationCallbacks.npfnInternalAllocation(this.address());
        }

        @Nullable
        @NativeType(value="PFN_vkInternalFreeNotification")
        public VkInternalFreeNotification pfnInternalFree() {
            return VkAllocationCallbacks.npfnInternalFree(this.address());
        }

        public Buffer pUserData(@NativeType(value="void *") long value) {
            VkAllocationCallbacks.npUserData(this.address(), value);
            return this;
        }

        public Buffer pfnAllocation(@NativeType(value="PFN_vkAllocationFunction") VkAllocationFunctionI value) {
            VkAllocationCallbacks.npfnAllocation(this.address(), value);
            return this;
        }

        public Buffer pfnReallocation(@NativeType(value="PFN_vkReallocationFunction") VkReallocationFunctionI value) {
            VkAllocationCallbacks.npfnReallocation(this.address(), value);
            return this;
        }

        public Buffer pfnFree(@NativeType(value="PFN_vkFreeFunction") VkFreeFunctionI value) {
            VkAllocationCallbacks.npfnFree(this.address(), value);
            return this;
        }

        public Buffer pfnInternalAllocation(@Nullable @NativeType(value="PFN_vkInternalAllocationNotification") VkInternalAllocationNotificationI value) {
            VkAllocationCallbacks.npfnInternalAllocation(this.address(), value);
            return this;
        }

        public Buffer pfnInternalFree(@Nullable @NativeType(value="PFN_vkInternalFreeNotification") VkInternalFreeNotificationI value) {
            VkAllocationCallbacks.npfnInternalFree(this.address(), value);
            return this;
        }
    }
}

