/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkWin32SurfaceCreateInfoKHR;

public class KHRWin32Surface {
    public static final int VK_KHR_WIN32_SURFACE_SPEC_VERSION = 6;
    public static final String VK_KHR_WIN32_SURFACE_EXTENSION_NAME = "VK_KHR_win32_surface";
    public static final int VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR = 1000009000;

    protected KHRWin32Surface() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsInstance(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_KHR_WIN32_SURFACE_EXTENSION_NAME) && VK.checkExtension(VK_KHR_WIN32_SURFACE_EXTENSION_NAME, VK.isSupported(provider, "vkCreateWin32SurfaceKHR", caps) && VK.isSupported(provider, "vkGetPhysicalDeviceWin32PresentationSupportKHR", caps));
    }

    public static int nvkCreateWin32SurfaceKHR(VkInstance instance, long pCreateInfo, long pAllocator, long pSurface) {
        long __functionAddress = instance.getCapabilities().vkCreateWin32SurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkWin32SurfaceCreateInfoKHR.validate(pCreateInfo);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        return JNI.callPPPPI(__functionAddress, instance.address(), pCreateInfo, pAllocator, pSurface);
    }

    @NativeType(value="VkResult")
    public static int vkCreateWin32SurfaceKHR(VkInstance instance, @NativeType(value="VkWin32SurfaceCreateInfoKHR const *") VkWin32SurfaceCreateInfoKHR pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkSurfaceKHR *") LongBuffer pSurface) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSurface, 1);
        }
        return KHRWin32Surface.nvkCreateWin32SurfaceKHR(instance, pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), MemoryUtil.memAddress(pSurface));
    }

    @NativeType(value="VkBool32")
    public static boolean vkGetPhysicalDeviceWin32PresentationSupportKHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t") int queueFamilyIndex) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceWin32PresentationSupportKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, physicalDevice.address(), queueFamilyIndex) != 0;
    }

    @NativeType(value="VkResult")
    public static int vkCreateWin32SurfaceKHR(VkInstance instance, @NativeType(value="VkWin32SurfaceCreateInfoKHR const *") VkWin32SurfaceCreateInfoKHR pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkSurfaceKHR *") long[] pSurface) {
        long __functionAddress = instance.getCapabilities().vkCreateWin32SurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pSurface, 1);
            VkWin32SurfaceCreateInfoKHR.validate(pCreateInfo.address());
            if (pAllocator != null) {
                VkAllocationCallbacks.validate(pAllocator.address());
            }
        }
        return JNI.callPPPPI(__functionAddress, instance.address(), pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), pSurface);
    }
}

