/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkBufferMemoryRequirementsInfo2;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkImageMemoryRequirementsInfo2;
import org.lwjgl.vulkan.VkImageSparseMemoryRequirementsInfo2;
import org.lwjgl.vulkan.VkMemoryRequirements2;
import org.lwjgl.vulkan.VkSparseImageMemoryRequirements2;

public class KHRGetMemoryRequirements2 {
    public static final int VK_KHR_GET_MEMORY_REQUIREMENTS_2_SPEC_VERSION = 1;
    public static final String VK_KHR_GET_MEMORY_REQUIREMENTS_2_EXTENSION_NAME = "VK_KHR_get_memory_requirements2";
    public static final int VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2_KHR = 1000146000;
    public static final int VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2_KHR = 1000146001;
    public static final int VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2_KHR = 1000146002;
    public static final int VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2_KHR = 1000146003;
    public static final int VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2_KHR = 1000146004;

    protected KHRGetMemoryRequirements2() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_KHR_GET_MEMORY_REQUIREMENTS_2_EXTENSION_NAME) && VK.checkExtension(VK_KHR_GET_MEMORY_REQUIREMENTS_2_EXTENSION_NAME, VK.isSupported(provider, "vkGetImageMemoryRequirements2KHR", caps) && VK.isSupported(provider, "vkGetBufferMemoryRequirements2KHR", caps) && VK.isSupported(provider, "vkGetImageSparseMemoryRequirements2KHR", caps));
    }

    public static void nvkGetImageMemoryRequirements2KHR(VkDevice device, long pInfo, long pMemoryRequirements) {
        long __functionAddress = device.getCapabilities().vkGetImageMemoryRequirements2KHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, device.address(), pInfo, pMemoryRequirements);
    }

    public static void vkGetImageMemoryRequirements2KHR(VkDevice device, @NativeType(value="VkImageMemoryRequirementsInfo2 const *") VkImageMemoryRequirementsInfo2 pInfo, @NativeType(value="VkMemoryRequirements2 *") VkMemoryRequirements2 pMemoryRequirements) {
        KHRGetMemoryRequirements2.nvkGetImageMemoryRequirements2KHR(device, pInfo.address(), pMemoryRequirements.address());
    }

    public static void nvkGetBufferMemoryRequirements2KHR(VkDevice device, long pInfo, long pMemoryRequirements) {
        long __functionAddress = device.getCapabilities().vkGetBufferMemoryRequirements2KHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, device.address(), pInfo, pMemoryRequirements);
    }

    public static void vkGetBufferMemoryRequirements2KHR(VkDevice device, @NativeType(value="VkBufferMemoryRequirementsInfo2 const *") VkBufferMemoryRequirementsInfo2 pInfo, @NativeType(value="VkMemoryRequirements2 *") VkMemoryRequirements2 pMemoryRequirements) {
        KHRGetMemoryRequirements2.nvkGetBufferMemoryRequirements2KHR(device, pInfo.address(), pMemoryRequirements.address());
    }

    public static void nvkGetImageSparseMemoryRequirements2KHR(VkDevice device, long pInfo, long pSparseMemoryRequirementCount, long pSparseMemoryRequirements) {
        long __functionAddress = device.getCapabilities().vkGetImageSparseMemoryRequirements2KHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPPV(__functionAddress, device.address(), pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
    }

    public static void vkGetImageSparseMemoryRequirements2KHR(VkDevice device, @NativeType(value="VkImageSparseMemoryRequirementsInfo2 const *") VkImageSparseMemoryRequirementsInfo2 pInfo, @NativeType(value="uint32_t *") IntBuffer pSparseMemoryRequirementCount, @Nullable @NativeType(value="VkSparseImageMemoryRequirements2 *") VkSparseImageMemoryRequirements2.Buffer pSparseMemoryRequirements) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSparseMemoryRequirementCount, 1);
            Checks.checkSafe(pSparseMemoryRequirements, pSparseMemoryRequirementCount.get(pSparseMemoryRequirementCount.position()));
        }
        KHRGetMemoryRequirements2.nvkGetImageSparseMemoryRequirements2KHR(device, pInfo.address(), MemoryUtil.memAddress(pSparseMemoryRequirementCount), MemoryUtil.memAddressSafe(pSparseMemoryRequirements));
    }

    public static void vkGetImageSparseMemoryRequirements2KHR(VkDevice device, @NativeType(value="VkImageSparseMemoryRequirementsInfo2 const *") VkImageSparseMemoryRequirementsInfo2 pInfo, @NativeType(value="uint32_t *") int[] pSparseMemoryRequirementCount, @Nullable @NativeType(value="VkSparseImageMemoryRequirements2 *") VkSparseImageMemoryRequirements2.Buffer pSparseMemoryRequirements) {
        long __functionAddress = device.getCapabilities().vkGetImageSparseMemoryRequirements2KHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pSparseMemoryRequirementCount, 1);
            Checks.checkSafe(pSparseMemoryRequirements, pSparseMemoryRequirementCount[0]);
        }
        JNI.callPPPPV(__functionAddress, device.address(), pInfo.address(), pSparseMemoryRequirementCount, MemoryUtil.memAddressSafe(pSparseMemoryRequirements));
    }
}

