/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Map;
import java.util.Set;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkImportSemaphoreFdInfoKHR;
import org.lwjgl.vulkan.VkSemaphoreGetFdInfoKHR;

public class KHRExternalSemaphoreFd {
    public static final int VK_KHR_EXTERNAL_SEMAPHORE_FD_SPEC_VERSION = 1;
    public static final String VK_KHR_EXTERNAL_SEMAPHORE_FD_EXTENSION_NAME = "VK_KHR_external_semaphore_fd";
    public static final int VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR = 1000079000;
    public static final int VK_STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR = 1000079001;

    protected KHRExternalSemaphoreFd() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_KHR_EXTERNAL_SEMAPHORE_FD_EXTENSION_NAME) && VK.checkExtension(VK_KHR_EXTERNAL_SEMAPHORE_FD_EXTENSION_NAME, VK.isSupported(provider, "vkImportSemaphoreFdKHR", caps) && VK.isSupported(provider, "vkGetSemaphoreFdKHR", caps));
    }

    public static int nvkImportSemaphoreFdKHR(VkDevice device, long pImportSemaphoreFdInfo) {
        long __functionAddress = device.getCapabilities().vkImportSemaphoreFdKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, device.address(), pImportSemaphoreFdInfo);
    }

    @NativeType(value="VkResult")
    public static int vkImportSemaphoreFdKHR(VkDevice device, @NativeType(value="VkImportSemaphoreFdInfoKHR const *") VkImportSemaphoreFdInfoKHR pImportSemaphoreFdInfo) {
        return KHRExternalSemaphoreFd.nvkImportSemaphoreFdKHR(device, pImportSemaphoreFdInfo.address());
    }

    public static int nvkGetSemaphoreFdKHR(VkDevice device, long pGetFdInfo, long pFd) {
        long __functionAddress = device.getCapabilities().vkGetSemaphoreFdKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, device.address(), pGetFdInfo, pFd);
    }

    @NativeType(value="VkResult")
    public static int vkGetSemaphoreFdKHR(VkDevice device, @NativeType(value="VkSemaphoreGetFdInfoKHR const *") VkSemaphoreGetFdInfoKHR pGetFdInfo, @NativeType(value="int *") IntBuffer pFd) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pFd, 1);
        }
        return KHRExternalSemaphoreFd.nvkGetSemaphoreFdKHR(device, pGetFdInfo.address(), MemoryUtil.memAddress(pFd));
    }

    @NativeType(value="VkResult")
    public static int vkGetSemaphoreFdKHR(VkDevice device, @NativeType(value="VkSemaphoreGetFdInfoKHR const *") VkSemaphoreGetFdInfoKHR pGetFdInfo, @NativeType(value="int *") int[] pFd) {
        long __functionAddress = device.getCapabilities().vkGetSemaphoreFdKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pFd, 1);
        }
        return JNI.callPPPI(__functionAddress, device.address(), pGetFdInfo.address(), pFd);
    }
}

