/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDeviceGroupProperties;

public class KHRDeviceGroupCreation {
    public static final int VK_KHR_DEVICE_GROUP_CREATION_SPEC_VERSION = 1;
    public static final String VK_KHR_DEVICE_GROUP_CREATION_EXTENSION_NAME = "VK_KHR_device_group_creation";
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES_KHR = 1000070000;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO_KHR = 1000070001;
    public static final int VK_MAX_DEVICE_GROUP_SIZE_KHR = 32;
    public static final int VK_MEMORY_HEAP_MULTI_INSTANCE_BIT_KHR = 2;

    protected KHRDeviceGroupCreation() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsInstance(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_KHR_DEVICE_GROUP_CREATION_EXTENSION_NAME) && VK.checkExtension(VK_KHR_DEVICE_GROUP_CREATION_EXTENSION_NAME, VK.isSupported(provider, "vkEnumeratePhysicalDeviceGroupsKHR", caps));
    }

    public static int nvkEnumeratePhysicalDeviceGroupsKHR(VkInstance instance, long pPhysicalDeviceGroupCount, long pPhysicalDeviceGroupProperties) {
        long __functionAddress = instance.getCapabilities().vkEnumeratePhysicalDeviceGroupsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, instance.address(), pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties);
    }

    @NativeType(value="VkResult")
    public static int vkEnumeratePhysicalDeviceGroupsKHR(VkInstance instance, @NativeType(value="uint32_t *") IntBuffer pPhysicalDeviceGroupCount, @Nullable @NativeType(value="VkPhysicalDeviceGroupProperties *") VkPhysicalDeviceGroupProperties.Buffer pPhysicalDeviceGroupProperties) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPhysicalDeviceGroupCount, 1);
            Checks.checkSafe(pPhysicalDeviceGroupProperties, pPhysicalDeviceGroupCount.get(pPhysicalDeviceGroupCount.position()));
        }
        return KHRDeviceGroupCreation.nvkEnumeratePhysicalDeviceGroupsKHR(instance, MemoryUtil.memAddress(pPhysicalDeviceGroupCount), MemoryUtil.memAddressSafe(pPhysicalDeviceGroupProperties));
    }

    @NativeType(value="VkResult")
    public static int vkEnumeratePhysicalDeviceGroupsKHR(VkInstance instance, @NativeType(value="uint32_t *") int[] pPhysicalDeviceGroupCount, @Nullable @NativeType(value="VkPhysicalDeviceGroupProperties *") VkPhysicalDeviceGroupProperties.Buffer pPhysicalDeviceGroupProperties) {
        long __functionAddress = instance.getCapabilities().vkEnumeratePhysicalDeviceGroupsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pPhysicalDeviceGroupCount, 1);
            Checks.checkSafe(pPhysicalDeviceGroupProperties, pPhysicalDeviceGroupCount[0]);
        }
        return JNI.callPPPI(__functionAddress, instance.address(), pPhysicalDeviceGroupCount, MemoryUtil.memAddressSafe(pPhysicalDeviceGroupProperties));
    }
}

