/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkValidationCacheCreateInfoEXT;

public class EXTValidationCache {
    public static final int VK_EXT_VALIDATION_CACHE_SPEC_VERSION = 1;
    public static final String VK_EXT_VALIDATION_CACHE_EXTENSION_NAME = "VK_EXT_validation_cache";
    public static final int VK_STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT = 1000160000;
    public static final int VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT = 1000160001;
    public static final int VK_OBJECT_TYPE_VALIDATION_CACHE_EXT = 1000160000;
    public static final int VK_VALIDATION_CACHE_HEADER_VERSION_ONE_EXT = 1;

    protected EXTValidationCache() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_EXT_VALIDATION_CACHE_EXTENSION_NAME) && VK.checkExtension(VK_EXT_VALIDATION_CACHE_EXTENSION_NAME, VK.isSupported(provider, "vkCreateValidationCacheEXT", caps) && VK.isSupported(provider, "vkDestroyValidationCacheEXT", caps) && VK.isSupported(provider, "vkMergeValidationCachesEXT", caps) && VK.isSupported(provider, "vkGetValidationCacheDataEXT", caps));
    }

    public static int nvkCreateValidationCacheEXT(VkDevice device, long pCreateInfo, long pAllocator, long pValidationCache) {
        long __functionAddress = device.getCapabilities().vkCreateValidationCacheEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkValidationCacheCreateInfoEXT.validate(pCreateInfo);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        return JNI.callPPPPI(__functionAddress, device.address(), pCreateInfo, pAllocator, pValidationCache);
    }

    @NativeType(value="VkResult")
    public static int vkCreateValidationCacheEXT(VkDevice device, @NativeType(value="VkValidationCacheCreateInfoEXT const *") VkValidationCacheCreateInfoEXT pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkValidationCacheEXT *") LongBuffer pValidationCache) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pValidationCache, 1);
        }
        return EXTValidationCache.nvkCreateValidationCacheEXT(device, pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), MemoryUtil.memAddress(pValidationCache));
    }

    public static void nvkDestroyValidationCacheEXT(VkDevice device, long validationCache, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyValidationCacheEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        JNI.callPJPV(__functionAddress, device.address(), validationCache, pAllocator);
    }

    public static void vkDestroyValidationCacheEXT(VkDevice device, @NativeType(value="VkValidationCacheEXT") long validationCache, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        EXTValidationCache.nvkDestroyValidationCacheEXT(device, validationCache, MemoryUtil.memAddressSafe(pAllocator));
    }

    public static int nvkMergeValidationCachesEXT(VkDevice device, long dstCache, int srcCacheCount, long pSrcCaches) {
        long __functionAddress = device.getCapabilities().vkMergeValidationCachesEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(__functionAddress, device.address(), dstCache, srcCacheCount, pSrcCaches);
    }

    @NativeType(value="VkResult")
    public static int vkMergeValidationCachesEXT(VkDevice device, @NativeType(value="VkValidationCacheEXT") long dstCache, @NativeType(value="VkValidationCacheEXT const *") LongBuffer pSrcCaches) {
        return EXTValidationCache.nvkMergeValidationCachesEXT(device, dstCache, pSrcCaches.remaining(), MemoryUtil.memAddress(pSrcCaches));
    }

    public static int nvkGetValidationCacheDataEXT(VkDevice device, long validationCache, long pDataSize, long pData) {
        long __functionAddress = device.getCapabilities().vkGetValidationCacheDataEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(__functionAddress, device.address(), validationCache, pDataSize, pData);
    }

    @NativeType(value="VkResult")
    public static int vkGetValidationCacheDataEXT(VkDevice device, @NativeType(value="VkValidationCacheEXT") long validationCache, @NativeType(value="size_t *") PointerBuffer pDataSize, @Nullable @NativeType(value="void *") ByteBuffer pData) {
        if (Checks.CHECKS) {
            Checks.check(pDataSize, 1);
            Checks.checkSafe((Buffer)pData, pDataSize.get(pDataSize.position()));
        }
        return EXTValidationCache.nvkGetValidationCacheDataEXT(device, validationCache, MemoryUtil.memAddress(pDataSize), MemoryUtil.memAddressSafe(pData));
    }

    @NativeType(value="VkResult")
    public static int vkCreateValidationCacheEXT(VkDevice device, @NativeType(value="VkValidationCacheCreateInfoEXT const *") VkValidationCacheCreateInfoEXT pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkValidationCacheEXT *") long[] pValidationCache) {
        long __functionAddress = device.getCapabilities().vkCreateValidationCacheEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pValidationCache, 1);
            VkValidationCacheCreateInfoEXT.validate(pCreateInfo.address());
            if (pAllocator != null) {
                VkAllocationCallbacks.validate(pAllocator.address());
            }
        }
        return JNI.callPPPPI(__functionAddress, device.address(), pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), pValidationCache);
    }

    @NativeType(value="VkResult")
    public static int vkMergeValidationCachesEXT(VkDevice device, @NativeType(value="VkValidationCacheEXT") long dstCache, @NativeType(value="VkValidationCacheEXT const *") long[] pSrcCaches) {
        long __functionAddress = device.getCapabilities().vkMergeValidationCachesEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(__functionAddress, device.address(), dstCache, pSrcCaches.length, pSrcCaches);
    }
}

