/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.util.Map;
import java.util.Set;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkDebugMarkerMarkerInfoEXT;
import org.lwjgl.vulkan.VkDebugMarkerObjectNameInfoEXT;
import org.lwjgl.vulkan.VkDebugMarkerObjectTagInfoEXT;
import org.lwjgl.vulkan.VkDevice;

public class EXTDebugMarker {
    public static final int VK_EXT_DEBUG_MARKER_SPEC_VERSION = 4;
    public static final String VK_EXT_DEBUG_MARKER_EXTENSION_NAME = "VK_EXT_debug_marker";
    public static final int VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT = 1000022000;
    public static final int VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT = 1000022001;
    public static final int VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT = 1000022002;

    protected EXTDebugMarker() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_EXT_DEBUG_MARKER_EXTENSION_NAME) && VK.checkExtension(VK_EXT_DEBUG_MARKER_EXTENSION_NAME, VK.isSupported(provider, "vkDebugMarkerSetObjectTagEXT", caps) && VK.isSupported(provider, "vkDebugMarkerSetObjectNameEXT", caps) && VK.isSupported(provider, "vkCmdDebugMarkerBeginEXT", caps) && VK.isSupported(provider, "vkCmdDebugMarkerEndEXT", caps) && VK.isSupported(provider, "vkCmdDebugMarkerInsertEXT", caps));
    }

    public static int nvkDebugMarkerSetObjectTagEXT(VkDevice device, long pTagInfo) {
        long __functionAddress = device.getCapabilities().vkDebugMarkerSetObjectTagEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkDebugMarkerObjectTagInfoEXT.validate(pTagInfo);
        }
        return JNI.callPPI(__functionAddress, device.address(), pTagInfo);
    }

    @NativeType(value="VkResult")
    public static int vkDebugMarkerSetObjectTagEXT(VkDevice device, @NativeType(value="VkDebugMarkerObjectTagInfoEXT const *") VkDebugMarkerObjectTagInfoEXT pTagInfo) {
        return EXTDebugMarker.nvkDebugMarkerSetObjectTagEXT(device, pTagInfo.address());
    }

    public static int nvkDebugMarkerSetObjectNameEXT(VkDevice device, long pNameInfo) {
        long __functionAddress = device.getCapabilities().vkDebugMarkerSetObjectNameEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkDebugMarkerObjectNameInfoEXT.validate(pNameInfo);
        }
        return JNI.callPPI(__functionAddress, device.address(), pNameInfo);
    }

    @NativeType(value="VkResult")
    public static int vkDebugMarkerSetObjectNameEXT(VkDevice device, @NativeType(value="VkDebugMarkerObjectNameInfoEXT const *") VkDebugMarkerObjectNameInfoEXT pNameInfo) {
        return EXTDebugMarker.nvkDebugMarkerSetObjectNameEXT(device, pNameInfo.address());
    }

    public static void nvkCmdDebugMarkerBeginEXT(VkCommandBuffer commandBuffer, long pMarkerInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdDebugMarkerBeginEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkDebugMarkerMarkerInfoEXT.validate(pMarkerInfo);
        }
        JNI.callPPV(__functionAddress, commandBuffer.address(), pMarkerInfo);
    }

    public static void vkCmdDebugMarkerBeginEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkDebugMarkerMarkerInfoEXT const *") VkDebugMarkerMarkerInfoEXT pMarkerInfo) {
        EXTDebugMarker.nvkCmdDebugMarkerBeginEXT(commandBuffer, pMarkerInfo.address());
    }

    public static void vkCmdDebugMarkerEndEXT(VkCommandBuffer commandBuffer) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdDebugMarkerEndEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, commandBuffer.address());
    }

    public static void nvkCmdDebugMarkerInsertEXT(VkCommandBuffer commandBuffer, long pMarkerInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdDebugMarkerInsertEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkDebugMarkerMarkerInfoEXT.validate(pMarkerInfo);
        }
        JNI.callPPV(__functionAddress, commandBuffer.address(), pMarkerInfo);
    }

    public static void vkCmdDebugMarkerInsertEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkDebugMarkerMarkerInfoEXT const *") VkDebugMarkerMarkerInfoEXT pMarkerInfo) {
        EXTDebugMarker.nvkCmdDebugMarkerInsertEXT(commandBuffer, pMarkerInfo.address());
    }
}

