/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.zstd.ZDICTParams;

@NativeType(value="struct ZDICT_cover_params_t")
public class ZDICTCoverParams
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int K;
    public static final int D;
    public static final int STEPS;
    public static final int NBTHREADS;
    public static final int ZPARAMS;

    ZDICTCoverParams(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public ZDICTCoverParams(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), ZDICTCoverParams.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned")
    public int k() {
        return ZDICTCoverParams.nk(this.address());
    }

    @NativeType(value="unsigned")
    public int d() {
        return ZDICTCoverParams.nd(this.address());
    }

    @NativeType(value="unsigned")
    public int steps() {
        return ZDICTCoverParams.nsteps(this.address());
    }

    @NativeType(value="unsigned")
    public int nbThreads() {
        return ZDICTCoverParams.nnbThreads(this.address());
    }

    @NativeType(value="ZDICT_params_t")
    public ZDICTParams zParams() {
        return ZDICTCoverParams.nzParams(this.address());
    }

    public ZDICTCoverParams zParams(Consumer<ZDICTParams> consumer) {
        consumer.accept(this.zParams());
        return this;
    }

    public ZDICTCoverParams k(@NativeType(value="unsigned") int value) {
        ZDICTCoverParams.nk(this.address(), value);
        return this;
    }

    public ZDICTCoverParams d(@NativeType(value="unsigned") int value) {
        ZDICTCoverParams.nd(this.address(), value);
        return this;
    }

    public ZDICTCoverParams steps(@NativeType(value="unsigned") int value) {
        ZDICTCoverParams.nsteps(this.address(), value);
        return this;
    }

    public ZDICTCoverParams nbThreads(@NativeType(value="unsigned") int value) {
        ZDICTCoverParams.nnbThreads(this.address(), value);
        return this;
    }

    public ZDICTCoverParams zParams(@NativeType(value="ZDICT_params_t") ZDICTParams value) {
        ZDICTCoverParams.nzParams(this.address(), value);
        return this;
    }

    public ZDICTCoverParams set(int k, int d, int steps, int nbThreads, ZDICTParams zParams) {
        this.k(k);
        this.d(d);
        this.steps(steps);
        this.nbThreads(nbThreads);
        this.zParams(zParams);
        return this;
    }

    public ZDICTCoverParams set(ZDICTCoverParams src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static ZDICTCoverParams malloc() {
        return ZDICTCoverParams.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static ZDICTCoverParams calloc() {
        return ZDICTCoverParams.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static ZDICTCoverParams create() {
        return new ZDICTCoverParams(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static ZDICTCoverParams create(long address) {
        return new ZDICTCoverParams(address, null);
    }

    @Nullable
    public static ZDICTCoverParams createSafe(long address) {
        return address == 0L ? null : ZDICTCoverParams.create(address);
    }

    public static Buffer malloc(int capacity) {
        return ZDICTCoverParams.create(ZDICTCoverParams.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return ZDICTCoverParams.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(ZDICTCoverParams.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : ZDICTCoverParams.create(address, capacity);
    }

    public static ZDICTCoverParams mallocStack() {
        return ZDICTCoverParams.mallocStack(MemoryStack.stackGet());
    }

    public static ZDICTCoverParams callocStack() {
        return ZDICTCoverParams.callocStack(MemoryStack.stackGet());
    }

    public static ZDICTCoverParams mallocStack(MemoryStack stack) {
        return ZDICTCoverParams.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZDICTCoverParams callocStack(MemoryStack stack) {
        return ZDICTCoverParams.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return ZDICTCoverParams.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return ZDICTCoverParams.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZDICTCoverParams.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZDICTCoverParams.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nk(long struct) {
        return MemoryUtil.memGetInt(struct + (long)K);
    }

    public static int nd(long struct) {
        return MemoryUtil.memGetInt(struct + (long)D);
    }

    public static int nsteps(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STEPS);
    }

    public static int nnbThreads(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NBTHREADS);
    }

    public static ZDICTParams nzParams(long struct) {
        return ZDICTParams.create(struct + (long)ZPARAMS);
    }

    public static void nk(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)K, value);
    }

    public static void nd(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)D, value);
    }

    public static void nsteps(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STEPS, value);
    }

    public static void nnbThreads(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NBTHREADS, value);
    }

    public static void nzParams(long struct, ZDICTParams value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ZPARAMS, ZDICTParams.SIZEOF);
    }

    static {
        Struct.Layout layout = ZDICTCoverParams.__struct(ZDICTCoverParams.__member(4), ZDICTCoverParams.__member(4), ZDICTCoverParams.__member(4), ZDICTCoverParams.__member(4), ZDICTCoverParams.__member(ZDICTParams.SIZEOF, ZDICTParams.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        K = layout.offsetof(0);
        D = layout.offsetof(1);
        STEPS = layout.offsetof(2);
        NBTHREADS = layout.offsetof(3);
        ZPARAMS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<ZDICTCoverParams, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected ZDICTCoverParams newInstance(long address) {
            return new ZDICTCoverParams(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="unsigned")
        public int k() {
            return ZDICTCoverParams.nk(this.address());
        }

        @NativeType(value="unsigned")
        public int d() {
            return ZDICTCoverParams.nd(this.address());
        }

        @NativeType(value="unsigned")
        public int steps() {
            return ZDICTCoverParams.nsteps(this.address());
        }

        @NativeType(value="unsigned")
        public int nbThreads() {
            return ZDICTCoverParams.nnbThreads(this.address());
        }

        @NativeType(value="ZDICT_params_t")
        public ZDICTParams zParams() {
            return ZDICTCoverParams.nzParams(this.address());
        }

        public Buffer zParams(Consumer<ZDICTParams> consumer) {
            consumer.accept(this.zParams());
            return this;
        }

        public Buffer k(@NativeType(value="unsigned") int value) {
            ZDICTCoverParams.nk(this.address(), value);
            return this;
        }

        public Buffer d(@NativeType(value="unsigned") int value) {
            ZDICTCoverParams.nd(this.address(), value);
            return this;
        }

        public Buffer steps(@NativeType(value="unsigned") int value) {
            ZDICTCoverParams.nsteps(this.address(), value);
            return this;
        }

        public Buffer nbThreads(@NativeType(value="unsigned") int value) {
            ZDICTCoverParams.nnbThreads(this.address(), value);
            return this;
        }

        public Buffer zParams(@NativeType(value="ZDICT_params_t") ZDICTParams value) {
            ZDICTCoverParams.nzParams(this.address(), value);
            return this;
        }
    }
}

