/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class YGSize
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;

    YGSize(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public YGSize(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), YGSize.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float width() {
        return YGSize.nwidth(this.address());
    }

    public float height() {
        return YGSize.nheight(this.address());
    }

    public YGSize width(float value) {
        YGSize.nwidth(this.address(), value);
        return this;
    }

    public YGSize height(float value) {
        YGSize.nheight(this.address(), value);
        return this;
    }

    public YGSize set(float width, float height) {
        this.width(width);
        this.height(height);
        return this;
    }

    public YGSize set(YGSize src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static YGSize malloc() {
        return YGSize.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static YGSize calloc() {
        return YGSize.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static YGSize create() {
        return new YGSize(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static YGSize create(long address) {
        return new YGSize(address, null);
    }

    @Nullable
    public static YGSize createSafe(long address) {
        return address == 0L ? null : YGSize.create(address);
    }

    public static Buffer malloc(int capacity) {
        return YGSize.create(YGSize.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return YGSize.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(YGSize.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : YGSize.create(address, capacity);
    }

    public static YGSize mallocStack() {
        return YGSize.mallocStack(MemoryStack.stackGet());
    }

    public static YGSize callocStack() {
        return YGSize.callocStack(MemoryStack.stackGet());
    }

    public static YGSize mallocStack(MemoryStack stack) {
        return YGSize.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static YGSize callocStack(MemoryStack stack) {
        return YGSize.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return YGSize.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return YGSize.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return YGSize.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return YGSize.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nwidth(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)WIDTH);
    }

    public static float nheight(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)HEIGHT);
    }

    public static void nwidth(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)HEIGHT, value);
    }

    static {
        Struct.Layout layout = YGSize.__struct(YGSize.__member(4), YGSize.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<YGSize, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected YGSize newInstance(long address) {
            return new YGSize(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float width() {
            return YGSize.nwidth(this.address());
        }

        public float height() {
            return YGSize.nheight(this.address());
        }

        public Buffer width(float value) {
            YGSize.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(float value) {
            YGSize.nheight(this.address(), value);
            return this;
        }
    }
}

