/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.yoga.YGCachedMeasurement;
import org.lwjgl.util.yoga.YGFloatOptional;

public class YGLayout
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POSITIONS;
    public static final int DIMENSIONS;
    public static final int MARGIN;
    public static final int BORDER;
    public static final int PADDING;
    public static final int DIRECTION;
    public static final int COMPUTEDFLEXBASISGENERATION;
    public static final int COMPUTEDFLEXBASIS;
    public static final int HADOVERFLOW;
    public static final int GENERATIONCOUNT;
    public static final int LASTOWNERDIRECTION;
    public static final int NEXTCACHEDMEASUREMENTSINDEX;
    public static final int CACHEDMEASUREMENTS;
    public static final int MEASUREDDIMENSIONS;
    public static final int CACHEDLAYOUT;
    public static final int DIDUSELEGACYFLAG;
    public static final int DOESLEGACYSTRETCHFLAGAFFECTSLAYOUT;

    YGLayout(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public YGLayout(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), YGLayout.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[4]")
    public FloatBuffer positions() {
        return YGLayout.npositions(this.address());
    }

    public float positions(int index) {
        return YGLayout.npositions(this.address(), index);
    }

    @NativeType(value="float[2]")
    public FloatBuffer dimensions() {
        return YGLayout.ndimensions(this.address());
    }

    public float dimensions(int index) {
        return YGLayout.ndimensions(this.address(), index);
    }

    @NativeType(value="float[6]")
    public FloatBuffer margin() {
        return YGLayout.nmargin(this.address());
    }

    public float margin(int index) {
        return YGLayout.nmargin(this.address(), index);
    }

    @NativeType(value="float[6]")
    public FloatBuffer border() {
        return YGLayout.nborder(this.address());
    }

    public float border(int index) {
        return YGLayout.nborder(this.address(), index);
    }

    @NativeType(value="float[6]")
    public FloatBuffer padding() {
        return YGLayout.npadding(this.address());
    }

    public float padding(int index) {
        return YGLayout.npadding(this.address(), index);
    }

    @NativeType(value="YGDirection")
    public int direction() {
        return YGLayout.ndirection(this.address());
    }

    @NativeType(value="uint32_t")
    public int computedFlexBasisGeneration() {
        return YGLayout.ncomputedFlexBasisGeneration(this.address());
    }

    public YGFloatOptional computedFlexBasis() {
        return YGLayout.ncomputedFlexBasis(this.address());
    }

    @NativeType(value="bool")
    public boolean hadOverflow() {
        return YGLayout.nhadOverflow(this.address());
    }

    @NativeType(value="uint32_t")
    public int generationCount() {
        return YGLayout.ngenerationCount(this.address());
    }

    @NativeType(value="YGDirection")
    public int lastOwnerDirection() {
        return YGLayout.nlastOwnerDirection(this.address());
    }

    @NativeType(value="uint32_t")
    public int nextCachedMeasurementsIndex() {
        return YGLayout.nnextCachedMeasurementsIndex(this.address());
    }

    @NativeType(value="YGCachedMeasurement[16]")
    public YGCachedMeasurement.Buffer cachedMeasurements() {
        return YGLayout.ncachedMeasurements(this.address());
    }

    public YGCachedMeasurement cachedMeasurements(int index) {
        return YGLayout.ncachedMeasurements(this.address(), index);
    }

    @NativeType(value="float[2]")
    public FloatBuffer measuredDimensions() {
        return YGLayout.nmeasuredDimensions(this.address());
    }

    public float measuredDimensions(int index) {
        return YGLayout.nmeasuredDimensions(this.address(), index);
    }

    public YGCachedMeasurement cachedLayout() {
        return YGLayout.ncachedLayout(this.address());
    }

    @NativeType(value="bool")
    public boolean didUseLegacyFlag() {
        return YGLayout.ndidUseLegacyFlag(this.address());
    }

    @NativeType(value="bool")
    public boolean doesLegacyStretchFlagAffectsLayout() {
        return YGLayout.ndoesLegacyStretchFlagAffectsLayout(this.address());
    }

    public static YGLayout create(long address) {
        return new YGLayout(address, null);
    }

    @Nullable
    public static YGLayout createSafe(long address) {
        return address == 0L ? null : YGLayout.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : YGLayout.create(address, capacity);
    }

    public static FloatBuffer npositions(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)POSITIONS, 4);
    }

    public static float npositions(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)POSITIONS + Checks.check(index, 4) * 4L);
    }

    public static FloatBuffer ndimensions(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)DIMENSIONS, 2);
    }

    public static float ndimensions(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)DIMENSIONS + Checks.check(index, 2) * 4L);
    }

    public static FloatBuffer nmargin(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)MARGIN, 6);
    }

    public static float nmargin(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)MARGIN + Checks.check(index, 6) * 4L);
    }

    public static FloatBuffer nborder(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)BORDER, 6);
    }

    public static float nborder(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)BORDER + Checks.check(index, 6) * 4L);
    }

    public static FloatBuffer npadding(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)PADDING, 6);
    }

    public static float npadding(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)PADDING + Checks.check(index, 6) * 4L);
    }

    public static int ndirection(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DIRECTION);
    }

    public static int ncomputedFlexBasisGeneration(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMPUTEDFLEXBASISGENERATION);
    }

    public static YGFloatOptional ncomputedFlexBasis(long struct) {
        return YGFloatOptional.create(struct + (long)COMPUTEDFLEXBASIS);
    }

    public static boolean nhadOverflow(long struct) {
        return MemoryUtil.memGetByte(struct + (long)HADOVERFLOW) != 0;
    }

    public static int ngenerationCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)GENERATIONCOUNT);
    }

    public static int nlastOwnerDirection(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LASTOWNERDIRECTION);
    }

    public static int nnextCachedMeasurementsIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NEXTCACHEDMEASUREMENTSINDEX);
    }

    public static YGCachedMeasurement.Buffer ncachedMeasurements(long struct) {
        return YGCachedMeasurement.create(struct + (long)CACHEDMEASUREMENTS, 16);
    }

    public static YGCachedMeasurement ncachedMeasurements(long struct, int index) {
        return YGCachedMeasurement.create(struct + (long)CACHEDMEASUREMENTS + Checks.check(index, 16) * (long)YGCachedMeasurement.SIZEOF);
    }

    public static FloatBuffer nmeasuredDimensions(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)MEASUREDDIMENSIONS, 2);
    }

    public static float nmeasuredDimensions(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)MEASUREDDIMENSIONS + Checks.check(index, 2) * 4L);
    }

    public static YGCachedMeasurement ncachedLayout(long struct) {
        return YGCachedMeasurement.create(struct + (long)CACHEDLAYOUT);
    }

    public static boolean ndidUseLegacyFlag(long struct) {
        return MemoryUtil.memGetByte(struct + (long)DIDUSELEGACYFLAG) != 0;
    }

    public static boolean ndoesLegacyStretchFlagAffectsLayout(long struct) {
        return MemoryUtil.memGetByte(struct + (long)DOESLEGACYSTRETCHFLAGAFFECTSLAYOUT) != 0;
    }

    static {
        Struct.Layout layout = YGLayout.__struct(YGLayout.__array(4, 4), YGLayout.__array(4, 2), YGLayout.__array(4, 6), YGLayout.__array(4, 6), YGLayout.__array(4, 6), YGLayout.__member(4), YGLayout.__member(4), YGLayout.__member(YGFloatOptional.SIZEOF, YGFloatOptional.ALIGNOF), YGLayout.__member(1), YGLayout.__member(4), YGLayout.__member(4), YGLayout.__member(4), YGLayout.__array(YGCachedMeasurement.SIZEOF, YGCachedMeasurement.ALIGNOF, 16), YGLayout.__array(4, 2), YGLayout.__member(YGCachedMeasurement.SIZEOF, YGCachedMeasurement.ALIGNOF), YGLayout.__member(1), YGLayout.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POSITIONS = layout.offsetof(0);
        DIMENSIONS = layout.offsetof(1);
        MARGIN = layout.offsetof(2);
        BORDER = layout.offsetof(3);
        PADDING = layout.offsetof(4);
        DIRECTION = layout.offsetof(5);
        COMPUTEDFLEXBASISGENERATION = layout.offsetof(6);
        COMPUTEDFLEXBASIS = layout.offsetof(7);
        HADOVERFLOW = layout.offsetof(8);
        GENERATIONCOUNT = layout.offsetof(9);
        LASTOWNERDIRECTION = layout.offsetof(10);
        NEXTCACHEDMEASUREMENTSINDEX = layout.offsetof(11);
        CACHEDMEASUREMENTS = layout.offsetof(12);
        MEASUREDDIMENSIONS = layout.offsetof(13);
        CACHEDLAYOUT = layout.offsetof(14);
        DIDUSELEGACYFLAG = layout.offsetof(15);
        DOESLEGACYSTRETCHFLAGAFFECTSLAYOUT = layout.offsetof(16);
    }

    public static class Buffer
    extends StructBuffer<YGLayout, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected YGLayout newInstance(long address) {
            return new YGLayout(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="float[4]")
        public FloatBuffer positions() {
            return YGLayout.npositions(this.address());
        }

        public float positions(int index) {
            return YGLayout.npositions(this.address(), index);
        }

        @NativeType(value="float[2]")
        public FloatBuffer dimensions() {
            return YGLayout.ndimensions(this.address());
        }

        public float dimensions(int index) {
            return YGLayout.ndimensions(this.address(), index);
        }

        @NativeType(value="float[6]")
        public FloatBuffer margin() {
            return YGLayout.nmargin(this.address());
        }

        public float margin(int index) {
            return YGLayout.nmargin(this.address(), index);
        }

        @NativeType(value="float[6]")
        public FloatBuffer border() {
            return YGLayout.nborder(this.address());
        }

        public float border(int index) {
            return YGLayout.nborder(this.address(), index);
        }

        @NativeType(value="float[6]")
        public FloatBuffer padding() {
            return YGLayout.npadding(this.address());
        }

        public float padding(int index) {
            return YGLayout.npadding(this.address(), index);
        }

        @NativeType(value="YGDirection")
        public int direction() {
            return YGLayout.ndirection(this.address());
        }

        @NativeType(value="uint32_t")
        public int computedFlexBasisGeneration() {
            return YGLayout.ncomputedFlexBasisGeneration(this.address());
        }

        public YGFloatOptional computedFlexBasis() {
            return YGLayout.ncomputedFlexBasis(this.address());
        }

        @NativeType(value="bool")
        public boolean hadOverflow() {
            return YGLayout.nhadOverflow(this.address());
        }

        @NativeType(value="uint32_t")
        public int generationCount() {
            return YGLayout.ngenerationCount(this.address());
        }

        @NativeType(value="YGDirection")
        public int lastOwnerDirection() {
            return YGLayout.nlastOwnerDirection(this.address());
        }

        @NativeType(value="uint32_t")
        public int nextCachedMeasurementsIndex() {
            return YGLayout.nnextCachedMeasurementsIndex(this.address());
        }

        @NativeType(value="YGCachedMeasurement[16]")
        public YGCachedMeasurement.Buffer cachedMeasurements() {
            return YGLayout.ncachedMeasurements(this.address());
        }

        public YGCachedMeasurement cachedMeasurements(int index) {
            return YGLayout.ncachedMeasurements(this.address(), index);
        }

        @NativeType(value="float[2]")
        public FloatBuffer measuredDimensions() {
            return YGLayout.nmeasuredDimensions(this.address());
        }

        public float measuredDimensions(int index) {
            return YGLayout.nmeasuredDimensions(this.address(), index);
        }

        public YGCachedMeasurement cachedLayout() {
            return YGLayout.ncachedLayout(this.address());
        }

        @NativeType(value="bool")
        public boolean didUseLegacyFlag() {
            return YGLayout.ndidUseLegacyFlag(this.address());
        }

        @NativeType(value="bool")
        public boolean doesLegacyStretchFlagAffectsLayout() {
            return YGLayout.ndoesLegacyStretchFlagAffectsLayout(this.address());
        }
    }
}

