/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class YGFloatOptional
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VALUE;
    public static final int ISUNDEFINED;

    YGFloatOptional(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public YGFloatOptional(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), YGFloatOptional.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float value() {
        return YGFloatOptional.nvalue(this.address());
    }

    @NativeType(value="bool")
    public boolean isUndefined() {
        return YGFloatOptional.nisUndefined(this.address());
    }

    public static YGFloatOptional create(long address) {
        return new YGFloatOptional(address, null);
    }

    @Nullable
    public static YGFloatOptional createSafe(long address) {
        return address == 0L ? null : YGFloatOptional.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : YGFloatOptional.create(address, capacity);
    }

    public static float nvalue(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)VALUE);
    }

    public static boolean nisUndefined(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ISUNDEFINED) != 0;
    }

    static {
        Struct.Layout layout = YGFloatOptional.__struct(YGFloatOptional.__member(4), YGFloatOptional.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VALUE = layout.offsetof(0);
        ISUNDEFINED = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<YGFloatOptional, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected YGFloatOptional newInstance(long address) {
            return new YGFloatOptional(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float value() {
            return YGFloatOptional.nvalue(this.address());
        }

        @NativeType(value="bool")
        public boolean isUndefined() {
            return YGFloatOptional.nisUndefined(this.address());
        }
    }
}

