/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.vulkan.VKCapabilitiesDevice;
import org.lwjgl.vulkan.VKCapabilitiesInstance;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkInstance;

public class VmaVulkanFunctions
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VKGETPHYSICALDEVICEPROPERTIES;
    public static final int VKGETPHYSICALDEVICEMEMORYPROPERTIES;
    public static final int VKALLOCATEMEMORY;
    public static final int VKFREEMEMORY;
    public static final int VKMAPMEMORY;
    public static final int VKUNMAPMEMORY;
    public static final int VKBINDBUFFERMEMORY;
    public static final int VKBINDIMAGEMEMORY;
    public static final int VKGETBUFFERMEMORYREQUIREMENTS;
    public static final int VKGETIMAGEMEMORYREQUIREMENTS;
    public static final int VKCREATEBUFFER;
    public static final int VKDESTROYBUFFER;
    public static final int VKCREATEIMAGE;
    public static final int VKDESTROYIMAGE;
    public static final int VKGETBUFFERMEMORYREQUIREMENTS2KHR;
    public static final int VKGETIMAGEMEMORYREQUIREMENTS2KHR;

    VmaVulkanFunctions(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VmaVulkanFunctions(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VmaVulkanFunctions.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="PFN_vkGetPhysicalDeviceProperties")
    public long vkGetPhysicalDeviceProperties() {
        return VmaVulkanFunctions.nvkGetPhysicalDeviceProperties(this.address());
    }

    @NativeType(value="PFN_vkGetPhysicalDeviceMemoryProperties")
    public long vkGetPhysicalDeviceMemoryProperties() {
        return VmaVulkanFunctions.nvkGetPhysicalDeviceMemoryProperties(this.address());
    }

    @NativeType(value="PFN_vkAllocateMemory")
    public long vkAllocateMemory() {
        return VmaVulkanFunctions.nvkAllocateMemory(this.address());
    }

    @NativeType(value="PFN_vkFreeMemory")
    public long vkFreeMemory() {
        return VmaVulkanFunctions.nvkFreeMemory(this.address());
    }

    @NativeType(value="PFN_vkMapMemory")
    public long vkMapMemory() {
        return VmaVulkanFunctions.nvkMapMemory(this.address());
    }

    @NativeType(value="PFN_vkUnmapMemory")
    public long vkUnmapMemory() {
        return VmaVulkanFunctions.nvkUnmapMemory(this.address());
    }

    @NativeType(value="PFN_vkBindBufferMemory")
    public long vkBindBufferMemory() {
        return VmaVulkanFunctions.nvkBindBufferMemory(this.address());
    }

    @NativeType(value="PFN_vkBindImageMemory")
    public long vkBindImageMemory() {
        return VmaVulkanFunctions.nvkBindImageMemory(this.address());
    }

    @NativeType(value="PFN_vkGetBufferMemoryRequirements")
    public long vkGetBufferMemoryRequirements() {
        return VmaVulkanFunctions.nvkGetBufferMemoryRequirements(this.address());
    }

    @NativeType(value="PFN_vkGetImageMemoryRequirements")
    public long vkGetImageMemoryRequirements() {
        return VmaVulkanFunctions.nvkGetImageMemoryRequirements(this.address());
    }

    @NativeType(value="PFN_vkCreateBuffer")
    public long vkCreateBuffer() {
        return VmaVulkanFunctions.nvkCreateBuffer(this.address());
    }

    @NativeType(value="PFN_vkDestroyBuffer")
    public long vkDestroyBuffer() {
        return VmaVulkanFunctions.nvkDestroyBuffer(this.address());
    }

    @NativeType(value="PFN_vkCreateImage")
    public long vkCreateImage() {
        return VmaVulkanFunctions.nvkCreateImage(this.address());
    }

    @NativeType(value="PFN_vkDestroyImage")
    public long vkDestroyImage() {
        return VmaVulkanFunctions.nvkDestroyImage(this.address());
    }

    @NativeType(value="PFN_vkGetBufferMemoryRequirements2KHR")
    public long vkGetBufferMemoryRequirements2KHR() {
        return VmaVulkanFunctions.nvkGetBufferMemoryRequirements2KHR(this.address());
    }

    @NativeType(value="PFN_vkGetImageMemoryRequirements2KHR")
    public long vkGetImageMemoryRequirements2KHR() {
        return VmaVulkanFunctions.nvkGetImageMemoryRequirements2KHR(this.address());
    }

    public VmaVulkanFunctions vkGetPhysicalDeviceProperties(@NativeType(value="PFN_vkGetPhysicalDeviceProperties") long value) {
        VmaVulkanFunctions.nvkGetPhysicalDeviceProperties(this.address(), value);
        return this;
    }

    public VmaVulkanFunctions vkGetPhysicalDeviceMemoryProperties(@NativeType(value="PFN_vkGetPhysicalDeviceMemoryProperties") long value) {
        VmaVulkanFunctions.nvkGetPhysicalDeviceMemoryProperties(this.address(), value);
        return this;
    }

    public VmaVulkanFunctions vkAllocateMemory(@NativeType(value="PFN_vkAllocateMemory") long value) {
        VmaVulkanFunctions.nvkAllocateMemory(this.address(), value);
        return this;
    }

    public VmaVulkanFunctions vkFreeMemory(@NativeType(value="PFN_vkFreeMemory") long value) {
        VmaVulkanFunctions.nvkFreeMemory(this.address(), value);
        return this;
    }

    public VmaVulkanFunctions vkMapMemory(@NativeType(value="PFN_vkMapMemory") long value) {
        VmaVulkanFunctions.nvkMapMemory(this.address(), value);
        return this;
    }

    public VmaVulkanFunctions vkUnmapMemory(@NativeType(value="PFN_vkUnmapMemory") long value) {
        VmaVulkanFunctions.nvkUnmapMemory(this.address(), value);
        return this;
    }

    public VmaVulkanFunctions vkBindBufferMemory(@NativeType(value="PFN_vkBindBufferMemory") long value) {
        VmaVulkanFunctions.nvkBindBufferMemory(this.address(), value);
        return this;
    }

    public VmaVulkanFunctions vkBindImageMemory(@NativeType(value="PFN_vkBindImageMemory") long value) {
        VmaVulkanFunctions.nvkBindImageMemory(this.address(), value);
        return this;
    }

    public VmaVulkanFunctions vkGetBufferMemoryRequirements(@NativeType(value="PFN_vkGetBufferMemoryRequirements") long value) {
        VmaVulkanFunctions.nvkGetBufferMemoryRequirements(this.address(), value);
        return this;
    }

    public VmaVulkanFunctions vkGetImageMemoryRequirements(@NativeType(value="PFN_vkGetImageMemoryRequirements") long value) {
        VmaVulkanFunctions.nvkGetImageMemoryRequirements(this.address(), value);
        return this;
    }

    public VmaVulkanFunctions vkCreateBuffer(@NativeType(value="PFN_vkCreateBuffer") long value) {
        VmaVulkanFunctions.nvkCreateBuffer(this.address(), value);
        return this;
    }

    public VmaVulkanFunctions vkDestroyBuffer(@NativeType(value="PFN_vkDestroyBuffer") long value) {
        VmaVulkanFunctions.nvkDestroyBuffer(this.address(), value);
        return this;
    }

    public VmaVulkanFunctions vkCreateImage(@NativeType(value="PFN_vkCreateImage") long value) {
        VmaVulkanFunctions.nvkCreateImage(this.address(), value);
        return this;
    }

    public VmaVulkanFunctions vkDestroyImage(@NativeType(value="PFN_vkDestroyImage") long value) {
        VmaVulkanFunctions.nvkDestroyImage(this.address(), value);
        return this;
    }

    public VmaVulkanFunctions vkGetBufferMemoryRequirements2KHR(@NativeType(value="PFN_vkGetBufferMemoryRequirements2KHR") long value) {
        VmaVulkanFunctions.nvkGetBufferMemoryRequirements2KHR(this.address(), value);
        return this;
    }

    public VmaVulkanFunctions vkGetImageMemoryRequirements2KHR(@NativeType(value="PFN_vkGetImageMemoryRequirements2KHR") long value) {
        VmaVulkanFunctions.nvkGetImageMemoryRequirements2KHR(this.address(), value);
        return this;
    }

    public VmaVulkanFunctions set(long vkGetPhysicalDeviceProperties, long vkGetPhysicalDeviceMemoryProperties, long vkAllocateMemory, long vkFreeMemory, long vkMapMemory, long vkUnmapMemory, long vkBindBufferMemory, long vkBindImageMemory, long vkGetBufferMemoryRequirements, long vkGetImageMemoryRequirements, long vkCreateBuffer, long vkDestroyBuffer, long vkCreateImage, long vkDestroyImage, long vkGetBufferMemoryRequirements2KHR, long vkGetImageMemoryRequirements2KHR) {
        this.vkGetPhysicalDeviceProperties(vkGetPhysicalDeviceProperties);
        this.vkGetPhysicalDeviceMemoryProperties(vkGetPhysicalDeviceMemoryProperties);
        this.vkAllocateMemory(vkAllocateMemory);
        this.vkFreeMemory(vkFreeMemory);
        this.vkMapMemory(vkMapMemory);
        this.vkUnmapMemory(vkUnmapMemory);
        this.vkBindBufferMemory(vkBindBufferMemory);
        this.vkBindImageMemory(vkBindImageMemory);
        this.vkGetBufferMemoryRequirements(vkGetBufferMemoryRequirements);
        this.vkGetImageMemoryRequirements(vkGetImageMemoryRequirements);
        this.vkCreateBuffer(vkCreateBuffer);
        this.vkDestroyBuffer(vkDestroyBuffer);
        this.vkCreateImage(vkCreateImage);
        this.vkDestroyImage(vkDestroyImage);
        this.vkGetBufferMemoryRequirements2KHR(vkGetBufferMemoryRequirements2KHR);
        this.vkGetImageMemoryRequirements2KHR(vkGetImageMemoryRequirements2KHR);
        return this;
    }

    public VmaVulkanFunctions set(VmaVulkanFunctions src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VmaVulkanFunctions malloc() {
        return VmaVulkanFunctions.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VmaVulkanFunctions calloc() {
        return VmaVulkanFunctions.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VmaVulkanFunctions create() {
        return new VmaVulkanFunctions(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VmaVulkanFunctions create(long address) {
        return new VmaVulkanFunctions(address, null);
    }

    @Nullable
    public static VmaVulkanFunctions createSafe(long address) {
        return address == 0L ? null : VmaVulkanFunctions.create(address);
    }

    public static VmaVulkanFunctions mallocStack() {
        return VmaVulkanFunctions.mallocStack(MemoryStack.stackGet());
    }

    public static VmaVulkanFunctions callocStack() {
        return VmaVulkanFunctions.callocStack(MemoryStack.stackGet());
    }

    public static VmaVulkanFunctions mallocStack(MemoryStack stack) {
        return VmaVulkanFunctions.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaVulkanFunctions callocStack(MemoryStack stack) {
        return VmaVulkanFunctions.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static long nvkGetPhysicalDeviceProperties(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKGETPHYSICALDEVICEPROPERTIES);
    }

    public static long nvkGetPhysicalDeviceMemoryProperties(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKGETPHYSICALDEVICEMEMORYPROPERTIES);
    }

    public static long nvkAllocateMemory(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKALLOCATEMEMORY);
    }

    public static long nvkFreeMemory(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKFREEMEMORY);
    }

    public static long nvkMapMemory(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKMAPMEMORY);
    }

    public static long nvkUnmapMemory(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKUNMAPMEMORY);
    }

    public static long nvkBindBufferMemory(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKBINDBUFFERMEMORY);
    }

    public static long nvkBindImageMemory(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKBINDIMAGEMEMORY);
    }

    public static long nvkGetBufferMemoryRequirements(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKGETBUFFERMEMORYREQUIREMENTS);
    }

    public static long nvkGetImageMemoryRequirements(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKGETIMAGEMEMORYREQUIREMENTS);
    }

    public static long nvkCreateBuffer(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKCREATEBUFFER);
    }

    public static long nvkDestroyBuffer(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKDESTROYBUFFER);
    }

    public static long nvkCreateImage(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKCREATEIMAGE);
    }

    public static long nvkDestroyImage(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKDESTROYIMAGE);
    }

    public static long nvkGetBufferMemoryRequirements2KHR(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKGETBUFFERMEMORYREQUIREMENTS2KHR);
    }

    public static long nvkGetImageMemoryRequirements2KHR(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKGETIMAGEMEMORYREQUIREMENTS2KHR);
    }

    public static void nvkGetPhysicalDeviceProperties(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKGETPHYSICALDEVICEPROPERTIES, Checks.check(value));
    }

    public static void nvkGetPhysicalDeviceMemoryProperties(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKGETPHYSICALDEVICEMEMORYPROPERTIES, Checks.check(value));
    }

    public static void nvkAllocateMemory(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKALLOCATEMEMORY, Checks.check(value));
    }

    public static void nvkFreeMemory(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKFREEMEMORY, Checks.check(value));
    }

    public static void nvkMapMemory(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKMAPMEMORY, Checks.check(value));
    }

    public static void nvkUnmapMemory(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKUNMAPMEMORY, Checks.check(value));
    }

    public static void nvkBindBufferMemory(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKBINDBUFFERMEMORY, Checks.check(value));
    }

    public static void nvkBindImageMemory(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKBINDIMAGEMEMORY, Checks.check(value));
    }

    public static void nvkGetBufferMemoryRequirements(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKGETBUFFERMEMORYREQUIREMENTS, Checks.check(value));
    }

    public static void nvkGetImageMemoryRequirements(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKGETIMAGEMEMORYREQUIREMENTS, Checks.check(value));
    }

    public static void nvkCreateBuffer(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKCREATEBUFFER, Checks.check(value));
    }

    public static void nvkDestroyBuffer(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKDESTROYBUFFER, Checks.check(value));
    }

    public static void nvkCreateImage(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKCREATEIMAGE, Checks.check(value));
    }

    public static void nvkDestroyImage(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKDESTROYIMAGE, Checks.check(value));
    }

    public static void nvkGetBufferMemoryRequirements2KHR(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKGETBUFFERMEMORYREQUIREMENTS2KHR, Checks.check(value));
    }

    public static void nvkGetImageMemoryRequirements2KHR(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VKGETIMAGEMEMORYREQUIREMENTS2KHR, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VKGETPHYSICALDEVICEPROPERTIES));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VKGETPHYSICALDEVICEMEMORYPROPERTIES));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VKALLOCATEMEMORY));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VKFREEMEMORY));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VKMAPMEMORY));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VKUNMAPMEMORY));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VKBINDBUFFERMEMORY));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VKBINDIMAGEMEMORY));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VKGETBUFFERMEMORYREQUIREMENTS));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VKGETIMAGEMEMORYREQUIREMENTS));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VKCREATEBUFFER));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VKDESTROYBUFFER));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VKCREATEIMAGE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VKDESTROYIMAGE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VKGETBUFFERMEMORYREQUIREMENTS2KHR));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VKGETIMAGEMEMORYREQUIREMENTS2KHR));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VmaVulkanFunctions.validate(array + (long)(i * SIZEOF));
        }
    }

    public void set(VkInstance instance, VkDevice device) {
        VKCapabilitiesInstance ic = instance.getCapabilities();
        VKCapabilitiesDevice dc = device.getCapabilities();
        this.vkGetPhysicalDeviceProperties(ic.vkGetPhysicalDeviceProperties).vkGetPhysicalDeviceMemoryProperties(ic.vkGetPhysicalDeviceMemoryProperties).vkAllocateMemory(dc.vkAllocateMemory).vkFreeMemory(dc.vkFreeMemory).vkMapMemory(dc.vkMapMemory).vkUnmapMemory(dc.vkUnmapMemory).vkBindBufferMemory(dc.vkBindBufferMemory).vkBindImageMemory(dc.vkBindImageMemory).vkGetBufferMemoryRequirements(dc.vkGetBufferMemoryRequirements).vkGetImageMemoryRequirements(dc.vkGetImageMemoryRequirements).vkCreateBuffer(dc.vkCreateBuffer).vkDestroyBuffer(dc.vkDestroyBuffer).vkCreateImage(dc.vkCreateImage).vkDestroyImage(dc.vkDestroyImage).vkGetBufferMemoryRequirements2KHR(dc.vkGetBufferMemoryRequirements2KHR).vkGetImageMemoryRequirements2KHR(dc.vkGetImageMemoryRequirements2KHR);
    }

    static {
        Struct.Layout layout = VmaVulkanFunctions.__struct(VmaVulkanFunctions.__member(POINTER_SIZE), VmaVulkanFunctions.__member(POINTER_SIZE), VmaVulkanFunctions.__member(POINTER_SIZE), VmaVulkanFunctions.__member(POINTER_SIZE), VmaVulkanFunctions.__member(POINTER_SIZE), VmaVulkanFunctions.__member(POINTER_SIZE), VmaVulkanFunctions.__member(POINTER_SIZE), VmaVulkanFunctions.__member(POINTER_SIZE), VmaVulkanFunctions.__member(POINTER_SIZE), VmaVulkanFunctions.__member(POINTER_SIZE), VmaVulkanFunctions.__member(POINTER_SIZE), VmaVulkanFunctions.__member(POINTER_SIZE), VmaVulkanFunctions.__member(POINTER_SIZE), VmaVulkanFunctions.__member(POINTER_SIZE), VmaVulkanFunctions.__member(POINTER_SIZE), VmaVulkanFunctions.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VKGETPHYSICALDEVICEPROPERTIES = layout.offsetof(0);
        VKGETPHYSICALDEVICEMEMORYPROPERTIES = layout.offsetof(1);
        VKALLOCATEMEMORY = layout.offsetof(2);
        VKFREEMEMORY = layout.offsetof(3);
        VKMAPMEMORY = layout.offsetof(4);
        VKUNMAPMEMORY = layout.offsetof(5);
        VKBINDBUFFERMEMORY = layout.offsetof(6);
        VKBINDIMAGEMEMORY = layout.offsetof(7);
        VKGETBUFFERMEMORYREQUIREMENTS = layout.offsetof(8);
        VKGETIMAGEMEMORYREQUIREMENTS = layout.offsetof(9);
        VKCREATEBUFFER = layout.offsetof(10);
        VKDESTROYBUFFER = layout.offsetof(11);
        VKCREATEIMAGE = layout.offsetof(12);
        VKDESTROYIMAGE = layout.offsetof(13);
        VKGETBUFFERMEMORYREQUIREMENTS2KHR = layout.offsetof(14);
        VKGETIMAGEMEMORYREQUIREMENTS2KHR = layout.offsetof(15);
    }
}

