/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaPoolCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MEMORYTYPEINDEX;
    public static final int FLAGS;
    public static final int BLOCKSIZE;
    public static final int MINBLOCKCOUNT;
    public static final int MAXBLOCKCOUNT;
    public static final int FRAMEINUSECOUNT;

    VmaPoolCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VmaPoolCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VmaPoolCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int memoryTypeIndex() {
        return VmaPoolCreateInfo.nmemoryTypeIndex(this.address());
    }

    @NativeType(value="VmaPoolCreateFlags")
    public int flags() {
        return VmaPoolCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long blockSize() {
        return VmaPoolCreateInfo.nblockSize(this.address());
    }

    @NativeType(value="size_t")
    public long minBlockCount() {
        return VmaPoolCreateInfo.nminBlockCount(this.address());
    }

    @NativeType(value="size_t")
    public long maxBlockCount() {
        return VmaPoolCreateInfo.nmaxBlockCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int frameInUseCount() {
        return VmaPoolCreateInfo.nframeInUseCount(this.address());
    }

    public VmaPoolCreateInfo memoryTypeIndex(@NativeType(value="uint32_t") int value) {
        VmaPoolCreateInfo.nmemoryTypeIndex(this.address(), value);
        return this;
    }

    public VmaPoolCreateInfo flags(@NativeType(value="VmaPoolCreateFlags") int value) {
        VmaPoolCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VmaPoolCreateInfo blockSize(@NativeType(value="VkDeviceSize") long value) {
        VmaPoolCreateInfo.nblockSize(this.address(), value);
        return this;
    }

    public VmaPoolCreateInfo minBlockCount(@NativeType(value="size_t") long value) {
        VmaPoolCreateInfo.nminBlockCount(this.address(), value);
        return this;
    }

    public VmaPoolCreateInfo maxBlockCount(@NativeType(value="size_t") long value) {
        VmaPoolCreateInfo.nmaxBlockCount(this.address(), value);
        return this;
    }

    public VmaPoolCreateInfo frameInUseCount(@NativeType(value="uint32_t") int value) {
        VmaPoolCreateInfo.nframeInUseCount(this.address(), value);
        return this;
    }

    public VmaPoolCreateInfo set(int memoryTypeIndex, int flags, long blockSize, long minBlockCount, long maxBlockCount, int frameInUseCount) {
        this.memoryTypeIndex(memoryTypeIndex);
        this.flags(flags);
        this.blockSize(blockSize);
        this.minBlockCount(minBlockCount);
        this.maxBlockCount(maxBlockCount);
        this.frameInUseCount(frameInUseCount);
        return this;
    }

    public VmaPoolCreateInfo set(VmaPoolCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VmaPoolCreateInfo malloc() {
        return VmaPoolCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VmaPoolCreateInfo calloc() {
        return VmaPoolCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VmaPoolCreateInfo create() {
        return new VmaPoolCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VmaPoolCreateInfo create(long address) {
        return new VmaPoolCreateInfo(address, null);
    }

    @Nullable
    public static VmaPoolCreateInfo createSafe(long address) {
        return address == 0L ? null : VmaPoolCreateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VmaPoolCreateInfo.create(VmaPoolCreateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VmaPoolCreateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VmaPoolCreateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VmaPoolCreateInfo.create(address, capacity);
    }

    public static VmaPoolCreateInfo mallocStack() {
        return VmaPoolCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VmaPoolCreateInfo callocStack() {
        return VmaPoolCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VmaPoolCreateInfo mallocStack(MemoryStack stack) {
        return VmaPoolCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaPoolCreateInfo callocStack(MemoryStack stack) {
        return VmaPoolCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VmaPoolCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VmaPoolCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaPoolCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaPoolCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmemoryTypeIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MEMORYTYPEINDEX);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long nblockSize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BLOCKSIZE);
    }

    public static long nminBlockCount(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MINBLOCKCOUNT);
    }

    public static long nmaxBlockCount(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MAXBLOCKCOUNT);
    }

    public static int nframeInUseCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FRAMEINUSECOUNT);
    }

    public static void nmemoryTypeIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MEMORYTYPEINDEX, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nblockSize(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BLOCKSIZE, value);
    }

    public static void nminBlockCount(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)MINBLOCKCOUNT, value);
    }

    public static void nmaxBlockCount(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)MAXBLOCKCOUNT, value);
    }

    public static void nframeInUseCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FRAMEINUSECOUNT, value);
    }

    static {
        Struct.Layout layout = VmaPoolCreateInfo.__struct(VmaPoolCreateInfo.__member(4), VmaPoolCreateInfo.__member(4), VmaPoolCreateInfo.__member(8), VmaPoolCreateInfo.__member(POINTER_SIZE), VmaPoolCreateInfo.__member(POINTER_SIZE), VmaPoolCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MEMORYTYPEINDEX = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
        BLOCKSIZE = layout.offsetof(2);
        MINBLOCKCOUNT = layout.offsetof(3);
        MAXBLOCKCOUNT = layout.offsetof(4);
        FRAMEINUSECOUNT = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VmaPoolCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VmaPoolCreateInfo newInstance(long address) {
            return new VmaPoolCreateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint32_t")
        public int memoryTypeIndex() {
            return VmaPoolCreateInfo.nmemoryTypeIndex(this.address());
        }

        @NativeType(value="VmaPoolCreateFlags")
        public int flags() {
            return VmaPoolCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long blockSize() {
            return VmaPoolCreateInfo.nblockSize(this.address());
        }

        @NativeType(value="size_t")
        public long minBlockCount() {
            return VmaPoolCreateInfo.nminBlockCount(this.address());
        }

        @NativeType(value="size_t")
        public long maxBlockCount() {
            return VmaPoolCreateInfo.nmaxBlockCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int frameInUseCount() {
            return VmaPoolCreateInfo.nframeInUseCount(this.address());
        }

        public Buffer memoryTypeIndex(@NativeType(value="uint32_t") int value) {
            VmaPoolCreateInfo.nmemoryTypeIndex(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VmaPoolCreateFlags") int value) {
            VmaPoolCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer blockSize(@NativeType(value="VkDeviceSize") long value) {
            VmaPoolCreateInfo.nblockSize(this.address(), value);
            return this;
        }

        public Buffer minBlockCount(@NativeType(value="size_t") long value) {
            VmaPoolCreateInfo.nminBlockCount(this.address(), value);
            return this;
        }

        public Buffer maxBlockCount(@NativeType(value="size_t") long value) {
            VmaPoolCreateInfo.nmaxBlockCount(this.address(), value);
            return this;
        }

        public Buffer frameInUseCount(@NativeType(value="uint32_t") int value) {
            VmaPoolCreateInfo.nframeInUseCount(this.address(), value);
            return this;
        }
    }
}

