/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.vma.VmaAllocateDeviceMemoryFunction;
import org.lwjgl.util.vma.VmaAllocateDeviceMemoryFunctionI;
import org.lwjgl.util.vma.VmaFreeDeviceMemoryFunction;
import org.lwjgl.util.vma.VmaFreeDeviceMemoryFunctionI;

public class VmaDeviceMemoryCallbacks
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PFNALLOCATE;
    public static final int PFNFREE;

    VmaDeviceMemoryCallbacks(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VmaDeviceMemoryCallbacks(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VmaDeviceMemoryCallbacks.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @Nullable
    @NativeType(value="PFN_vmaAllocateDeviceMemoryFunction")
    public VmaAllocateDeviceMemoryFunction pfnAllocate() {
        return VmaDeviceMemoryCallbacks.npfnAllocate(this.address());
    }

    @Nullable
    @NativeType(value="PFN_vmaFreeDeviceMemoryFunction")
    public VmaFreeDeviceMemoryFunction pfnFree() {
        return VmaDeviceMemoryCallbacks.npfnFree(this.address());
    }

    public VmaDeviceMemoryCallbacks pfnAllocate(@Nullable @NativeType(value="PFN_vmaAllocateDeviceMemoryFunction") VmaAllocateDeviceMemoryFunctionI value) {
        VmaDeviceMemoryCallbacks.npfnAllocate(this.address(), value);
        return this;
    }

    public VmaDeviceMemoryCallbacks pfnFree(@Nullable @NativeType(value="PFN_vmaFreeDeviceMemoryFunction") VmaFreeDeviceMemoryFunctionI value) {
        VmaDeviceMemoryCallbacks.npfnFree(this.address(), value);
        return this;
    }

    public VmaDeviceMemoryCallbacks set(VmaAllocateDeviceMemoryFunctionI pfnAllocate, VmaFreeDeviceMemoryFunctionI pfnFree) {
        this.pfnAllocate(pfnAllocate);
        this.pfnFree(pfnFree);
        return this;
    }

    public VmaDeviceMemoryCallbacks set(VmaDeviceMemoryCallbacks src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VmaDeviceMemoryCallbacks malloc() {
        return VmaDeviceMemoryCallbacks.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VmaDeviceMemoryCallbacks calloc() {
        return VmaDeviceMemoryCallbacks.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VmaDeviceMemoryCallbacks create() {
        return new VmaDeviceMemoryCallbacks(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VmaDeviceMemoryCallbacks create(long address) {
        return new VmaDeviceMemoryCallbacks(address, null);
    }

    @Nullable
    public static VmaDeviceMemoryCallbacks createSafe(long address) {
        return address == 0L ? null : VmaDeviceMemoryCallbacks.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VmaDeviceMemoryCallbacks.create(VmaDeviceMemoryCallbacks.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VmaDeviceMemoryCallbacks.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VmaDeviceMemoryCallbacks.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VmaDeviceMemoryCallbacks.create(address, capacity);
    }

    public static VmaDeviceMemoryCallbacks mallocStack() {
        return VmaDeviceMemoryCallbacks.mallocStack(MemoryStack.stackGet());
    }

    public static VmaDeviceMemoryCallbacks callocStack() {
        return VmaDeviceMemoryCallbacks.callocStack(MemoryStack.stackGet());
    }

    public static VmaDeviceMemoryCallbacks mallocStack(MemoryStack stack) {
        return VmaDeviceMemoryCallbacks.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaDeviceMemoryCallbacks callocStack(MemoryStack stack) {
        return VmaDeviceMemoryCallbacks.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VmaDeviceMemoryCallbacks.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VmaDeviceMemoryCallbacks.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaDeviceMemoryCallbacks.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaDeviceMemoryCallbacks.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    @Nullable
    public static VmaAllocateDeviceMemoryFunction npfnAllocate(long struct) {
        return VmaAllocateDeviceMemoryFunction.createSafe(MemoryUtil.memGetAddress(struct + (long)PFNALLOCATE));
    }

    @Nullable
    public static VmaFreeDeviceMemoryFunction npfnFree(long struct) {
        return VmaFreeDeviceMemoryFunction.createSafe(MemoryUtil.memGetAddress(struct + (long)PFNFREE));
    }

    public static void npfnAllocate(long struct, @Nullable VmaAllocateDeviceMemoryFunctionI value) {
        MemoryUtil.memPutAddress(struct + (long)PFNALLOCATE, MemoryUtil.memAddressSafe(value));
    }

    public static void npfnFree(long struct, @Nullable VmaFreeDeviceMemoryFunctionI value) {
        MemoryUtil.memPutAddress(struct + (long)PFNFREE, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = VmaDeviceMemoryCallbacks.__struct(VmaDeviceMemoryCallbacks.__member(POINTER_SIZE), VmaDeviceMemoryCallbacks.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PFNALLOCATE = layout.offsetof(0);
        PFNFREE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VmaDeviceMemoryCallbacks, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VmaDeviceMemoryCallbacks newInstance(long address) {
            return new VmaDeviceMemoryCallbacks(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @Nullable
        @NativeType(value="PFN_vmaAllocateDeviceMemoryFunction")
        public VmaAllocateDeviceMemoryFunction pfnAllocate() {
            return VmaDeviceMemoryCallbacks.npfnAllocate(this.address());
        }

        @Nullable
        @NativeType(value="PFN_vmaFreeDeviceMemoryFunction")
        public VmaFreeDeviceMemoryFunction pfnFree() {
            return VmaDeviceMemoryCallbacks.npfnFree(this.address());
        }

        public Buffer pfnAllocate(@Nullable @NativeType(value="PFN_vmaAllocateDeviceMemoryFunction") VmaAllocateDeviceMemoryFunctionI value) {
            VmaDeviceMemoryCallbacks.npfnAllocate(this.address(), value);
            return this;
        }

        public Buffer pfnFree(@Nullable @NativeType(value="PFN_vmaFreeDeviceMemoryFunction") VmaFreeDeviceMemoryFunctionI value) {
            VmaDeviceMemoryCallbacks.npfnFree(this.address(), value);
            return this;
        }
    }
}

