/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaDefragmentationInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAXBYTESTOMOVE;
    public static final int MAXALLOCATIONSTOMOVE;

    VmaDefragmentationInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VmaDefragmentationInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VmaDefragmentationInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long maxBytesToMove() {
        return VmaDefragmentationInfo.nmaxBytesToMove(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxAllocationsToMove() {
        return VmaDefragmentationInfo.nmaxAllocationsToMove(this.address());
    }

    public VmaDefragmentationInfo maxBytesToMove(@NativeType(value="VkDeviceSize") long value) {
        VmaDefragmentationInfo.nmaxBytesToMove(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo maxAllocationsToMove(@NativeType(value="uint32_t") int value) {
        VmaDefragmentationInfo.nmaxAllocationsToMove(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo set(long maxBytesToMove, int maxAllocationsToMove) {
        this.maxBytesToMove(maxBytesToMove);
        this.maxAllocationsToMove(maxAllocationsToMove);
        return this;
    }

    public VmaDefragmentationInfo set(VmaDefragmentationInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VmaDefragmentationInfo malloc() {
        return VmaDefragmentationInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VmaDefragmentationInfo calloc() {
        return VmaDefragmentationInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VmaDefragmentationInfo create() {
        return new VmaDefragmentationInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VmaDefragmentationInfo create(long address) {
        return new VmaDefragmentationInfo(address, null);
    }

    @Nullable
    public static VmaDefragmentationInfo createSafe(long address) {
        return address == 0L ? null : VmaDefragmentationInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VmaDefragmentationInfo.create(VmaDefragmentationInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VmaDefragmentationInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VmaDefragmentationInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VmaDefragmentationInfo.create(address, capacity);
    }

    public static VmaDefragmentationInfo mallocStack() {
        return VmaDefragmentationInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VmaDefragmentationInfo callocStack() {
        return VmaDefragmentationInfo.callocStack(MemoryStack.stackGet());
    }

    public static VmaDefragmentationInfo mallocStack(MemoryStack stack) {
        return VmaDefragmentationInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaDefragmentationInfo callocStack(MemoryStack stack) {
        return VmaDefragmentationInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VmaDefragmentationInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VmaDefragmentationInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaDefragmentationInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaDefragmentationInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nmaxBytesToMove(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MAXBYTESTOMOVE);
    }

    public static int nmaxAllocationsToMove(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXALLOCATIONSTOMOVE);
    }

    public static void nmaxBytesToMove(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MAXBYTESTOMOVE, value);
    }

    public static void nmaxAllocationsToMove(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAXALLOCATIONSTOMOVE, value);
    }

    static {
        Struct.Layout layout = VmaDefragmentationInfo.__struct(VmaDefragmentationInfo.__member(8), VmaDefragmentationInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAXBYTESTOMOVE = layout.offsetof(0);
        MAXALLOCATIONSTOMOVE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VmaDefragmentationInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VmaDefragmentationInfo newInstance(long address) {
            return new VmaDefragmentationInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkDeviceSize")
        public long maxBytesToMove() {
            return VmaDefragmentationInfo.nmaxBytesToMove(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxAllocationsToMove() {
            return VmaDefragmentationInfo.nmaxAllocationsToMove(this.address());
        }

        public Buffer maxBytesToMove(@NativeType(value="VkDeviceSize") long value) {
            VmaDefragmentationInfo.nmaxBytesToMove(this.address(), value);
            return this;
        }

        public Buffer maxAllocationsToMove(@NativeType(value="uint32_t") int value) {
            VmaDefragmentationInfo.nmaxAllocationsToMove(this.address(), value);
            return this;
        }
    }
}

