/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.util.vma.VmaDeviceMemoryCallbacks;
import org.lwjgl.util.vma.VmaVulkanFunctions;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class VmaAllocatorCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int PHYSICALDEVICE;
    public static final int DEVICE;
    public static final int PREFERREDLARGEHEAPBLOCKSIZE;
    public static final int PALLOCATIONCALLBACKS;
    public static final int PDEVICEMEMORYCALLBACKS;
    public static final int FRAMEINUSECOUNT;
    public static final int PHEAPSIZELIMIT;
    public static final int PVULKANFUNCTIONS;

    VmaAllocatorCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VmaAllocatorCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VmaAllocatorCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VmaAllocatorCreateFlags")
    public int flags() {
        return VmaAllocatorCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkPhysicalDevice")
    public long physicalDevice() {
        return VmaAllocatorCreateInfo.nphysicalDevice(this.address());
    }

    @NativeType(value="VkDevice")
    public long device() {
        return VmaAllocatorCreateInfo.ndevice(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long preferredLargeHeapBlockSize() {
        return VmaAllocatorCreateInfo.npreferredLargeHeapBlockSize(this.address());
    }

    @Nullable
    @NativeType(value="VkAllocationCallbacks const *")
    public VkAllocationCallbacks pAllocationCallbacks() {
        return VmaAllocatorCreateInfo.npAllocationCallbacks(this.address());
    }

    @Nullable
    @NativeType(value="VmaDeviceMemoryCallbacks const *")
    public VmaDeviceMemoryCallbacks pDeviceMemoryCallbacks() {
        return VmaAllocatorCreateInfo.npDeviceMemoryCallbacks(this.address());
    }

    @NativeType(value="uint32_t")
    public int frameInUseCount() {
        return VmaAllocatorCreateInfo.nframeInUseCount(this.address());
    }

    @Nullable
    @NativeType(value="VkDeviceSize const *")
    public LongBuffer pHeapSizeLimit(int capacity) {
        return VmaAllocatorCreateInfo.npHeapSizeLimit(this.address(), capacity);
    }

    @NativeType(value="VmaVulkanFunctions const *")
    public VmaVulkanFunctions pVulkanFunctions() {
        return VmaAllocatorCreateInfo.npVulkanFunctions(this.address());
    }

    public VmaAllocatorCreateInfo flags(@NativeType(value="VmaAllocatorCreateFlags") int value) {
        VmaAllocatorCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo physicalDevice(VkPhysicalDevice value) {
        VmaAllocatorCreateInfo.nphysicalDevice(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo device(VkDevice value) {
        VmaAllocatorCreateInfo.ndevice(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo preferredLargeHeapBlockSize(@NativeType(value="VkDeviceSize") long value) {
        VmaAllocatorCreateInfo.npreferredLargeHeapBlockSize(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo pAllocationCallbacks(@Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks value) {
        VmaAllocatorCreateInfo.npAllocationCallbacks(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo pDeviceMemoryCallbacks(@Nullable @NativeType(value="VmaDeviceMemoryCallbacks const *") VmaDeviceMemoryCallbacks value) {
        VmaAllocatorCreateInfo.npDeviceMemoryCallbacks(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo frameInUseCount(@NativeType(value="uint32_t") int value) {
        VmaAllocatorCreateInfo.nframeInUseCount(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo pHeapSizeLimit(@Nullable @NativeType(value="VkDeviceSize const *") LongBuffer value) {
        VmaAllocatorCreateInfo.npHeapSizeLimit(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo pVulkanFunctions(@NativeType(value="VmaVulkanFunctions const *") VmaVulkanFunctions value) {
        VmaAllocatorCreateInfo.npVulkanFunctions(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo set(int flags, VkPhysicalDevice physicalDevice, VkDevice device, long preferredLargeHeapBlockSize, @Nullable VkAllocationCallbacks pAllocationCallbacks, @Nullable VmaDeviceMemoryCallbacks pDeviceMemoryCallbacks, int frameInUseCount, @Nullable LongBuffer pHeapSizeLimit, VmaVulkanFunctions pVulkanFunctions) {
        this.flags(flags);
        this.physicalDevice(physicalDevice);
        this.device(device);
        this.preferredLargeHeapBlockSize(preferredLargeHeapBlockSize);
        this.pAllocationCallbacks(pAllocationCallbacks);
        this.pDeviceMemoryCallbacks(pDeviceMemoryCallbacks);
        this.frameInUseCount(frameInUseCount);
        this.pHeapSizeLimit(pHeapSizeLimit);
        this.pVulkanFunctions(pVulkanFunctions);
        return this;
    }

    public VmaAllocatorCreateInfo set(VmaAllocatorCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VmaAllocatorCreateInfo malloc() {
        return VmaAllocatorCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VmaAllocatorCreateInfo calloc() {
        return VmaAllocatorCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VmaAllocatorCreateInfo create() {
        return new VmaAllocatorCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VmaAllocatorCreateInfo create(long address) {
        return new VmaAllocatorCreateInfo(address, null);
    }

    @Nullable
    public static VmaAllocatorCreateInfo createSafe(long address) {
        return address == 0L ? null : VmaAllocatorCreateInfo.create(address);
    }

    public static VmaAllocatorCreateInfo mallocStack() {
        return VmaAllocatorCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VmaAllocatorCreateInfo callocStack() {
        return VmaAllocatorCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VmaAllocatorCreateInfo mallocStack(MemoryStack stack) {
        return VmaAllocatorCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaAllocatorCreateInfo callocStack(MemoryStack stack) {
        return VmaAllocatorCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long nphysicalDevice(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PHYSICALDEVICE);
    }

    public static long ndevice(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DEVICE);
    }

    public static long npreferredLargeHeapBlockSize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)PREFERREDLARGEHEAPBLOCKSIZE);
    }

    @Nullable
    public static VkAllocationCallbacks npAllocationCallbacks(long struct) {
        return VkAllocationCallbacks.createSafe(MemoryUtil.memGetAddress(struct + (long)PALLOCATIONCALLBACKS));
    }

    @Nullable
    public static VmaDeviceMemoryCallbacks npDeviceMemoryCallbacks(long struct) {
        return VmaDeviceMemoryCallbacks.createSafe(MemoryUtil.memGetAddress(struct + (long)PDEVICEMEMORYCALLBACKS));
    }

    public static int nframeInUseCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FRAMEINUSECOUNT);
    }

    @Nullable
    public static LongBuffer npHeapSizeLimit(long struct, int capacity) {
        return MemoryUtil.memLongBufferSafe(MemoryUtil.memGetAddress(struct + (long)PHEAPSIZELIMIT), capacity);
    }

    public static VmaVulkanFunctions npVulkanFunctions(long struct) {
        return VmaVulkanFunctions.create(MemoryUtil.memGetAddress(struct + (long)PVULKANFUNCTIONS));
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nphysicalDevice(long struct, VkPhysicalDevice value) {
        MemoryUtil.memPutAddress(struct + (long)PHYSICALDEVICE, value.address());
    }

    public static void ndevice(long struct, VkDevice value) {
        MemoryUtil.memPutAddress(struct + (long)DEVICE, value.address());
    }

    public static void npreferredLargeHeapBlockSize(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)PREFERREDLARGEHEAPBLOCKSIZE, value);
    }

    public static void npAllocationCallbacks(long struct, @Nullable VkAllocationCallbacks value) {
        MemoryUtil.memPutAddress(struct + (long)PALLOCATIONCALLBACKS, MemoryUtil.memAddressSafe(value));
    }

    public static void npDeviceMemoryCallbacks(long struct, @Nullable VmaDeviceMemoryCallbacks value) {
        MemoryUtil.memPutAddress(struct + (long)PDEVICEMEMORYCALLBACKS, MemoryUtil.memAddressSafe(value));
    }

    public static void nframeInUseCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FRAMEINUSECOUNT, value);
    }

    public static void npHeapSizeLimit(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PHEAPSIZELIMIT, MemoryUtil.memAddressSafe(value));
    }

    public static void npVulkanFunctions(long struct, VmaVulkanFunctions value) {
        MemoryUtil.memPutAddress(struct + (long)PVULKANFUNCTIONS, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PHYSICALDEVICE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DEVICE));
        long pAllocationCallbacks = MemoryUtil.memGetAddress(struct + (long)PALLOCATIONCALLBACKS);
        if (pAllocationCallbacks != 0L) {
            VkAllocationCallbacks.validate(pAllocationCallbacks);
        }
        long pVulkanFunctions = MemoryUtil.memGetAddress(struct + (long)PVULKANFUNCTIONS);
        Checks.check(pVulkanFunctions);
        VmaVulkanFunctions.validate(pVulkanFunctions);
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VmaAllocatorCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VmaAllocatorCreateInfo.__struct(VmaAllocatorCreateInfo.__member(4), VmaAllocatorCreateInfo.__member(POINTER_SIZE), VmaAllocatorCreateInfo.__member(POINTER_SIZE), VmaAllocatorCreateInfo.__member(8), VmaAllocatorCreateInfo.__member(POINTER_SIZE), VmaAllocatorCreateInfo.__member(POINTER_SIZE), VmaAllocatorCreateInfo.__member(4), VmaAllocatorCreateInfo.__member(POINTER_SIZE), VmaAllocatorCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        PHYSICALDEVICE = layout.offsetof(1);
        DEVICE = layout.offsetof(2);
        PREFERREDLARGEHEAPBLOCKSIZE = layout.offsetof(3);
        PALLOCATIONCALLBACKS = layout.offsetof(4);
        PDEVICEMEMORYCALLBACKS = layout.offsetof(5);
        FRAMEINUSECOUNT = layout.offsetof(6);
        PHEAPSIZELIMIT = layout.offsetof(7);
        PVULKANFUNCTIONS = layout.offsetof(8);
    }
}

