/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tinyfd;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;

public class TinyFileDialogs {
    public static final String tinyfd_version;
    public static final String tinyfd_needs;
    public static final IntBuffer tinyfd_verbose;
    public static final IntBuffer tinyfd_silent;
    public static final IntBuffer tinyfd_forceConsole;

    protected TinyFileDialogs() {
        throw new UnsupportedOperationException();
    }

    private static native long ntinyfd_version();

    @NativeType(value="char *")
    private static String tinyfd_version() {
        long __result = TinyFileDialogs.ntinyfd_version();
        return MemoryUtil.memASCII(__result);
    }

    private static native long ntinyfd_needs();

    @NativeType(value="char *")
    private static String tinyfd_needs() {
        long __result = TinyFileDialogs.ntinyfd_needs();
        return MemoryUtil.memASCII(__result);
    }

    private static native long ntinyfd_verbose();

    @NativeType(value="int *")
    private static IntBuffer tinyfd_verbose() {
        long __result = TinyFileDialogs.ntinyfd_verbose();
        return MemoryUtil.memIntBuffer(__result, 1);
    }

    private static native long ntinyfd_silent();

    @NativeType(value="int *")
    private static IntBuffer tinyfd_silent() {
        long __result = TinyFileDialogs.ntinyfd_silent();
        return MemoryUtil.memIntBuffer(__result, 1);
    }

    private static native long ntinyfd_winUtf8();

    @NativeType(value="int *")
    private static IntBuffer tinyfd_winUtf8() {
        long __result = TinyFileDialogs.ntinyfd_winUtf8();
        return MemoryUtil.memIntBuffer(__result, 1);
    }

    private static native long ntinyfd_forceConsole();

    @NativeType(value="int *")
    private static IntBuffer tinyfd_forceConsole() {
        long __result = TinyFileDialogs.ntinyfd_forceConsole();
        return MemoryUtil.memIntBuffer(__result, 1);
    }

    public static native long ntinyfd_response();

    @NativeType(value="char *")
    public static String tinyfd_response() {
        long __result = TinyFileDialogs.ntinyfd_response();
        return MemoryUtil.memUTF8(__result);
    }

    public static native void tinyfd_beep();

    public static native int ntinyfd_notifyPopup(long var0, long var2, long var4);

    public static int tinyfd_notifyPopup(@Nullable @NativeType(value="char const *") ByteBuffer aTitle, @Nullable @NativeType(value="char const *") ByteBuffer aMessage, @NativeType(value="char const *") ByteBuffer aIconType) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(aTitle);
            Checks.checkNT1Safe(aMessage);
            Checks.checkNT1(aIconType);
        }
        return TinyFileDialogs.ntinyfd_notifyPopup(MemoryUtil.memAddressSafe(aTitle), MemoryUtil.memAddressSafe(aMessage), MemoryUtil.memAddress(aIconType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int tinyfd_notifyPopup(@Nullable @NativeType(value="char const *") CharSequence aTitle, @Nullable @NativeType(value="char const *") CharSequence aMessage, @NativeType(value="char const *") CharSequence aIconType) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer aTitleEncoded = stack.UTF8Safe(aTitle);
            ByteBuffer aMessageEncoded = stack.UTF8Safe(aMessage);
            ByteBuffer aIconTypeEncoded = stack.ASCII(aIconType);
            int n = TinyFileDialogs.ntinyfd_notifyPopup(MemoryUtil.memAddressSafe(aTitleEncoded), MemoryUtil.memAddressSafe(aMessageEncoded), MemoryUtil.memAddress(aIconTypeEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int ntinyfd_messageBox(long var0, long var2, long var4, long var6, int var8);

    @NativeType(value="int")
    public static boolean tinyfd_messageBox(@Nullable @NativeType(value="char const *") ByteBuffer aTitle, @Nullable @NativeType(value="char const *") ByteBuffer aMessage, @NativeType(value="char const *") ByteBuffer aDialogType, @NativeType(value="char const *") ByteBuffer aIconType, @NativeType(value="int") boolean aDefaultButton) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(aTitle);
            Checks.checkNT1Safe(aMessage);
            Checks.checkNT1(aDialogType);
            Checks.checkNT1(aIconType);
        }
        return TinyFileDialogs.ntinyfd_messageBox(MemoryUtil.memAddressSafe(aTitle), MemoryUtil.memAddressSafe(aMessage), MemoryUtil.memAddress(aDialogType), MemoryUtil.memAddress(aIconType), aDefaultButton ? 1 : 0) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="int")
    public static boolean tinyfd_messageBox(@Nullable @NativeType(value="char const *") CharSequence aTitle, @Nullable @NativeType(value="char const *") CharSequence aMessage, @NativeType(value="char const *") CharSequence aDialogType, @NativeType(value="char const *") CharSequence aIconType, @NativeType(value="int") boolean aDefaultButton) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer aTitleEncoded = stack.UTF8Safe(aTitle);
            ByteBuffer aMessageEncoded = stack.UTF8Safe(aMessage);
            ByteBuffer aDialogTypeEncoded = stack.ASCII(aDialogType);
            ByteBuffer aIconTypeEncoded = stack.ASCII(aIconType);
            boolean bl = TinyFileDialogs.ntinyfd_messageBox(MemoryUtil.memAddressSafe(aTitleEncoded), MemoryUtil.memAddressSafe(aMessageEncoded), MemoryUtil.memAddress(aDialogTypeEncoded), MemoryUtil.memAddress(aIconTypeEncoded), aDefaultButton ? 1 : 0) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long ntinyfd_inputBox(long var0, long var2, long var4);

    @Nullable
    @NativeType(value="char const *")
    public static String tinyfd_inputBox(@Nullable @NativeType(value="char const *") ByteBuffer aTitle, @Nullable @NativeType(value="char const *") ByteBuffer aMessage, @Nullable @NativeType(value="char const *") ByteBuffer aDefaultInput) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(aTitle);
            Checks.checkNT1Safe(aMessage);
            Checks.checkNT1Safe(aDefaultInput);
        }
        long __result = TinyFileDialogs.ntinyfd_inputBox(MemoryUtil.memAddressSafe(aTitle), MemoryUtil.memAddressSafe(aMessage), MemoryUtil.memAddressSafe(aDefaultInput));
        return MemoryUtil.memUTF8Safe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String tinyfd_inputBox(@Nullable @NativeType(value="char const *") CharSequence aTitle, @Nullable @NativeType(value="char const *") CharSequence aMessage, @Nullable @NativeType(value="char const *") CharSequence aDefaultInput) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer aTitleEncoded = stack.UTF8Safe(aTitle);
            ByteBuffer aMessageEncoded = stack.UTF8Safe(aMessage);
            ByteBuffer aDefaultInputEncoded = stack.UTF8Safe(aDefaultInput);
            long __result = TinyFileDialogs.ntinyfd_inputBox(MemoryUtil.memAddressSafe(aTitleEncoded), MemoryUtil.memAddressSafe(aMessageEncoded), MemoryUtil.memAddressSafe(aDefaultInputEncoded));
            String string = MemoryUtil.memUTF8Safe(__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long ntinyfd_saveFileDialog(long var0, long var2, int var4, long var5, long var7);

    @Nullable
    @NativeType(value="char const *")
    public static String tinyfd_saveFileDialog(@Nullable @NativeType(value="char const *") ByteBuffer aTitle, @Nullable @NativeType(value="char const *") ByteBuffer aDefaultPathAndFile, @Nullable @NativeType(value="char const * const *") PointerBuffer aFilterPatterns, @Nullable @NativeType(value="char const *") ByteBuffer aSingleFilterDescription) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(aTitle);
            Checks.checkNT1Safe(aDefaultPathAndFile);
            Checks.checkNT1Safe(aSingleFilterDescription);
        }
        long __result = TinyFileDialogs.ntinyfd_saveFileDialog(MemoryUtil.memAddressSafe(aTitle), MemoryUtil.memAddressSafe(aDefaultPathAndFile), Checks.remainingSafe(aFilterPatterns), MemoryUtil.memAddressSafe(aFilterPatterns), MemoryUtil.memAddressSafe(aSingleFilterDescription));
        return MemoryUtil.memUTF8Safe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String tinyfd_saveFileDialog(@Nullable @NativeType(value="char const *") CharSequence aTitle, @Nullable @NativeType(value="char const *") CharSequence aDefaultPathAndFile, @Nullable @NativeType(value="char const * const *") PointerBuffer aFilterPatterns, @Nullable @NativeType(value="char const *") CharSequence aSingleFilterDescription) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer aTitleEncoded = stack.UTF8Safe(aTitle);
            ByteBuffer aDefaultPathAndFileEncoded = stack.UTF8Safe(aDefaultPathAndFile);
            ByteBuffer aSingleFilterDescriptionEncoded = stack.UTF8Safe(aSingleFilterDescription);
            long __result = TinyFileDialogs.ntinyfd_saveFileDialog(MemoryUtil.memAddressSafe(aTitleEncoded), MemoryUtil.memAddressSafe(aDefaultPathAndFileEncoded), Checks.remainingSafe(aFilterPatterns), MemoryUtil.memAddressSafe(aFilterPatterns), MemoryUtil.memAddressSafe(aSingleFilterDescriptionEncoded));
            String string = MemoryUtil.memUTF8Safe(__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long ntinyfd_openFileDialog(long var0, long var2, int var4, long var5, long var7, int var9);

    @Nullable
    @NativeType(value="char const *")
    public static String tinyfd_openFileDialog(@Nullable @NativeType(value="char const *") ByteBuffer aTitle, @Nullable @NativeType(value="char const *") ByteBuffer aDefaultPathAndFile, @Nullable @NativeType(value="char const * const *") PointerBuffer aFilterPatterns, @Nullable @NativeType(value="char const *") ByteBuffer aSingleFilterDescription, @NativeType(value="int") boolean aAllowMultipleSelects) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(aTitle);
            Checks.checkNT1Safe(aDefaultPathAndFile);
            Checks.checkNT1Safe(aSingleFilterDescription);
        }
        long __result = TinyFileDialogs.ntinyfd_openFileDialog(MemoryUtil.memAddressSafe(aTitle), MemoryUtil.memAddressSafe(aDefaultPathAndFile), Checks.remainingSafe(aFilterPatterns), MemoryUtil.memAddressSafe(aFilterPatterns), MemoryUtil.memAddressSafe(aSingleFilterDescription), aAllowMultipleSelects ? 1 : 0);
        return MemoryUtil.memUTF8Safe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String tinyfd_openFileDialog(@Nullable @NativeType(value="char const *") CharSequence aTitle, @Nullable @NativeType(value="char const *") CharSequence aDefaultPathAndFile, @Nullable @NativeType(value="char const * const *") PointerBuffer aFilterPatterns, @Nullable @NativeType(value="char const *") CharSequence aSingleFilterDescription, @NativeType(value="int") boolean aAllowMultipleSelects) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer aTitleEncoded = stack.UTF8Safe(aTitle);
            ByteBuffer aDefaultPathAndFileEncoded = stack.UTF8Safe(aDefaultPathAndFile);
            ByteBuffer aSingleFilterDescriptionEncoded = stack.UTF8Safe(aSingleFilterDescription);
            long __result = TinyFileDialogs.ntinyfd_openFileDialog(MemoryUtil.memAddressSafe(aTitleEncoded), MemoryUtil.memAddressSafe(aDefaultPathAndFileEncoded), Checks.remainingSafe(aFilterPatterns), MemoryUtil.memAddressSafe(aFilterPatterns), MemoryUtil.memAddressSafe(aSingleFilterDescriptionEncoded), aAllowMultipleSelects ? 1 : 0);
            String string = MemoryUtil.memUTF8Safe(__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long ntinyfd_selectFolderDialog(long var0, long var2);

    @Nullable
    @NativeType(value="char const *")
    public static String tinyfd_selectFolderDialog(@Nullable @NativeType(value="char const *") ByteBuffer aTitle, @NativeType(value="char const *") ByteBuffer aDefaultPath) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(aTitle);
            Checks.checkNT1(aDefaultPath);
        }
        long __result = TinyFileDialogs.ntinyfd_selectFolderDialog(MemoryUtil.memAddressSafe(aTitle), MemoryUtil.memAddress(aDefaultPath));
        return MemoryUtil.memUTF8Safe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String tinyfd_selectFolderDialog(@Nullable @NativeType(value="char const *") CharSequence aTitle, @NativeType(value="char const *") CharSequence aDefaultPath) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer aTitleEncoded = stack.UTF8Safe(aTitle);
            ByteBuffer aDefaultPathEncoded = stack.UTF8(aDefaultPath);
            long __result = TinyFileDialogs.ntinyfd_selectFolderDialog(MemoryUtil.memAddressSafe(aTitleEncoded), MemoryUtil.memAddress(aDefaultPathEncoded));
            String string = MemoryUtil.memUTF8Safe(__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long ntinyfd_colorChooser(long var0, long var2, long var4, long var6);

    @Nullable
    @NativeType(value="char const *")
    public static String tinyfd_colorChooser(@Nullable @NativeType(value="char const *") ByteBuffer aTitle, @Nullable @NativeType(value="char const *") ByteBuffer aDefaultHexRGB, @Nullable @NativeType(value="unsigned char *") ByteBuffer aDefaultRGB, @NativeType(value="unsigned char *") ByteBuffer aoResultRGB) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(aTitle);
            Checks.checkNT1Safe(aDefaultHexRGB);
            Checks.checkSafe((Buffer)aDefaultRGB, 3);
            Checks.check((Buffer)aoResultRGB, 3);
        }
        long __result = TinyFileDialogs.ntinyfd_colorChooser(MemoryUtil.memAddressSafe(aTitle), MemoryUtil.memAddressSafe(aDefaultHexRGB), MemoryUtil.memAddressSafe(aDefaultRGB), MemoryUtil.memAddress(aoResultRGB));
        return MemoryUtil.memUTF8Safe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String tinyfd_colorChooser(@Nullable @NativeType(value="char const *") CharSequence aTitle, @Nullable @NativeType(value="char const *") CharSequence aDefaultHexRGB, @Nullable @NativeType(value="unsigned char *") ByteBuffer aDefaultRGB, @NativeType(value="unsigned char *") ByteBuffer aoResultRGB) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)aDefaultRGB, 3);
            Checks.check((Buffer)aoResultRGB, 3);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer aTitleEncoded = stack.UTF8Safe(aTitle);
            ByteBuffer aDefaultHexRGBEncoded = stack.ASCIISafe(aDefaultHexRGB);
            long __result = TinyFileDialogs.ntinyfd_colorChooser(MemoryUtil.memAddressSafe(aTitleEncoded), MemoryUtil.memAddressSafe(aDefaultHexRGBEncoded), MemoryUtil.memAddressSafe(aDefaultRGB), MemoryUtil.memAddress(aoResultRGB));
            String string = MemoryUtil.memUTF8Safe(__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    static {
        Library.loadSystem(System::load, System::loadLibrary, TinyFileDialogs.class, Platform.mapLibraryNameBundled("lwjgl_tinyfd"));
        TinyFileDialogs.tinyfd_winUtf8().put(0, 1);
        tinyfd_version = TinyFileDialogs.tinyfd_version();
        tinyfd_needs = TinyFileDialogs.tinyfd_needs();
        tinyfd_verbose = TinyFileDialogs.tinyfd_verbose();
        tinyfd_silent = TinyFileDialogs.tinyfd_silent();
        tinyfd_forceConsole = TinyFileDialogs.tinyfd_forceConsole();
    }
}

