/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tinyexr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;
import org.lwjgl.util.tinyexr.DeepImage;
import org.lwjgl.util.tinyexr.EXRHeader;
import org.lwjgl.util.tinyexr.EXRImage;
import org.lwjgl.util.tinyexr.EXRVersion;

public class TinyEXR {
    public static final int TINYEXR_SUCCESS = 0;
    public static final int TINYEXR_ERROR_INVALID_MAGIC_NUMBER = -1;
    public static final int TINYEXR_ERROR_INVALID_EXR_VERSION = -2;
    public static final int TINYEXR_ERROR_INVALID_ARGUMENT = -3;
    public static final int TINYEXR_ERROR_INVALID_DATA = -4;
    public static final int TINYEXR_ERROR_INVALID_FILE = -5;
    public static final int TINYEXR_ERROR_INVALID_PARAMETER = -5;
    public static final int TINYEXR_ERROR_CANT_OPEN_FILE = -6;
    public static final int TINYEXR_ERROR_UNSUPPORTED_FORMAT = -7;
    public static final int TINYEXR_ERROR_INVALID_HEADER = -8;
    public static final int TINYEXR_ERROR_UNSUPPORTED_FEATURE = -9;
    public static final int TINYEXR_PIXELTYPE_UINT = 0;
    public static final int TINYEXR_PIXELTYPE_HALF = 1;
    public static final int TINYEXR_PIXELTYPE_FLOAT = 2;
    public static final int TINYEXR_MAX_HEADER_ATTRIBUTES = 1024;
    public static final int TINYEXR_MAX_CUSTOM_ATTRIBUTES = 128;
    public static final int TINYEXR_COMPRESSIONTYPE_NONE = 0;
    public static final int TINYEXR_COMPRESSIONTYPE_RLE = 1;
    public static final int TINYEXR_COMPRESSIONTYPE_ZIPS = 2;
    public static final int TINYEXR_COMPRESSIONTYPE_ZIP = 3;
    public static final int TINYEXR_COMPRESSIONTYPE_PIZ = 4;
    public static final int TINYEXR_COMPRESSIONTYPE_ZFP = 128;
    public static final int TINYEXR_ZFP_COMPRESSIONTYPE_RATE = 0;
    public static final int TINYEXR_ZFP_COMPRESSIONTYPE_PRECISION = 1;
    public static final int TINYEXR_ZFP_COMPRESSIONTYPE_ACCURACY = 2;
    public static final int TINYEXR_TILE_ONE_LEVEL = 0;
    public static final int TINYEXR_TILE_MIPMAP_LEVELS = 1;
    public static final int TINYEXR_TILE_RIPMAP_LEVELS = 2;
    public static final int TINYEXR_TILE_ROUND_DOWN = 0;
    public static final int TINYEXR_TILE_ROUND_UP = 1;

    protected TinyEXR() {
        throw new UnsupportedOperationException();
    }

    public static native void nInitEXRHeader(long var0);

    public static void InitEXRHeader(@NativeType(value="EXRHeader *") EXRHeader exr_header) {
        TinyEXR.nInitEXRHeader(exr_header.address());
    }

    public static native void nInitEXRImage(long var0);

    public static void InitEXRImage(@NativeType(value="EXRImage *") EXRImage exr_image) {
        TinyEXR.nInitEXRImage(exr_image.address());
    }

    public static native int nFreeEXRHeader(long var0);

    public static int FreeEXRHeader(@NativeType(value="EXRHeader *") EXRHeader exr_header) {
        return TinyEXR.nFreeEXRHeader(exr_header.address());
    }

    public static native int nFreeEXRImage(long var0);

    public static int FreeEXRImage(@NativeType(value="EXRImage *") EXRImage exr_image) {
        if (Checks.CHECKS) {
            EXRImage.validate(exr_image.address());
        }
        return TinyEXR.nFreeEXRImage(exr_image.address());
    }

    public static native void nFreeEXRErrorMessage(long var0);

    public static void FreeEXRErrorMessage(@NativeType(value="char const *") ByteBuffer msg) {
        TinyEXR.nFreeEXRErrorMessage(MemoryUtil.memAddress(msg));
    }

    public static native int nParseEXRVersionFromFile(long var0, long var2);

    public static int ParseEXRVersionFromFile(@NativeType(value="EXRVersion *") EXRVersion version, @NativeType(value="char const *") ByteBuffer filename) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
        }
        return TinyEXR.nParseEXRVersionFromFile(version.address(), MemoryUtil.memAddress(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ParseEXRVersionFromFile(@NativeType(value="EXRVersion *") EXRVersion version, @NativeType(value="char const *") CharSequence filename) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            int n = TinyEXR.nParseEXRVersionFromFile(version.address(), MemoryUtil.memAddress(filenameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nParseEXRVersionFromMemory(long var0, long var2, long var4);

    public static int ParseEXRVersionFromMemory(@NativeType(value="EXRVersion *") EXRVersion version, @NativeType(value="unsigned char const *") ByteBuffer memory) {
        return TinyEXR.nParseEXRVersionFromMemory(version.address(), MemoryUtil.memAddress(memory), memory.remaining());
    }

    public static native int nParseEXRHeaderFromFile(long var0, long var2, long var4, long var6);

    public static int ParseEXRHeaderFromFile(@NativeType(value="EXRHeader *") EXRHeader header, @NativeType(value="EXRVersion const *") EXRVersion version, @NativeType(value="char const *") ByteBuffer filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.check(err, 1);
        }
        return TinyEXR.nParseEXRHeaderFromFile(header.address(), version.address(), MemoryUtil.memAddress(filename), MemoryUtil.memAddress(err));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ParseEXRHeaderFromFile(@NativeType(value="EXRHeader *") EXRHeader header, @NativeType(value="EXRVersion const *") EXRVersion version, @NativeType(value="char const *") CharSequence filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check(err, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            int n = TinyEXR.nParseEXRHeaderFromFile(header.address(), version.address(), MemoryUtil.memAddress(filenameEncoded), MemoryUtil.memAddress(err));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nParseEXRHeaderFromMemory(long var0, long var2, long var4, long var6, long var8);

    public static int ParseEXRHeaderFromMemory(@NativeType(value="EXRHeader *") EXRHeader header, @NativeType(value="EXRVersion const *") EXRVersion version, @NativeType(value="unsigned char const *") ByteBuffer memory, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check(err, 1);
        }
        return TinyEXR.nParseEXRHeaderFromMemory(header.address(), version.address(), MemoryUtil.memAddress(memory), memory.remaining(), MemoryUtil.memAddress(err));
    }

    public static native int nParseEXRMultipartHeaderFromFile(long var0, long var2, long var4, long var6, long var8);

    public static int ParseEXRMultipartHeaderFromFile(@NativeType(value="EXRHeader ***") PointerBuffer headers, @NativeType(value="int *") IntBuffer num_headers, @NativeType(value="EXRVersion const *") EXRVersion version, @NativeType(value="char const *") ByteBuffer filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check(headers, 1);
            Checks.check((Buffer)num_headers, 1);
            Checks.checkNT1(filename);
            Checks.check(err, 1);
        }
        return TinyEXR.nParseEXRMultipartHeaderFromFile(MemoryUtil.memAddress(headers), MemoryUtil.memAddress(num_headers), version.address(), MemoryUtil.memAddress(filename), MemoryUtil.memAddress(err));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ParseEXRMultipartHeaderFromFile(@NativeType(value="EXRHeader ***") PointerBuffer headers, @NativeType(value="int *") IntBuffer num_headers, @NativeType(value="EXRVersion const *") EXRVersion version, @NativeType(value="char const *") CharSequence filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check(headers, 1);
            Checks.check((Buffer)num_headers, 1);
            Checks.check(err, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            int n = TinyEXR.nParseEXRMultipartHeaderFromFile(MemoryUtil.memAddress(headers), MemoryUtil.memAddress(num_headers), version.address(), MemoryUtil.memAddress(filenameEncoded), MemoryUtil.memAddress(err));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nParseEXRMultipartHeaderFromMemory(long var0, long var2, long var4, long var6, long var8, long var10);

    public static int ParseEXRMultipartHeaderFromMemory(@NativeType(value="EXRHeader ***") PointerBuffer headers, @NativeType(value="int *") IntBuffer num_headers, @NativeType(value="EXRVersion const *") EXRVersion version, @NativeType(value="unsigned char const *") ByteBuffer memory, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check(headers, 1);
            Checks.check((Buffer)num_headers, 1);
            Checks.check(err, 1);
        }
        return TinyEXR.nParseEXRMultipartHeaderFromMemory(MemoryUtil.memAddress(headers), MemoryUtil.memAddress(num_headers), version.address(), MemoryUtil.memAddress(memory), memory.remaining(), MemoryUtil.memAddress(err));
    }

    public static native int nLoadEXRImageFromFile(long var0, long var2, long var4, long var6);

    public static int LoadEXRImageFromFile(@NativeType(value="EXRImage *") EXRImage image, @NativeType(value="EXRHeader const *") EXRHeader header, @NativeType(value="char const *") ByteBuffer filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.check(err, 1);
            EXRHeader.validate(header.address());
        }
        return TinyEXR.nLoadEXRImageFromFile(image.address(), header.address(), MemoryUtil.memAddress(filename), MemoryUtil.memAddress(err));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int LoadEXRImageFromFile(@NativeType(value="EXRImage *") EXRImage image, @NativeType(value="EXRHeader const *") EXRHeader header, @NativeType(value="char const *") CharSequence filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check(err, 1);
            EXRHeader.validate(header.address());
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            int n = TinyEXR.nLoadEXRImageFromFile(image.address(), header.address(), MemoryUtil.memAddress(filenameEncoded), MemoryUtil.memAddress(err));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nLoadEXRImageFromMemory(long var0, long var2, long var4, long var6, long var8);

    public static int LoadEXRImageFromMemory(@NativeType(value="EXRImage *") EXRImage image, @NativeType(value="EXRHeader const *") EXRHeader header, @NativeType(value="unsigned char const *") ByteBuffer memory, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check(err, 1);
            EXRHeader.validate(header.address());
        }
        return TinyEXR.nLoadEXRImageFromMemory(image.address(), header.address(), MemoryUtil.memAddress(memory), memory.remaining(), MemoryUtil.memAddress(err));
    }

    public static native int nLoadEXRMultipartImageFromFile(long var0, long var2, int var4, long var5, long var7);

    public static int LoadEXRMultipartImageFromFile(@NativeType(value="EXRImage *") EXRImage.Buffer images, @NativeType(value="EXRHeader const **") PointerBuffer headers, @NativeType(value="char const *") ByteBuffer filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check(headers, images.remaining());
            Checks.checkNT1(filename);
            Checks.check(err, 1);
        }
        return TinyEXR.nLoadEXRMultipartImageFromFile(images.address(), MemoryUtil.memAddress(headers), images.remaining(), MemoryUtil.memAddress(filename), MemoryUtil.memAddress(err));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int LoadEXRMultipartImageFromFile(@NativeType(value="EXRImage *") EXRImage.Buffer images, @NativeType(value="EXRHeader const **") PointerBuffer headers, @NativeType(value="char const *") CharSequence filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check(headers, images.remaining());
            Checks.check(err, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            int n = TinyEXR.nLoadEXRMultipartImageFromFile(images.address(), MemoryUtil.memAddress(headers), images.remaining(), MemoryUtil.memAddress(filenameEncoded), MemoryUtil.memAddress(err));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nLoadEXRMultipartImageFromMemory(long var0, long var2, int var4, long var5, long var7, long var9);

    public static int LoadEXRMultipartImageFromMemory(@NativeType(value="EXRImage *") EXRImage.Buffer images, @NativeType(value="EXRHeader const **") PointerBuffer headers, @NativeType(value="unsigned char const *") ByteBuffer memory, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check(headers, images.remaining());
            Checks.check(err, 1);
        }
        return TinyEXR.nLoadEXRMultipartImageFromMemory(images.address(), MemoryUtil.memAddress(headers), images.remaining(), MemoryUtil.memAddress(memory), memory.remaining(), MemoryUtil.memAddress(err));
    }

    public static native int nSaveEXRImageToFile(long var0, long var2, long var4, long var6);

    public static int SaveEXRImageToFile(@NativeType(value="EXRImage const *") EXRImage image, @NativeType(value="EXRHeader const *") EXRHeader exr_header, @NativeType(value="char const *") ByteBuffer filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.check(err, 1);
            EXRImage.validate(image.address());
            EXRHeader.validate(exr_header.address());
        }
        return TinyEXR.nSaveEXRImageToFile(image.address(), exr_header.address(), MemoryUtil.memAddress(filename), MemoryUtil.memAddress(err));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int SaveEXRImageToFile(@NativeType(value="EXRImage const *") EXRImage image, @NativeType(value="EXRHeader const *") EXRHeader exr_header, @NativeType(value="char const *") CharSequence filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check(err, 1);
            EXRImage.validate(image.address());
            EXRHeader.validate(exr_header.address());
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            int n = TinyEXR.nSaveEXRImageToFile(image.address(), exr_header.address(), MemoryUtil.memAddress(filenameEncoded), MemoryUtil.memAddress(err));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nSaveEXRImageToMemory(long var0, long var2, long var4, long var6);

    @NativeType(value="size_t")
    public static long SaveEXRImageToMemory(@NativeType(value="EXRImage const *") EXRImage image, @NativeType(value="EXRHeader const *") EXRHeader exr_header, @NativeType(value="unsigned char **") PointerBuffer memory, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check(memory, 1);
            Checks.check(err, 1);
            EXRImage.validate(image.address());
            EXRHeader.validate(exr_header.address());
        }
        return TinyEXR.nSaveEXRImageToMemory(image.address(), exr_header.address(), MemoryUtil.memAddress(memory), MemoryUtil.memAddress(err));
    }

    public static native int nLoadDeepEXR(long var0, long var2, long var4);

    public static int LoadDeepEXR(@NativeType(value="DeepImage *") DeepImage out_image, @NativeType(value="char const *") ByteBuffer filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.check(err, 1);
        }
        return TinyEXR.nLoadDeepEXR(out_image.address(), MemoryUtil.memAddress(filename), MemoryUtil.memAddress(err));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int LoadDeepEXR(@NativeType(value="DeepImage *") DeepImage out_image, @NativeType(value="char const *") CharSequence filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check(err, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            int n = TinyEXR.nLoadDeepEXR(out_image.address(), MemoryUtil.memAddress(filenameEncoded), MemoryUtil.memAddress(err));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    static {
        Library.loadSystem(System::load, System::loadLibrary, TinyEXR.class, Platform.mapLibraryNameBundled("lwjgl_tinyexr"));
    }
}

