/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct LZ4_stream_t_internal")
public class LZ4StreamInternal
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HASHTABLE;
    public static final int CURRENTOFFSET;
    public static final int INITCHECK;
    public static final int TABLETYPE;
    public static final int DICTIONARY;
    public static final int DICTCTX;
    public static final int DICTSIZE;

    LZ4StreamInternal(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public LZ4StreamInternal(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), LZ4StreamInternal.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t[LZ4_HASH_SIZE_U32]")
    public IntBuffer hashTable() {
        return LZ4StreamInternal.nhashTable(this.address());
    }

    @NativeType(value="uint32_t")
    public int hashTable(int index) {
        return LZ4StreamInternal.nhashTable(this.address(), index);
    }

    @NativeType(value="uint32_t")
    public int currentOffset() {
        return LZ4StreamInternal.ncurrentOffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int initCheck() {
        return LZ4StreamInternal.ninitCheck(this.address());
    }

    @NativeType(value="uint16_t")
    public short tableType() {
        return LZ4StreamInternal.ntableType(this.address());
    }

    @NativeType(value="uint8_t const *")
    public ByteBuffer dictionary(int capacity) {
        return LZ4StreamInternal.ndictionary(this.address(), capacity);
    }

    @NativeType(value="LZ4_stream_t_internal * const")
    public LZ4StreamInternal dictCtx() {
        return LZ4StreamInternal.ndictCtx(this.address());
    }

    @NativeType(value="uint32_t")
    public int dictSize() {
        return LZ4StreamInternal.ndictSize(this.address());
    }

    public static LZ4StreamInternal create(long address) {
        return new LZ4StreamInternal(address, null);
    }

    @Nullable
    public static LZ4StreamInternal createSafe(long address) {
        return address == 0L ? null : LZ4StreamInternal.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : LZ4StreamInternal.create(address, capacity);
    }

    public static IntBuffer nhashTable(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)HASHTABLE, 4096);
    }

    public static int nhashTable(long struct, int index) {
        return MemoryUtil.memGetInt(struct + (long)HASHTABLE + Checks.check(index, 4096) * 4L);
    }

    public static int ncurrentOffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CURRENTOFFSET);
    }

    public static int ninitCheck(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INITCHECK);
    }

    public static short ntableType(long struct) {
        return MemoryUtil.memGetShort(struct + (long)TABLETYPE);
    }

    public static ByteBuffer ndictionary(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)DICTIONARY), capacity);
    }

    public static LZ4StreamInternal ndictCtx(long struct) {
        return LZ4StreamInternal.create(MemoryUtil.memGetAddress(struct + (long)DICTCTX));
    }

    public static int ndictSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DICTSIZE);
    }

    static {
        Struct.Layout layout = LZ4StreamInternal.__struct(LZ4StreamInternal.__array(4, 4096), LZ4StreamInternal.__member(4), LZ4StreamInternal.__member(4), LZ4StreamInternal.__member(2), LZ4StreamInternal.__member(POINTER_SIZE), LZ4StreamInternal.__member(POINTER_SIZE), LZ4StreamInternal.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HASHTABLE = layout.offsetof(0);
        CURRENTOFFSET = layout.offsetof(1);
        INITCHECK = layout.offsetof(2);
        TABLETYPE = layout.offsetof(3);
        DICTIONARY = layout.offsetof(4);
        DICTCTX = layout.offsetof(5);
        DICTSIZE = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<LZ4StreamInternal, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected LZ4StreamInternal newInstance(long address) {
            return new LZ4StreamInternal(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint32_t[LZ4_HASH_SIZE_U32]")
        public IntBuffer hashTable() {
            return LZ4StreamInternal.nhashTable(this.address());
        }

        @NativeType(value="uint32_t")
        public int hashTable(int index) {
            return LZ4StreamInternal.nhashTable(this.address(), index);
        }

        @NativeType(value="uint32_t")
        public int currentOffset() {
            return LZ4StreamInternal.ncurrentOffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int initCheck() {
            return LZ4StreamInternal.ninitCheck(this.address());
        }

        @NativeType(value="uint16_t")
        public short tableType() {
            return LZ4StreamInternal.ntableType(this.address());
        }

        @NativeType(value="uint8_t const *")
        public ByteBuffer dictionary(int capacity) {
            return LZ4StreamInternal.ndictionary(this.address(), capacity);
        }

        @NativeType(value="LZ4_stream_t_internal * const")
        public LZ4StreamInternal dictCtx() {
            return LZ4StreamInternal.ndictCtx(this.address());
        }

        @NativeType(value="uint32_t")
        public int dictSize() {
            return LZ4StreamInternal.ndictSize(this.address());
        }
    }
}

