/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.lz4.LZ4StreamInternal;

@NativeType(value="union LZ4_stream_t")
public class LZ4Stream
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TABLE;
    public static final int INTERNAL_DONOTUSE;

    LZ4Stream(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public LZ4Stream(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), LZ4Stream.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned long long[LZ4_STREAMSIZE_U64]")
    public LongBuffer table() {
        return LZ4Stream.ntable(this.address());
    }

    @NativeType(value="unsigned long long")
    public long table(int index) {
        return LZ4Stream.ntable(this.address(), index);
    }

    @NativeType(value="struct LZ4_stream_t_internal")
    public LZ4StreamInternal internal_donotuse() {
        return LZ4Stream.ninternal_donotuse(this.address());
    }

    public static LZ4Stream create(long address) {
        return new LZ4Stream(address, null);
    }

    @Nullable
    public static LZ4Stream createSafe(long address) {
        return address == 0L ? null : LZ4Stream.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : LZ4Stream.create(address, capacity);
    }

    public static LongBuffer ntable(long struct) {
        return MemoryUtil.memLongBuffer(struct + (long)TABLE, 2052);
    }

    public static long ntable(long struct, int index) {
        return MemoryUtil.memGetLong(struct + (long)TABLE + Checks.check(index, 2052) * 8L);
    }

    public static LZ4StreamInternal ninternal_donotuse(long struct) {
        return LZ4StreamInternal.create(struct + (long)INTERNAL_DONOTUSE);
    }

    static {
        Struct.Layout layout = LZ4Stream.__union(LZ4Stream.__array(8, 2052), LZ4Stream.__member(LZ4StreamInternal.SIZEOF, LZ4StreamInternal.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TABLE = layout.offsetof(0);
        INTERNAL_DONOTUSE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LZ4Stream, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected LZ4Stream newInstance(long address) {
            return new LZ4Stream(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="unsigned long long[LZ4_STREAMSIZE_U64]")
        public LongBuffer table() {
            return LZ4Stream.ntable(this.address());
        }

        @NativeType(value="unsigned long long")
        public long table(int index) {
            return LZ4Stream.ntable(this.address(), index);
        }

        @NativeType(value="struct LZ4_stream_t_internal")
        public LZ4StreamInternal internal_donotuse() {
            return LZ4Stream.ninternal_donotuse(this.address());
        }
    }
}

