/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct LZ4HC_CCtx_internal")
public class LZ4HCCCtxInternal
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HASHTABLE;
    public static final int CHAINTABLE;
    public static final int END;
    public static final int BASE;
    public static final int DICTBASE;
    public static final int DICTLIMIT;
    public static final int LOWLIMIT;
    public static final int NEXTTOUPDATE;
    public static final int COMPRESSIONLEVEL;
    public static final int FAVORDECSPEED;
    public static final int DICTCTX;

    LZ4HCCCtxInternal(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public LZ4HCCCtxInternal(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), LZ4HCCCtxInternal.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t[LZ4HC_HASHTABLESIZE]")
    public IntBuffer hashTable() {
        return LZ4HCCCtxInternal.nhashTable(this.address());
    }

    @NativeType(value="uint32_t")
    public int hashTable(int index) {
        return LZ4HCCCtxInternal.nhashTable(this.address(), index);
    }

    @NativeType(value="uint16_t[LZ4HC_MAXD]")
    public ShortBuffer chainTable() {
        return LZ4HCCCtxInternal.nchainTable(this.address());
    }

    @NativeType(value="uint16_t")
    public short chainTable(int index) {
        return LZ4HCCCtxInternal.nchainTable(this.address(), index);
    }

    @NativeType(value="uint8_t const *")
    public ByteBuffer end(int capacity) {
        return LZ4HCCCtxInternal.nend(this.address(), capacity);
    }

    @NativeType(value="uint8_t const *")
    public ByteBuffer base(int capacity) {
        return LZ4HCCCtxInternal.nbase(this.address(), capacity);
    }

    @NativeType(value="uint8_t const *")
    public ByteBuffer dictBase(int capacity) {
        return LZ4HCCCtxInternal.ndictBase(this.address(), capacity);
    }

    @NativeType(value="uint32_t")
    public int dictLimit() {
        return LZ4HCCCtxInternal.ndictLimit(this.address());
    }

    @NativeType(value="uint32_t")
    public int lowLimit() {
        return LZ4HCCCtxInternal.nlowLimit(this.address());
    }

    @NativeType(value="uint32_t")
    public int nextToUpdate() {
        return LZ4HCCCtxInternal.nnextToUpdate(this.address());
    }

    public short compressionLevel() {
        return LZ4HCCCtxInternal.ncompressionLevel(this.address());
    }

    public short favorDecSpeed() {
        return LZ4HCCCtxInternal.nfavorDecSpeed(this.address());
    }

    @NativeType(value="LZ4HC_CCtx_internal * const")
    public LZ4HCCCtxInternal dictCtx() {
        return LZ4HCCCtxInternal.ndictCtx(this.address());
    }

    public static LZ4HCCCtxInternal create(long address) {
        return new LZ4HCCCtxInternal(address, null);
    }

    @Nullable
    public static LZ4HCCCtxInternal createSafe(long address) {
        return address == 0L ? null : LZ4HCCCtxInternal.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : LZ4HCCCtxInternal.create(address, capacity);
    }

    public static IntBuffer nhashTable(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)HASHTABLE, 32768);
    }

    public static int nhashTable(long struct, int index) {
        return MemoryUtil.memGetInt(struct + (long)HASHTABLE + Checks.check(index, 32768) * 4L);
    }

    public static ShortBuffer nchainTable(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)CHAINTABLE, 65536);
    }

    public static short nchainTable(long struct, int index) {
        return MemoryUtil.memGetShort(struct + (long)CHAINTABLE + Checks.check(index, 65536) * 2L);
    }

    public static ByteBuffer nend(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)END), capacity);
    }

    public static ByteBuffer nbase(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)BASE), capacity);
    }

    public static ByteBuffer ndictBase(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)DICTBASE), capacity);
    }

    public static int ndictLimit(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DICTLIMIT);
    }

    public static int nlowLimit(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LOWLIMIT);
    }

    public static int nnextToUpdate(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NEXTTOUPDATE);
    }

    public static short ncompressionLevel(long struct) {
        return MemoryUtil.memGetShort(struct + (long)COMPRESSIONLEVEL);
    }

    public static short nfavorDecSpeed(long struct) {
        return MemoryUtil.memGetShort(struct + (long)FAVORDECSPEED);
    }

    public static LZ4HCCCtxInternal ndictCtx(long struct) {
        return LZ4HCCCtxInternal.create(MemoryUtil.memGetAddress(struct + (long)DICTCTX));
    }

    static {
        Struct.Layout layout = LZ4HCCCtxInternal.__struct(LZ4HCCCtxInternal.__array(4, 32768), LZ4HCCCtxInternal.__array(2, 65536), LZ4HCCCtxInternal.__member(POINTER_SIZE), LZ4HCCCtxInternal.__member(POINTER_SIZE), LZ4HCCCtxInternal.__member(POINTER_SIZE), LZ4HCCCtxInternal.__member(4), LZ4HCCCtxInternal.__member(4), LZ4HCCCtxInternal.__member(4), LZ4HCCCtxInternal.__member(2), LZ4HCCCtxInternal.__member(2), LZ4HCCCtxInternal.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HASHTABLE = layout.offsetof(0);
        CHAINTABLE = layout.offsetof(1);
        END = layout.offsetof(2);
        BASE = layout.offsetof(3);
        DICTBASE = layout.offsetof(4);
        DICTLIMIT = layout.offsetof(5);
        LOWLIMIT = layout.offsetof(6);
        NEXTTOUPDATE = layout.offsetof(7);
        COMPRESSIONLEVEL = layout.offsetof(8);
        FAVORDECSPEED = layout.offsetof(9);
        DICTCTX = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<LZ4HCCCtxInternal, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected LZ4HCCCtxInternal newInstance(long address) {
            return new LZ4HCCCtxInternal(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint32_t[LZ4HC_HASHTABLESIZE]")
        public IntBuffer hashTable() {
            return LZ4HCCCtxInternal.nhashTable(this.address());
        }

        @NativeType(value="uint32_t")
        public int hashTable(int index) {
            return LZ4HCCCtxInternal.nhashTable(this.address(), index);
        }

        @NativeType(value="uint16_t[LZ4HC_MAXD]")
        public ShortBuffer chainTable() {
            return LZ4HCCCtxInternal.nchainTable(this.address());
        }

        @NativeType(value="uint16_t")
        public short chainTable(int index) {
            return LZ4HCCCtxInternal.nchainTable(this.address(), index);
        }

        @NativeType(value="uint8_t const *")
        public ByteBuffer end(int capacity) {
            return LZ4HCCCtxInternal.nend(this.address(), capacity);
        }

        @NativeType(value="uint8_t const *")
        public ByteBuffer base(int capacity) {
            return LZ4HCCCtxInternal.nbase(this.address(), capacity);
        }

        @NativeType(value="uint8_t const *")
        public ByteBuffer dictBase(int capacity) {
            return LZ4HCCCtxInternal.ndictBase(this.address(), capacity);
        }

        @NativeType(value="uint32_t")
        public int dictLimit() {
            return LZ4HCCCtxInternal.ndictLimit(this.address());
        }

        @NativeType(value="uint32_t")
        public int lowLimit() {
            return LZ4HCCCtxInternal.nlowLimit(this.address());
        }

        @NativeType(value="uint32_t")
        public int nextToUpdate() {
            return LZ4HCCCtxInternal.nnextToUpdate(this.address());
        }

        public short compressionLevel() {
            return LZ4HCCCtxInternal.ncompressionLevel(this.address());
        }

        public short favorDecSpeed() {
            return LZ4HCCCtxInternal.nfavorDecSpeed(this.address());
        }

        @NativeType(value="LZ4HC_CCtx_internal * const")
        public LZ4HCCCtxInternal dictCtx() {
            return LZ4HCCCtxInternal.ndictCtx(this.address());
        }
    }
}

