/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.util.lz4.LibLZ4;

public class LZ4HC {
    public static final int LZ4HC_CLEVEL_MIN = 3;
    public static final int LZ4HC_CLEVEL_DEFAULT = 9;
    public static final int LZ4HC_CLEVEL_OPT_MIN = 10;
    public static final int LZ4HC_CLEVEL_MAX = 12;
    public static final int LZ4HC_DICTIONARY_LOGSIZE = 16;
    public static final int LZ4HC_MAXD = 65536;
    public static final int LZ4HC_MAXD_MASK = 65535;
    public static final int LZ4HC_HASH_LOG = 15;
    public static final int LZ4HC_HASHTABLESIZE = 32768;
    public static final int LZ4HC_HASH_MASK = Short.MAX_VALUE;
    public static final int LZ4_STREAMHCSIZE = 262200;
    public static final int LZ4_STREAMHCSIZE_SIZET = 262200 / Pointer.POINTER_SIZE;

    protected LZ4HC() {
        throw new UnsupportedOperationException();
    }

    public static native int nLZ4_compress_HC(long var0, long var2, int var4, int var5, int var6);

    public static int LZ4_compress_HC(@NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst, int compressionLevel) {
        return LZ4HC.nLZ4_compress_HC(MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), src.remaining(), dst.remaining(), compressionLevel);
    }

    public static native int LZ4_sizeofStateHC();

    public static native int nLZ4_compress_HC_extStateHC(long var0, long var2, long var4, int var6, int var7, int var8);

    public static int LZ4_compress_HC_extStateHC(@NativeType(value="void *") ByteBuffer state, @NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst, int compressionLevel) {
        return LZ4HC.nLZ4_compress_HC_extStateHC(MemoryUtil.memAddress(state), MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), src.remaining(), dst.remaining(), compressionLevel);
    }

    @NativeType(value="LZ4_streamHC_t *")
    public static native long LZ4_createStreamHC();

    public static native int nLZ4_freeStreamHC(long var0);

    public static int LZ4_freeStreamHC(@NativeType(value="LZ4_streamHC_t *") long streamHCPtr) {
        if (Checks.CHECKS) {
            Checks.check(streamHCPtr);
        }
        return LZ4HC.nLZ4_freeStreamHC(streamHCPtr);
    }

    public static native void nLZ4_resetStreamHC(long var0, int var2);

    public static void LZ4_resetStreamHC(@NativeType(value="LZ4_streamHC_t *") long streamHCPtr, int compressionLevel) {
        if (Checks.CHECKS) {
            Checks.check(streamHCPtr);
        }
        LZ4HC.nLZ4_resetStreamHC(streamHCPtr, compressionLevel);
    }

    public static native int nLZ4_loadDictHC(long var0, long var2, int var4);

    public static int LZ4_loadDictHC(@NativeType(value="LZ4_streamHC_t *") long streamHCPtr, @NativeType(value="char const *") ByteBuffer dictionary) {
        if (Checks.CHECKS) {
            Checks.check(streamHCPtr);
        }
        return LZ4HC.nLZ4_loadDictHC(streamHCPtr, MemoryUtil.memAddress(dictionary), dictionary.remaining());
    }

    public static native int nLZ4_compress_HC_continue(long var0, long var2, long var4, int var6, int var7);

    public static int LZ4_compress_HC_continue(@NativeType(value="LZ4_streamHC_t *") long streamHCPtr, @NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst) {
        if (Checks.CHECKS) {
            Checks.check(streamHCPtr);
        }
        return LZ4HC.nLZ4_compress_HC_continue(streamHCPtr, MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), src.remaining(), dst.remaining());
    }

    public static native int nLZ4_saveDictHC(long var0, long var2, int var4);

    public static int LZ4_saveDictHC(@NativeType(value="LZ4_streamHC_t *") long streamHCPtr, @NativeType(value="char *") ByteBuffer safeBuffer) {
        if (Checks.CHECKS) {
            Checks.check(streamHCPtr);
        }
        return LZ4HC.nLZ4_saveDictHC(streamHCPtr, MemoryUtil.memAddress(safeBuffer), safeBuffer.remaining());
    }

    public static native int nLZ4_compress_HC_destSize(long var0, long var2, long var4, long var6, int var8, int var9);

    public static int LZ4_compress_HC_destSize(@NativeType(value="void *") ByteBuffer LZ4HC_Data, @NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst, @NativeType(value="int *") IntBuffer srcSizePtr, int compressionLevel) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)srcSizePtr, 1);
            Checks.check((Buffer)src, srcSizePtr.get(srcSizePtr.position()));
        }
        return LZ4HC.nLZ4_compress_HC_destSize(MemoryUtil.memAddress(LZ4HC_Data), MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), MemoryUtil.memAddress(srcSizePtr), dst.remaining(), compressionLevel);
    }

    public static native int nLZ4_compress_HC_continue_destSize(long var0, long var2, long var4, long var6, int var8);

    public static int LZ4_compress_HC_continue_destSize(@NativeType(value="LZ4_streamHC_t *") long LZ4_streamHCPtr, @NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst, @NativeType(value="int *") IntBuffer srcSizePtr) {
        if (Checks.CHECKS) {
            Checks.check(LZ4_streamHCPtr);
            Checks.check((Buffer)srcSizePtr, 1);
            Checks.check((Buffer)src, srcSizePtr.get(srcSizePtr.position()));
        }
        return LZ4HC.nLZ4_compress_HC_continue_destSize(LZ4_streamHCPtr, MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), MemoryUtil.memAddress(srcSizePtr), dst.remaining());
    }

    public static native void nLZ4_setCompressionLevel(long var0, int var2);

    public static void LZ4_setCompressionLevel(@NativeType(value="LZ4_streamHC_t *") long LZ4_streamHCPtr, int compressionLevel) {
        if (Checks.CHECKS) {
            Checks.check(LZ4_streamHCPtr);
        }
        LZ4HC.nLZ4_setCompressionLevel(LZ4_streamHCPtr, compressionLevel);
    }

    public static native void nLZ4_favorDecompressionSpeed(long var0, int var2);

    public static void LZ4_favorDecompressionSpeed(@NativeType(value="LZ4_streamHC_t *") long LZ4_streamHCPtr, @NativeType(value="int") boolean favor) {
        if (Checks.CHECKS) {
            Checks.check(LZ4_streamHCPtr);
        }
        LZ4HC.nLZ4_favorDecompressionSpeed(LZ4_streamHCPtr, favor ? 1 : 0);
    }

    public static native void nLZ4_resetStreamHC_fast(long var0, int var2);

    public static void LZ4_resetStreamHC_fast(@NativeType(value="LZ4_streamHC_t *") long LZ4_streamHCPtr, int compressionLevel) {
        if (Checks.CHECKS) {
            Checks.check(LZ4_streamHCPtr);
        }
        LZ4HC.nLZ4_resetStreamHC_fast(LZ4_streamHCPtr, compressionLevel);
    }

    public static native int nLZ4_compress_HC_extStateHC_fastReset(long var0, long var2, long var4, int var6, int var7, int var8);

    public static int LZ4_compress_HC_extStateHC_fastReset(@NativeType(value="void *") ByteBuffer state, @NativeType(value="char * const") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst, int compressionLevel) {
        return LZ4HC.nLZ4_compress_HC_extStateHC_fastReset(MemoryUtil.memAddress(state), MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), src.remaining(), dst.remaining(), compressionLevel);
    }

    public static native void nLZ4_attach_HC_dictionary(long var0, long var2);

    public static void LZ4_attach_HC_dictionary(@NativeType(value="LZ4_streamHC_t *") long working_stream, @NativeType(value="LZ4_streamHC_t * const") long dictionary_stream) {
        if (Checks.CHECKS) {
            Checks.check(working_stream);
        }
        LZ4HC.nLZ4_attach_HC_dictionary(working_stream, dictionary_stream);
    }

    static {
        LibLZ4.initialize();
    }
}

