/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct LZ4F_compressOptions_t")
public class LZ4FCompressOptions
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STABLESRC;
    public static final int RESERVED;

    LZ4FCompressOptions(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public LZ4FCompressOptions(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), LZ4FCompressOptions.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned")
    public int stableSrc() {
        return LZ4FCompressOptions.nstableSrc(this.address());
    }

    @NativeType(value="unsigned[3]")
    public IntBuffer reserved() {
        return LZ4FCompressOptions.nreserved(this.address());
    }

    @NativeType(value="unsigned")
    public int reserved(int index) {
        return LZ4FCompressOptions.nreserved(this.address(), index);
    }

    public LZ4FCompressOptions stableSrc(@NativeType(value="unsigned") int value) {
        LZ4FCompressOptions.nstableSrc(this.address(), value);
        return this;
    }

    public LZ4FCompressOptions reserved(@NativeType(value="unsigned[3]") IntBuffer value) {
        LZ4FCompressOptions.nreserved(this.address(), value);
        return this;
    }

    public LZ4FCompressOptions reserved(int index, @NativeType(value="unsigned") int value) {
        LZ4FCompressOptions.nreserved(this.address(), index, value);
        return this;
    }

    public LZ4FCompressOptions set(int stableSrc, IntBuffer reserved) {
        this.stableSrc(stableSrc);
        this.reserved(reserved);
        return this;
    }

    public LZ4FCompressOptions set(LZ4FCompressOptions src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LZ4FCompressOptions malloc() {
        return LZ4FCompressOptions.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static LZ4FCompressOptions calloc() {
        return LZ4FCompressOptions.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static LZ4FCompressOptions create() {
        return new LZ4FCompressOptions(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static LZ4FCompressOptions create(long address) {
        return new LZ4FCompressOptions(address, null);
    }

    @Nullable
    public static LZ4FCompressOptions createSafe(long address) {
        return address == 0L ? null : LZ4FCompressOptions.create(address);
    }

    public static Buffer malloc(int capacity) {
        return LZ4FCompressOptions.create(LZ4FCompressOptions.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return LZ4FCompressOptions.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(LZ4FCompressOptions.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : LZ4FCompressOptions.create(address, capacity);
    }

    public static LZ4FCompressOptions mallocStack() {
        return LZ4FCompressOptions.mallocStack(MemoryStack.stackGet());
    }

    public static LZ4FCompressOptions callocStack() {
        return LZ4FCompressOptions.callocStack(MemoryStack.stackGet());
    }

    public static LZ4FCompressOptions mallocStack(MemoryStack stack) {
        return LZ4FCompressOptions.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LZ4FCompressOptions callocStack(MemoryStack stack) {
        return LZ4FCompressOptions.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return LZ4FCompressOptions.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return LZ4FCompressOptions.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return LZ4FCompressOptions.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return LZ4FCompressOptions.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nstableSrc(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STABLESRC);
    }

    public static IntBuffer nreserved(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)RESERVED, 3);
    }

    public static int nreserved(long struct, int index) {
        return MemoryUtil.memGetInt(struct + (long)RESERVED + Checks.check(index, 3) * 4L);
    }

    public static void nstableSrc(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STABLESRC, value);
    }

    public static void nreserved(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RESERVED, value.remaining() * 4);
    }

    public static void nreserved(long struct, int index, int value) {
        MemoryUtil.memPutInt(struct + (long)RESERVED + Checks.check(index, 3) * 4L, value);
    }

    static {
        Struct.Layout layout = LZ4FCompressOptions.__struct(LZ4FCompressOptions.__member(4), LZ4FCompressOptions.__array(4, 3));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STABLESRC = layout.offsetof(0);
        RESERVED = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LZ4FCompressOptions, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected LZ4FCompressOptions newInstance(long address) {
            return new LZ4FCompressOptions(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="unsigned")
        public int stableSrc() {
            return LZ4FCompressOptions.nstableSrc(this.address());
        }

        @NativeType(value="unsigned[3]")
        public IntBuffer reserved() {
            return LZ4FCompressOptions.nreserved(this.address());
        }

        @NativeType(value="unsigned")
        public int reserved(int index) {
            return LZ4FCompressOptions.nreserved(this.address(), index);
        }

        public Buffer stableSrc(@NativeType(value="unsigned") int value) {
            LZ4FCompressOptions.nstableSrc(this.address(), value);
            return this;
        }

        public Buffer reserved(@NativeType(value="unsigned[3]") IntBuffer value) {
            LZ4FCompressOptions.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, @NativeType(value="unsigned") int value) {
            LZ4FCompressOptions.nreserved(this.address(), index, value);
            return this;
        }
    }
}

