/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.rpmalloc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct rpmalloc_global_statistics_t")
public class RPmallocGlobalStatistics
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAPPED;
    public static final int CACHED;
    public static final int MAPPED_TOTAL;
    public static final int UNMAPPED_TOTAL;

    RPmallocGlobalStatistics(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public RPmallocGlobalStatistics(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), RPmallocGlobalStatistics.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long mapped() {
        return RPmallocGlobalStatistics.nmapped(this.address());
    }

    @NativeType(value="size_t")
    public long cached() {
        return RPmallocGlobalStatistics.ncached(this.address());
    }

    @NativeType(value="size_t")
    public long mapped_total() {
        return RPmallocGlobalStatistics.nmapped_total(this.address());
    }

    @NativeType(value="size_t")
    public long unmapped_total() {
        return RPmallocGlobalStatistics.nunmapped_total(this.address());
    }

    public static RPmallocGlobalStatistics malloc() {
        return RPmallocGlobalStatistics.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static RPmallocGlobalStatistics calloc() {
        return RPmallocGlobalStatistics.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static RPmallocGlobalStatistics create() {
        return new RPmallocGlobalStatistics(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static RPmallocGlobalStatistics create(long address) {
        return new RPmallocGlobalStatistics(address, null);
    }

    @Nullable
    public static RPmallocGlobalStatistics createSafe(long address) {
        return address == 0L ? null : RPmallocGlobalStatistics.create(address);
    }

    public static Buffer malloc(int capacity) {
        return RPmallocGlobalStatistics.create(RPmallocGlobalStatistics.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return RPmallocGlobalStatistics.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(RPmallocGlobalStatistics.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : RPmallocGlobalStatistics.create(address, capacity);
    }

    public static RPmallocGlobalStatistics mallocStack() {
        return RPmallocGlobalStatistics.mallocStack(MemoryStack.stackGet());
    }

    public static RPmallocGlobalStatistics callocStack() {
        return RPmallocGlobalStatistics.callocStack(MemoryStack.stackGet());
    }

    public static RPmallocGlobalStatistics mallocStack(MemoryStack stack) {
        return RPmallocGlobalStatistics.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static RPmallocGlobalStatistics callocStack(MemoryStack stack) {
        return RPmallocGlobalStatistics.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return RPmallocGlobalStatistics.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return RPmallocGlobalStatistics.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return RPmallocGlobalStatistics.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return RPmallocGlobalStatistics.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nmapped(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MAPPED);
    }

    public static long ncached(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CACHED);
    }

    public static long nmapped_total(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MAPPED_TOTAL);
    }

    public static long nunmapped_total(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)UNMAPPED_TOTAL);
    }

    static {
        Struct.Layout layout = RPmallocGlobalStatistics.__struct(RPmallocGlobalStatistics.__member(POINTER_SIZE), RPmallocGlobalStatistics.__member(POINTER_SIZE), RPmallocGlobalStatistics.__member(POINTER_SIZE), RPmallocGlobalStatistics.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAPPED = layout.offsetof(0);
        CACHED = layout.offsetof(1);
        MAPPED_TOTAL = layout.offsetof(2);
        UNMAPPED_TOTAL = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<RPmallocGlobalStatistics, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected RPmallocGlobalStatistics newInstance(long address) {
            return new RPmallocGlobalStatistics(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="size_t")
        public long mapped() {
            return RPmallocGlobalStatistics.nmapped(this.address());
        }

        @NativeType(value="size_t")
        public long cached() {
            return RPmallocGlobalStatistics.ncached(this.address());
        }

        @NativeType(value="size_t")
        public long mapped_total() {
            return RPmallocGlobalStatistics.nmapped_total(this.address());
        }

        @NativeType(value="size_t")
        public long unmapped_total() {
            return RPmallocGlobalStatistics.nunmapped_total(this.address());
        }
    }
}

