/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;

public abstract class StructBuffer<T extends Struct, SELF extends StructBuffer<T, SELF>>
extends CustomBuffer<SELF>
implements Iterable<T> {
    protected StructBuffer(ByteBuffer container, int remaining) {
        this(MemoryUtil.memAddress(container), container, -1, 0, remaining, remaining);
    }

    protected StructBuffer(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
        super(address, container, mark, position, limit, capacity);
    }

    public T get() {
        return this.nget(this.nextGetIndex());
    }

    public SELF get(T value) {
        MemoryUtil.memCopy(this.address + this.nextGetIndex() * (long)this.sizeof(), ((Pointer.Default)value).address(), this.sizeof());
        return (SELF)((StructBuffer)this.self());
    }

    @Override
    public SELF put(T value) {
        MemoryUtil.memCopy(((Pointer.Default)value).address(), this.address + this.nextPutIndex() * (long)this.sizeof(), this.sizeof());
        return (SELF)((StructBuffer)this.self());
    }

    public T get(int index) {
        return this.nget(Checks.check(index, this.limit));
    }

    private T nget(long index) {
        return this.newInstance(this.address + index * (long)this.sizeof());
    }

    public SELF get(int index, T value) {
        MemoryUtil.memCopy(this.address + Checks.check(index, this.limit) * (long)this.sizeof(), ((Pointer.Default)value).address(), this.sizeof());
        return (SELF)((StructBuffer)this.self());
    }

    public SELF put(int index, T value) {
        MemoryUtil.memCopy(((Pointer.Default)value).address(), this.address + Checks.check(index, this.limit) * (long)this.sizeof(), this.sizeof());
        return (SELF)((StructBuffer)this.self());
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index;
            int fence;
            {
                this.index = StructBuffer.this.position;
                this.fence = StructBuffer.this.limit;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.fence;
            }

            @Override
            public T next() {
                return StructBuffer.this.nget(this.index++);
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                int i;
                Objects.requireNonNull(action);
                try {
                    for (i = this.index; i < this.fence; ++i) {
                        action.accept(StructBuffer.this.nget(i));
                    }
                }
                finally {
                    this.index = i;
                }
            }
        };
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        int fence = this.limit;
        for (int i = this.position; i < fence; ++i) {
            action.accept(this.nget(i));
        }
    }

    @Override
    public Spliterator<T> spliterator() {
        return new StructSpliterator();
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Stream<T> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    protected abstract T newInstance(long var1);

    private class StructSpliterator
    implements Spliterator<T> {
        private int index;
        private final int fence;

        StructSpliterator() {
            this(structBuffer.position, structBuffer.limit);
        }

        StructSpliterator(int origin, int fence) {
            this.index = origin;
            this.fence = fence;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            if (this.index < this.fence) {
                action.accept(StructBuffer.this.nget(this.index++));
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public Spliterator<T> trySplit() {
            StructSpliterator structSpliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo < mid) {
                this.index = mid;
                StructSpliterator structSpliterator2 = new StructSpliterator(lo, this.index);
                structSpliterator = structSpliterator2;
            } else {
                structSpliterator = null;
            }
            return structSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17744;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            int i;
            Objects.requireNonNull(action);
            try {
                for (i = this.index; i < this.fence; ++i) {
                    action.accept(StructBuffer.this.nget(i));
                }
            }
            finally {
                this.index = i;
            }
        }

        @Override
        public Comparator<? super T> getComparator() {
            throw new IllegalStateException();
        }
    }
}

