/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public abstract class Struct
extends Pointer.Default {
    @Nullable
    private ByteBuffer container;

    protected Struct(long address, @Nullable ByteBuffer container) {
        super(address);
        this.container = container;
    }

    public abstract int sizeof();

    public void clear() {
        MemoryUtil.memSet(this.address(), 0, this.sizeof());
    }

    public void free() {
        MemoryUtil.nmemFree(this.address());
    }

    public boolean isNull(int memberOffset) {
        if (Checks.DEBUG) {
            this.checkMemberOffset(memberOffset);
        }
        return MemoryUtil.memGetAddress(this.address() + (long)memberOffset) == 0L;
    }

    private void checkMemberOffset(int memberOffset) {
        if (memberOffset < 0 || this.sizeof() - memberOffset < POINTER_SIZE) {
            throw new IllegalArgumentException("Invalid member offset.");
        }
    }

    protected static ByteBuffer __checkContainer(ByteBuffer container, int sizeof) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)container, sizeof);
        }
        return container;
    }

    private static long getBytes(int elements, int elementSize) {
        return Integer.toUnsignedLong(elements) * (long)elementSize;
    }

    protected static long __malloc(int elements, int elementSize) {
        long bytes = Struct.getBytes(elements, elementSize);
        APIUtil.apiCheckAllocation(elements, bytes, BITS64 ? Long.MAX_VALUE : 0xFFFFFFFFL);
        return MemoryUtil.nmemAllocChecked(bytes);
    }

    protected static ByteBuffer __create(int elements, int elementSize) {
        APIUtil.apiCheckAllocation(elements, Struct.getBytes(elements, elementSize), Integer.MAX_VALUE);
        return BufferUtils.createByteBuffer(elements * elementSize);
    }

    protected static Member __padding(int size, boolean condition) {
        return Struct.__member(condition ? size : 0, 1);
    }

    protected static Member __member(int size) {
        return Struct.__member(size, size);
    }

    protected static Member __member(int size, int alignment) {
        return new Member(size, alignment);
    }

    protected static Member __array(int size, int length) {
        return Struct.__array(size, size, length);
    }

    protected static Member __array(int size, int alignment, int length) {
        return new Member(size * length, alignment);
    }

    protected static Layout __union(Member ... members) {
        ArrayList<Member> union = new ArrayList<Member>(members.length);
        int size = 0;
        int alignment = 0;
        for (int i = 0; i < members.length; ++i) {
            size = Math.max(size, members[i].size);
            alignment = Math.max(alignment, members[i].alignment);
            members[i].offset = 0;
            union.add(members[i]);
            if (!(members[i] instanceof Layout)) continue;
            Struct.addNestedMembers(members[i], union, 0);
        }
        return new Layout(size, alignment, union.toArray(new Member[0]));
    }

    protected static Layout __struct(Member ... members) {
        ArrayList<Member> struct = new ArrayList<Member>(members.length);
        int size = 0;
        int alignment = 0;
        for (int i = 0; i < members.length; ++i) {
            Member m = members[i];
            m.offset = Struct.align(size, m.alignment);
            size = m.offset + m.size;
            alignment = Math.max(alignment, m.alignment);
            struct.add(m);
            if (!(m instanceof Layout)) continue;
            Struct.addNestedMembers(m, struct, m.offset);
        }
        size = Struct.align(size, alignment);
        return new Layout(size, alignment, struct.toArray(new Member[0]));
    }

    private static void addNestedMembers(Member nested, List<Member> members, int offset) {
        Layout layout = (Layout)nested;
        for (Member m : layout.members) {
            m.offset += offset;
            members.add(m);
        }
    }

    private static int align(int offset, int alignment) {
        return (offset - 1 | alignment - 1) + 1;
    }

    static {
        Library.initialize();
    }

    protected static class Layout
    extends Member {
        public final Member[] members;

        public Layout(int size, int alignment, Member[] members) {
            super(size, alignment);
            this.members = members;
        }

        public int offsetof(int member) {
            return this.members[member].offset;
        }
    }

    protected static class Member {
        final int size;
        final int alignment;
        int offset;

        protected Member(int size, int alignment) {
            this.size = size;
            this.alignment = alignment;
        }

        public int getSize() {
            return this.size;
        }

        public int getAlignment() {
            return this.alignment;
        }
    }
}

