/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.ByteBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MathUtil;
import org.lwjgl.system.MemoryUtil;

class MemoryTextUtil {
    protected MemoryTextUtil() {
    }

    int strlen64NT1(long address, int maxLength) {
        int i;
        ByteBuffer buffer = MemoryUtil.memByteBuffer(address, Integer.MAX_VALUE);
        if (8 <= maxLength) {
            int misalignment = (int)address & 7;
            if (misalignment != 0) {
                int len = 8 - misalignment;
                for (i = 0; i < len; ++i) {
                    if (buffer.get(i) != 0) continue;
                    return i;
                }
            }
            while (i <= maxLength - 8 && !MathUtil.mathHasZeroByte(buffer.getLong(i))) {
                i += 8;
            }
        }
        while (i < maxLength && buffer.get(i) != 0) {
            ++i;
        }
        return i;
    }

    int strlen64NT2(long address, int maxLength) {
        int i;
        ByteBuffer buffer = MemoryUtil.memByteBuffer(address, Integer.MAX_VALUE);
        if (8 <= maxLength) {
            int misalignment = (int)address & 7;
            if (misalignment != 0) {
                int len = 8 - misalignment;
                for (i = 0; i < len; i += 2) {
                    if (buffer.getShort(i) != 0) continue;
                    return i;
                }
            }
            while (i <= maxLength - 8 && !MathUtil.mathHasZeroShort(buffer.getLong(i))) {
                i += 8;
            }
        }
        while (i < maxLength && buffer.getShort(i) != 0) {
            i += 2;
        }
        return i;
    }

    int strlen32NT1(long address, int maxLength) {
        int i;
        ByteBuffer buffer = MemoryUtil.memByteBuffer(address, Integer.MAX_VALUE);
        if (4 <= maxLength) {
            int misalignment = (int)address & 3;
            if (misalignment != 0) {
                int len = 4 - misalignment;
                for (i = 0; i < len; ++i) {
                    if (buffer.get(i) != 0) continue;
                    return i;
                }
            }
            while (i <= maxLength - 4 && !MathUtil.mathHasZeroByte(buffer.getInt(i))) {
                i += 4;
            }
        }
        while (i < maxLength && buffer.get(i) != 0) {
            ++i;
        }
        return i;
    }

    int strlen32NT2(long address, int maxLength) {
        int i;
        ByteBuffer buffer = MemoryUtil.memByteBuffer(address, Integer.MAX_VALUE);
        if (4 <= maxLength) {
            int misalignment = (int)address & 3;
            if (misalignment != 0) {
                int len = 4 - misalignment;
                for (i = 0; i < len; i += 2) {
                    if (buffer.getShort(i) != 0) continue;
                    return i;
                }
            }
            while (i <= maxLength - 4 && !MathUtil.mathHasZeroShort(buffer.getInt(i))) {
                i += 4;
            }
        }
        while (i < maxLength && buffer.getShort(i) != 0) {
            i += 2;
        }
        return i;
    }

    int encodeASCII(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            target.put(offset + i, (byte)text.charAt(i));
        }
        if (nullTerminated) {
            target.put(offset + len, (byte)0);
        }
        return len + (nullTerminated ? 1 : 0);
    }

    int encodeUTF8(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
        int c;
        int i;
        int len = text.length();
        int p = offset;
        for (i = 0; i < len && (c = text.charAt(i)) < 128; ++i) {
            target.put(p++, (byte)c);
        }
        while (i < len) {
            if ((c = text.charAt(i++)) < 128) {
                target.put(p++, (byte)c);
                continue;
            }
            int cp = c;
            if (c < 2048) {
                target.put(p++, (byte)(0xC0 | cp >> 6));
            } else {
                if (!Character.isHighSurrogate((char)c)) {
                    target.put(p++, (byte)(0xE0 | cp >> 12));
                } else {
                    cp = Character.toCodePoint((char)c, text.charAt(i++));
                    target.put(p++, (byte)(0xF0 | cp >> 18));
                    target.put(p++, (byte)(0x80 | cp >> 12 & 0x3F));
                }
                target.put(p++, (byte)(0x80 | cp >> 6 & 0x3F));
            }
            target.put(p++, (byte)(0x80 | cp & 0x3F));
        }
        if (nullTerminated) {
            target.put(p++, (byte)0);
        }
        return p - offset;
    }

    static int encodeUTF8Length(CharSequence value) {
        int i;
        int len;
        int bytes = len = value.length();
        for (i = 0; i < len && '\u0080' > value.charAt(i); ++i) {
        }
        while (i < len) {
            char c = value.charAt(i);
            if ('\u0800' <= c) {
                bytes += MemoryTextUtil.encodeUTF8LengthSlow(value, i, len);
                break;
            }
            bytes += 127 - c >>> 31;
            ++i;
        }
        return bytes;
    }

    private static int encodeUTF8LengthSlow(CharSequence value, int offset, int len) {
        int bytes = 0;
        for (int i = offset; i < len; ++i) {
            char c = value.charAt(i);
            if (c < '\u0800') {
                bytes += 127 - c >>> 31;
                continue;
            }
            if (c < '\ud800' || '\udfff' < c) {
                bytes += 2;
                continue;
            }
            if (Checks.DEBUG) {
                MemoryTextUtil.checkSurrogatePair(value, i, len);
            }
            bytes += 2;
            ++i;
        }
        return bytes;
    }

    private static void checkSurrogatePair(CharSequence value, int offset, int len) {
        char hi = value.charAt(offset);
        if (len <= offset) {
            throw new RuntimeException(String.format("Character sequence ends with single surrogate character: 0x%X", Character.valueOf(hi)));
        }
        char lo = value.charAt(offset + 1);
        if (!Character.isSurrogatePair(hi, lo)) {
            throw new RuntimeException(String.format("Malformed surrogate pair: 0x%X - 0x%X", Character.valueOf(hi), Character.valueOf(lo)));
        }
    }

    int encodeUTF16(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            target.putChar(offset + 2 * i, text.charAt(i));
        }
        if (nullTerminated) {
            target.putChar(offset + 2 * len, '\u0000');
        }
        return 2 * (len + (nullTerminated ? 1 : 0));
    }
}

