/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrVector4f")
public class OVRVector4f
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;
    public static final int W;

    OVRVector4f(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRVector4f(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRVector4f.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return OVRVector4f.nx(this.address());
    }

    public float y() {
        return OVRVector4f.ny(this.address());
    }

    public float z() {
        return OVRVector4f.nz(this.address());
    }

    public float w() {
        return OVRVector4f.nw(this.address());
    }

    public OVRVector4f x(float value) {
        OVRVector4f.nx(this.address(), value);
        return this;
    }

    public OVRVector4f y(float value) {
        OVRVector4f.ny(this.address(), value);
        return this;
    }

    public OVRVector4f z(float value) {
        OVRVector4f.nz(this.address(), value);
        return this;
    }

    public OVRVector4f w(float value) {
        OVRVector4f.nw(this.address(), value);
        return this;
    }

    public OVRVector4f set(float x, float y, float z, float w) {
        this.x(x);
        this.y(y);
        this.z(z);
        this.w(w);
        return this;
    }

    public OVRVector4f set(OVRVector4f src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRVector4f malloc() {
        return OVRVector4f.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static OVRVector4f calloc() {
        return OVRVector4f.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static OVRVector4f create() {
        return new OVRVector4f(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRVector4f create(long address) {
        return new OVRVector4f(address, null);
    }

    @Nullable
    public static OVRVector4f createSafe(long address) {
        return address == 0L ? null : OVRVector4f.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRVector4f.create(OVRVector4f.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRVector4f.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRVector4f.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRVector4f.create(address, capacity);
    }

    public static OVRVector4f mallocStack() {
        return OVRVector4f.mallocStack(MemoryStack.stackGet());
    }

    public static OVRVector4f callocStack() {
        return OVRVector4f.callocStack(MemoryStack.stackGet());
    }

    public static OVRVector4f mallocStack(MemoryStack stack) {
        return OVRVector4f.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRVector4f callocStack(MemoryStack stack) {
        return OVRVector4f.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRVector4f.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRVector4f.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRVector4f.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRVector4f.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static float nz(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Z);
    }

    public static float nw(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)W);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Z, value);
    }

    public static void nw(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)W, value);
    }

    static {
        Struct.Layout layout = OVRVector4f.__struct(OVRVector4f.__member(4), OVRVector4f.__member(4), OVRVector4f.__member(4), OVRVector4f.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
        W = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<OVRVector4f, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRVector4f newInstance(long address) {
            return new OVRVector4f(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float x() {
            return OVRVector4f.nx(this.address());
        }

        public float y() {
            return OVRVector4f.ny(this.address());
        }

        public float z() {
            return OVRVector4f.nz(this.address());
        }

        public float w() {
            return OVRVector4f.nw(this.address());
        }

        public Buffer x(float value) {
            OVRVector4f.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            OVRVector4f.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            OVRVector4f.nz(this.address(), value);
            return this;
        }

        public Buffer w(float value) {
            OVRVector4f.nw(this.address(), value);
            return this;
        }
    }
}

