/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrTextureSwapChainDesc")
public class OVRTextureSwapChainDesc
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int FORMAT;
    public static final int ARRAYSIZE;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int MIPLEVELS;
    public static final int SAMPLECOUNT;
    public static final int STATICIMAGE;
    public static final int MISCFLAGS;
    public static final int BINDFLAGS;

    OVRTextureSwapChainDesc(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRTextureSwapChainDesc(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRTextureSwapChainDesc.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrTextureType")
    public int Type() {
        return OVRTextureSwapChainDesc.nType(this.address());
    }

    @NativeType(value="ovrTextureFormat")
    public int Format() {
        return OVRTextureSwapChainDesc.nFormat(this.address());
    }

    public int ArraySize() {
        return OVRTextureSwapChainDesc.nArraySize(this.address());
    }

    public int Width() {
        return OVRTextureSwapChainDesc.nWidth(this.address());
    }

    public int Height() {
        return OVRTextureSwapChainDesc.nHeight(this.address());
    }

    public int MipLevels() {
        return OVRTextureSwapChainDesc.nMipLevels(this.address());
    }

    public int SampleCount() {
        return OVRTextureSwapChainDesc.nSampleCount(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean StaticImage() {
        return OVRTextureSwapChainDesc.nStaticImage(this.address());
    }

    @NativeType(value="unsigned int")
    public int MiscFlags() {
        return OVRTextureSwapChainDesc.nMiscFlags(this.address());
    }

    @NativeType(value="unsigned int")
    public int BindFlags() {
        return OVRTextureSwapChainDesc.nBindFlags(this.address());
    }

    public OVRTextureSwapChainDesc Type(@NativeType(value="ovrTextureType") int value) {
        OVRTextureSwapChainDesc.nType(this.address(), value);
        return this;
    }

    public OVRTextureSwapChainDesc Format(@NativeType(value="ovrTextureFormat") int value) {
        OVRTextureSwapChainDesc.nFormat(this.address(), value);
        return this;
    }

    public OVRTextureSwapChainDesc ArraySize(int value) {
        OVRTextureSwapChainDesc.nArraySize(this.address(), value);
        return this;
    }

    public OVRTextureSwapChainDesc Width(int value) {
        OVRTextureSwapChainDesc.nWidth(this.address(), value);
        return this;
    }

    public OVRTextureSwapChainDesc Height(int value) {
        OVRTextureSwapChainDesc.nHeight(this.address(), value);
        return this;
    }

    public OVRTextureSwapChainDesc MipLevels(int value) {
        OVRTextureSwapChainDesc.nMipLevels(this.address(), value);
        return this;
    }

    public OVRTextureSwapChainDesc SampleCount(int value) {
        OVRTextureSwapChainDesc.nSampleCount(this.address(), value);
        return this;
    }

    public OVRTextureSwapChainDesc StaticImage(@NativeType(value="ovrBool") boolean value) {
        OVRTextureSwapChainDesc.nStaticImage(this.address(), value);
        return this;
    }

    public OVRTextureSwapChainDesc MiscFlags(@NativeType(value="unsigned int") int value) {
        OVRTextureSwapChainDesc.nMiscFlags(this.address(), value);
        return this;
    }

    public OVRTextureSwapChainDesc BindFlags(@NativeType(value="unsigned int") int value) {
        OVRTextureSwapChainDesc.nBindFlags(this.address(), value);
        return this;
    }

    public OVRTextureSwapChainDesc set(int Type2, int Format2, int ArraySize, int Width, int Height, int MipLevels, int SampleCount, boolean StaticImage, int MiscFlags, int BindFlags) {
        this.Type(Type2);
        this.Format(Format2);
        this.ArraySize(ArraySize);
        this.Width(Width);
        this.Height(Height);
        this.MipLevels(MipLevels);
        this.SampleCount(SampleCount);
        this.StaticImage(StaticImage);
        this.MiscFlags(MiscFlags);
        this.BindFlags(BindFlags);
        return this;
    }

    public OVRTextureSwapChainDesc set(OVRTextureSwapChainDesc src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRTextureSwapChainDesc malloc() {
        return OVRTextureSwapChainDesc.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static OVRTextureSwapChainDesc calloc() {
        return OVRTextureSwapChainDesc.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static OVRTextureSwapChainDesc create() {
        return new OVRTextureSwapChainDesc(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRTextureSwapChainDesc create(long address) {
        return new OVRTextureSwapChainDesc(address, null);
    }

    @Nullable
    public static OVRTextureSwapChainDesc createSafe(long address) {
        return address == 0L ? null : OVRTextureSwapChainDesc.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRTextureSwapChainDesc.create(OVRTextureSwapChainDesc.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRTextureSwapChainDesc.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRTextureSwapChainDesc.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRTextureSwapChainDesc.create(address, capacity);
    }

    public static OVRTextureSwapChainDesc mallocStack() {
        return OVRTextureSwapChainDesc.mallocStack(MemoryStack.stackGet());
    }

    public static OVRTextureSwapChainDesc callocStack() {
        return OVRTextureSwapChainDesc.callocStack(MemoryStack.stackGet());
    }

    public static OVRTextureSwapChainDesc mallocStack(MemoryStack stack) {
        return OVRTextureSwapChainDesc.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRTextureSwapChainDesc callocStack(MemoryStack stack) {
        return OVRTextureSwapChainDesc.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRTextureSwapChainDesc.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRTextureSwapChainDesc.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRTextureSwapChainDesc.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRTextureSwapChainDesc.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int nFormat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FORMAT);
    }

    public static int nArraySize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ARRAYSIZE);
    }

    public static int nWidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WIDTH);
    }

    public static int nHeight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEIGHT);
    }

    public static int nMipLevels(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MIPLEVELS);
    }

    public static int nSampleCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLECOUNT);
    }

    public static boolean nStaticImage(long struct) {
        return MemoryUtil.memGetByte(struct + (long)STATICIMAGE) != 0;
    }

    public static int nMiscFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MISCFLAGS);
    }

    public static int nBindFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BINDFLAGS);
    }

    public static void nType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nFormat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FORMAT, value);
    }

    public static void nArraySize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ARRAYSIZE, value);
    }

    public static void nWidth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WIDTH, value);
    }

    public static void nHeight(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HEIGHT, value);
    }

    public static void nMipLevels(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MIPLEVELS, value);
    }

    public static void nSampleCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SAMPLECOUNT, value);
    }

    public static void nStaticImage(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)STATICIMAGE, value ? (byte)1 : 0);
    }

    public static void nMiscFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MISCFLAGS, value);
    }

    public static void nBindFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BINDFLAGS, value);
    }

    static {
        Struct.Layout layout = OVRTextureSwapChainDesc.__struct(OVRTextureSwapChainDesc.__member(4), OVRTextureSwapChainDesc.__member(4), OVRTextureSwapChainDesc.__member(4), OVRTextureSwapChainDesc.__member(4), OVRTextureSwapChainDesc.__member(4), OVRTextureSwapChainDesc.__member(4), OVRTextureSwapChainDesc.__member(4), OVRTextureSwapChainDesc.__member(1), OVRTextureSwapChainDesc.__member(4), OVRTextureSwapChainDesc.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        FORMAT = layout.offsetof(1);
        ARRAYSIZE = layout.offsetof(2);
        WIDTH = layout.offsetof(3);
        HEIGHT = layout.offsetof(4);
        MIPLEVELS = layout.offsetof(5);
        SAMPLECOUNT = layout.offsetof(6);
        STATICIMAGE = layout.offsetof(7);
        MISCFLAGS = layout.offsetof(8);
        BINDFLAGS = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<OVRTextureSwapChainDesc, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRTextureSwapChainDesc newInstance(long address) {
            return new OVRTextureSwapChainDesc(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrTextureType")
        public int Type() {
            return OVRTextureSwapChainDesc.nType(this.address());
        }

        @NativeType(value="ovrTextureFormat")
        public int Format() {
            return OVRTextureSwapChainDesc.nFormat(this.address());
        }

        public int ArraySize() {
            return OVRTextureSwapChainDesc.nArraySize(this.address());
        }

        public int Width() {
            return OVRTextureSwapChainDesc.nWidth(this.address());
        }

        public int Height() {
            return OVRTextureSwapChainDesc.nHeight(this.address());
        }

        public int MipLevels() {
            return OVRTextureSwapChainDesc.nMipLevels(this.address());
        }

        public int SampleCount() {
            return OVRTextureSwapChainDesc.nSampleCount(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean StaticImage() {
            return OVRTextureSwapChainDesc.nStaticImage(this.address());
        }

        @NativeType(value="unsigned int")
        public int MiscFlags() {
            return OVRTextureSwapChainDesc.nMiscFlags(this.address());
        }

        @NativeType(value="unsigned int")
        public int BindFlags() {
            return OVRTextureSwapChainDesc.nBindFlags(this.address());
        }

        public Buffer Type(@NativeType(value="ovrTextureType") int value) {
            OVRTextureSwapChainDesc.nType(this.address(), value);
            return this;
        }

        public Buffer Format(@NativeType(value="ovrTextureFormat") int value) {
            OVRTextureSwapChainDesc.nFormat(this.address(), value);
            return this;
        }

        public Buffer ArraySize(int value) {
            OVRTextureSwapChainDesc.nArraySize(this.address(), value);
            return this;
        }

        public Buffer Width(int value) {
            OVRTextureSwapChainDesc.nWidth(this.address(), value);
            return this;
        }

        public Buffer Height(int value) {
            OVRTextureSwapChainDesc.nHeight(this.address(), value);
            return this;
        }

        public Buffer MipLevels(int value) {
            OVRTextureSwapChainDesc.nMipLevels(this.address(), value);
            return this;
        }

        public Buffer SampleCount(int value) {
            OVRTextureSwapChainDesc.nSampleCount(this.address(), value);
            return this;
        }

        public Buffer StaticImage(@NativeType(value="ovrBool") boolean value) {
            OVRTextureSwapChainDesc.nStaticImage(this.address(), value);
            return this;
        }

        public Buffer MiscFlags(@NativeType(value="unsigned int") int value) {
            OVRTextureSwapChainDesc.nMiscFlags(this.address(), value);
            return this;
        }

        public Buffer BindFlags(@NativeType(value="unsigned int") int value) {
            OVRTextureSwapChainDesc.nBindFlags(this.address(), value);
            return this;
        }
    }
}

