/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrSessionStatus")
public class OVRSessionStatus
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ISVISIBLE;
    public static final int HMDPRESENT;
    public static final int HMDMOUNTED;
    public static final int DISPLAYLOST;
    public static final int SHOULDQUIT;
    public static final int SHOULDRECENTER;
    public static final int HASINPUTFOCUS;
    public static final int OVERLAYPRESENT;
    public static final int DEPTHREQUESTED;

    OVRSessionStatus(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRSessionStatus(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRSessionStatus.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrBool")
    public boolean IsVisible() {
        return OVRSessionStatus.nIsVisible(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean HmdPresent() {
        return OVRSessionStatus.nHmdPresent(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean HmdMounted() {
        return OVRSessionStatus.nHmdMounted(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean DisplayLost() {
        return OVRSessionStatus.nDisplayLost(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean ShouldQuit() {
        return OVRSessionStatus.nShouldQuit(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean ShouldRecenter() {
        return OVRSessionStatus.nShouldRecenter(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean HasInputFocus() {
        return OVRSessionStatus.nHasInputFocus(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean OverlayPresent() {
        return OVRSessionStatus.nOverlayPresent(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean DepthRequested() {
        return OVRSessionStatus.nDepthRequested(this.address());
    }

    public static OVRSessionStatus malloc() {
        return OVRSessionStatus.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static OVRSessionStatus calloc() {
        return OVRSessionStatus.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static OVRSessionStatus create() {
        return new OVRSessionStatus(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRSessionStatus create(long address) {
        return new OVRSessionStatus(address, null);
    }

    @Nullable
    public static OVRSessionStatus createSafe(long address) {
        return address == 0L ? null : OVRSessionStatus.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRSessionStatus.create(OVRSessionStatus.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRSessionStatus.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRSessionStatus.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRSessionStatus.create(address, capacity);
    }

    public static OVRSessionStatus mallocStack() {
        return OVRSessionStatus.mallocStack(MemoryStack.stackGet());
    }

    public static OVRSessionStatus callocStack() {
        return OVRSessionStatus.callocStack(MemoryStack.stackGet());
    }

    public static OVRSessionStatus mallocStack(MemoryStack stack) {
        return OVRSessionStatus.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRSessionStatus callocStack(MemoryStack stack) {
        return OVRSessionStatus.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRSessionStatus.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRSessionStatus.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRSessionStatus.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRSessionStatus.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static boolean nIsVisible(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ISVISIBLE) != 0;
    }

    public static boolean nHmdPresent(long struct) {
        return MemoryUtil.memGetByte(struct + (long)HMDPRESENT) != 0;
    }

    public static boolean nHmdMounted(long struct) {
        return MemoryUtil.memGetByte(struct + (long)HMDMOUNTED) != 0;
    }

    public static boolean nDisplayLost(long struct) {
        return MemoryUtil.memGetByte(struct + (long)DISPLAYLOST) != 0;
    }

    public static boolean nShouldQuit(long struct) {
        return MemoryUtil.memGetByte(struct + (long)SHOULDQUIT) != 0;
    }

    public static boolean nShouldRecenter(long struct) {
        return MemoryUtil.memGetByte(struct + (long)SHOULDRECENTER) != 0;
    }

    public static boolean nHasInputFocus(long struct) {
        return MemoryUtil.memGetByte(struct + (long)HASINPUTFOCUS) != 0;
    }

    public static boolean nOverlayPresent(long struct) {
        return MemoryUtil.memGetByte(struct + (long)OVERLAYPRESENT) != 0;
    }

    public static boolean nDepthRequested(long struct) {
        return MemoryUtil.memGetByte(struct + (long)DEPTHREQUESTED) != 0;
    }

    static {
        Struct.Layout layout = OVRSessionStatus.__struct(OVRSessionStatus.__member(1), OVRSessionStatus.__member(1), OVRSessionStatus.__member(1), OVRSessionStatus.__member(1), OVRSessionStatus.__member(1), OVRSessionStatus.__member(1), OVRSessionStatus.__member(1), OVRSessionStatus.__member(1), OVRSessionStatus.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ISVISIBLE = layout.offsetof(0);
        HMDPRESENT = layout.offsetof(1);
        HMDMOUNTED = layout.offsetof(2);
        DISPLAYLOST = layout.offsetof(3);
        SHOULDQUIT = layout.offsetof(4);
        SHOULDRECENTER = layout.offsetof(5);
        HASINPUTFOCUS = layout.offsetof(6);
        OVERLAYPRESENT = layout.offsetof(7);
        DEPTHREQUESTED = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<OVRSessionStatus, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRSessionStatus newInstance(long address) {
            return new OVRSessionStatus(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrBool")
        public boolean IsVisible() {
            return OVRSessionStatus.nIsVisible(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean HmdPresent() {
            return OVRSessionStatus.nHmdPresent(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean HmdMounted() {
            return OVRSessionStatus.nHmdMounted(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean DisplayLost() {
            return OVRSessionStatus.nDisplayLost(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean ShouldQuit() {
            return OVRSessionStatus.nShouldQuit(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean ShouldRecenter() {
            return OVRSessionStatus.nShouldRecenter(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean HasInputFocus() {
            return OVRSessionStatus.nHasInputFocus(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean OverlayPresent() {
            return OVRSessionStatus.nOverlayPresent(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean DepthRequested() {
            return OVRSessionStatus.nDepthRequested(this.address());
        }
    }
}

