/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrMatrix4f")
public class OVRMatrix4f
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M;

    OVRMatrix4f(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRMatrix4f(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRMatrix4f.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[16]")
    public FloatBuffer M() {
        return OVRMatrix4f.nM(this.address());
    }

    public float M(int index) {
        return OVRMatrix4f.nM(this.address(), index);
    }

    public OVRMatrix4f M(@NativeType(value="float[16]") FloatBuffer value) {
        OVRMatrix4f.nM(this.address(), value);
        return this;
    }

    public OVRMatrix4f M(int index, float value) {
        OVRMatrix4f.nM(this.address(), index, value);
        return this;
    }

    public OVRMatrix4f set(OVRMatrix4f src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRMatrix4f malloc() {
        return OVRMatrix4f.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static OVRMatrix4f calloc() {
        return OVRMatrix4f.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static OVRMatrix4f create() {
        return new OVRMatrix4f(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRMatrix4f create(long address) {
        return new OVRMatrix4f(address, null);
    }

    @Nullable
    public static OVRMatrix4f createSafe(long address) {
        return address == 0L ? null : OVRMatrix4f.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRMatrix4f.create(OVRMatrix4f.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRMatrix4f.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRMatrix4f.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRMatrix4f.create(address, capacity);
    }

    public static OVRMatrix4f mallocStack() {
        return OVRMatrix4f.mallocStack(MemoryStack.stackGet());
    }

    public static OVRMatrix4f callocStack() {
        return OVRMatrix4f.callocStack(MemoryStack.stackGet());
    }

    public static OVRMatrix4f mallocStack(MemoryStack stack) {
        return OVRMatrix4f.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRMatrix4f callocStack(MemoryStack stack) {
        return OVRMatrix4f.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRMatrix4f.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRMatrix4f.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRMatrix4f.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRMatrix4f.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nM(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)M, 16);
    }

    public static float nM(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)M + Checks.check(index, 16) * 4L);
    }

    public static void nM(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 16);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)M, value.remaining() * 4);
    }

    public static void nM(long struct, int index, float value) {
        MemoryUtil.memPutFloat(struct + (long)M + Checks.check(index, 16) * 4L, value);
    }

    static {
        Struct.Layout layout = OVRMatrix4f.__struct(OVRMatrix4f.__array(4, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<OVRMatrix4f, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRMatrix4f newInstance(long address) {
            return new OVRMatrix4f(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="float[16]")
        public FloatBuffer M() {
            return OVRMatrix4f.nM(this.address());
        }

        public float M(int index) {
            return OVRMatrix4f.nM(this.address(), index);
        }

        public Buffer M(@NativeType(value="float[16]") FloatBuffer value) {
            OVRMatrix4f.nM(this.address(), value);
            return this;
        }

        public Buffer M(int index, float value) {
            OVRMatrix4f.nM(this.address(), index, value);
            return this;
        }
    }
}

