/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRRecti;
import org.lwjgl.ovr.OVRVector2f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrLayerQuad")
public class OVRLayerQuad
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADER;
    public static final int COLORTEXTURE;
    public static final int VIEWPORT;
    public static final int QUADPOSECENTER;
    public static final int QUADSIZE;

    OVRLayerQuad(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRLayerQuad(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRLayerQuad.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrLayerHeader")
    public OVRLayerHeader Header() {
        return OVRLayerQuad.nHeader(this.address());
    }

    public OVRLayerQuad Header(Consumer<OVRLayerHeader> consumer) {
        consumer.accept(this.Header());
        return this;
    }

    @NativeType(value="ovrTextureSwapChain")
    public long ColorTexture() {
        return OVRLayerQuad.nColorTexture(this.address());
    }

    @NativeType(value="ovrRecti")
    public OVRRecti Viewport() {
        return OVRLayerQuad.nViewport(this.address());
    }

    public OVRLayerQuad Viewport(Consumer<OVRRecti> consumer) {
        consumer.accept(this.Viewport());
        return this;
    }

    @NativeType(value="ovrPosef")
    public OVRPosef QuadPoseCenter() {
        return OVRLayerQuad.nQuadPoseCenter(this.address());
    }

    public OVRLayerQuad QuadPoseCenter(Consumer<OVRPosef> consumer) {
        consumer.accept(this.QuadPoseCenter());
        return this;
    }

    @NativeType(value="ovrVector2f")
    public OVRVector2f QuadSize() {
        return OVRLayerQuad.nQuadSize(this.address());
    }

    public OVRLayerQuad QuadSize(Consumer<OVRVector2f> consumer) {
        consumer.accept(this.QuadSize());
        return this;
    }

    public OVRLayerQuad Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
        OVRLayerQuad.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerQuad ColorTexture(@NativeType(value="ovrTextureSwapChain") long value) {
        OVRLayerQuad.nColorTexture(this.address(), value);
        return this;
    }

    public OVRLayerQuad Viewport(@NativeType(value="ovrRecti") OVRRecti value) {
        OVRLayerQuad.nViewport(this.address(), value);
        return this;
    }

    public OVRLayerQuad QuadPoseCenter(@NativeType(value="ovrPosef") OVRPosef value) {
        OVRLayerQuad.nQuadPoseCenter(this.address(), value);
        return this;
    }

    public OVRLayerQuad QuadSize(@NativeType(value="ovrVector2f") OVRVector2f value) {
        OVRLayerQuad.nQuadSize(this.address(), value);
        return this;
    }

    public OVRLayerQuad set(OVRLayerHeader Header, long ColorTexture, OVRRecti Viewport, OVRPosef QuadPoseCenter, OVRVector2f QuadSize) {
        this.Header(Header);
        this.ColorTexture(ColorTexture);
        this.Viewport(Viewport);
        this.QuadPoseCenter(QuadPoseCenter);
        this.QuadSize(QuadSize);
        return this;
    }

    public OVRLayerQuad set(OVRLayerQuad src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRLayerQuad malloc() {
        return OVRLayerQuad.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static OVRLayerQuad calloc() {
        return OVRLayerQuad.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static OVRLayerQuad create() {
        return new OVRLayerQuad(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRLayerQuad create(long address) {
        return new OVRLayerQuad(address, null);
    }

    @Nullable
    public static OVRLayerQuad createSafe(long address) {
        return address == 0L ? null : OVRLayerQuad.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRLayerQuad.create(OVRLayerQuad.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRLayerQuad.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRLayerQuad.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRLayerQuad.create(address, capacity);
    }

    public static OVRLayerQuad mallocStack() {
        return OVRLayerQuad.mallocStack(MemoryStack.stackGet());
    }

    public static OVRLayerQuad callocStack() {
        return OVRLayerQuad.callocStack(MemoryStack.stackGet());
    }

    public static OVRLayerQuad mallocStack(MemoryStack stack) {
        return OVRLayerQuad.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRLayerQuad callocStack(MemoryStack stack) {
        return OVRLayerQuad.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRLayerQuad.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRLayerQuad.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRLayerQuad.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRLayerQuad.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return OVRLayerHeader.create(struct + (long)HEADER);
    }

    public static long nColorTexture(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)COLORTEXTURE);
    }

    public static OVRRecti nViewport(long struct) {
        return OVRRecti.create(struct + (long)VIEWPORT);
    }

    public static OVRPosef nQuadPoseCenter(long struct) {
        return OVRPosef.create(struct + (long)QUADPOSECENTER);
    }

    public static OVRVector2f nQuadSize(long struct) {
        return OVRVector2f.create(struct + (long)QUADSIZE);
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HEADER, OVRLayerHeader.SIZEOF);
    }

    public static void nColorTexture(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)COLORTEXTURE, Checks.check(value));
    }

    public static void nViewport(long struct, OVRRecti value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VIEWPORT, OVRRecti.SIZEOF);
    }

    public static void nQuadPoseCenter(long struct, OVRPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)QUADPOSECENTER, OVRPosef.SIZEOF);
    }

    public static void nQuadSize(long struct, OVRVector2f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)QUADSIZE, OVRVector2f.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)COLORTEXTURE));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            OVRLayerQuad.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = OVRLayerQuad.__struct(OVRLayerQuad.__member(OVRLayerHeader.SIZEOF, OVRLayerHeader.ALIGNOF), OVRLayerQuad.__member(POINTER_SIZE), OVRLayerQuad.__member(OVRRecti.SIZEOF, OVRRecti.ALIGNOF), OVRLayerQuad.__member(OVRPosef.SIZEOF, OVRPosef.ALIGNOF), OVRLayerQuad.__member(OVRVector2f.SIZEOF, OVRVector2f.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADER = layout.offsetof(0);
        COLORTEXTURE = layout.offsetof(1);
        VIEWPORT = layout.offsetof(2);
        QUADPOSECENTER = layout.offsetof(3);
        QUADSIZE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<OVRLayerQuad, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRLayerQuad newInstance(long address) {
            return new OVRLayerQuad(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrLayerHeader")
        public OVRLayerHeader Header() {
            return OVRLayerQuad.nHeader(this.address());
        }

        public Buffer Header(Consumer<OVRLayerHeader> consumer) {
            consumer.accept(this.Header());
            return this;
        }

        @NativeType(value="ovrTextureSwapChain")
        public long ColorTexture() {
            return OVRLayerQuad.nColorTexture(this.address());
        }

        @NativeType(value="ovrRecti")
        public OVRRecti Viewport() {
            return OVRLayerQuad.nViewport(this.address());
        }

        public Buffer Viewport(Consumer<OVRRecti> consumer) {
            consumer.accept(this.Viewport());
            return this;
        }

        @NativeType(value="ovrPosef")
        public OVRPosef QuadPoseCenter() {
            return OVRLayerQuad.nQuadPoseCenter(this.address());
        }

        public Buffer QuadPoseCenter(Consumer<OVRPosef> consumer) {
            consumer.accept(this.QuadPoseCenter());
            return this;
        }

        @NativeType(value="ovrVector2f")
        public OVRVector2f QuadSize() {
            return OVRLayerQuad.nQuadSize(this.address());
        }

        public Buffer QuadSize(Consumer<OVRVector2f> consumer) {
            consumer.accept(this.QuadSize());
            return this;
        }

        public Buffer Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
            OVRLayerQuad.nHeader(this.address(), value);
            return this;
        }

        public Buffer ColorTexture(@NativeType(value="ovrTextureSwapChain") long value) {
            OVRLayerQuad.nColorTexture(this.address(), value);
            return this;
        }

        public Buffer Viewport(@NativeType(value="ovrRecti") OVRRecti value) {
            OVRLayerQuad.nViewport(this.address(), value);
            return this;
        }

        public Buffer QuadPoseCenter(@NativeType(value="ovrPosef") OVRPosef value) {
            OVRLayerQuad.nQuadPoseCenter(this.address(), value);
            return this;
        }

        public Buffer QuadSize(@NativeType(value="ovrVector2f") OVRVector2f value) {
            OVRLayerQuad.nQuadSize(this.address(), value);
            return this;
        }
    }
}

