/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRQuatf;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrLayerCube")
public class OVRLayerCube
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADER;
    public static final int ORIENTATION;
    public static final int CUBEMAPTEXTURE;

    OVRLayerCube(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRLayerCube(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRLayerCube.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrLayerHeader")
    public OVRLayerHeader Header() {
        return OVRLayerCube.nHeader(this.address());
    }

    public OVRLayerCube Header(Consumer<OVRLayerHeader> consumer) {
        consumer.accept(this.Header());
        return this;
    }

    @NativeType(value="ovrQuatf")
    public OVRQuatf Orientation() {
        return OVRLayerCube.nOrientation(this.address());
    }

    public OVRLayerCube Orientation(Consumer<OVRQuatf> consumer) {
        consumer.accept(this.Orientation());
        return this;
    }

    @NativeType(value="ovrTextureSwapChain")
    public long CubeMapTexture() {
        return OVRLayerCube.nCubeMapTexture(this.address());
    }

    public OVRLayerCube Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
        OVRLayerCube.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerCube Orientation(@NativeType(value="ovrQuatf") OVRQuatf value) {
        OVRLayerCube.nOrientation(this.address(), value);
        return this;
    }

    public OVRLayerCube CubeMapTexture(@NativeType(value="ovrTextureSwapChain") long value) {
        OVRLayerCube.nCubeMapTexture(this.address(), value);
        return this;
    }

    public OVRLayerCube set(OVRLayerHeader Header, OVRQuatf Orientation, long CubeMapTexture) {
        this.Header(Header);
        this.Orientation(Orientation);
        this.CubeMapTexture(CubeMapTexture);
        return this;
    }

    public OVRLayerCube set(OVRLayerCube src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRLayerCube malloc() {
        return OVRLayerCube.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static OVRLayerCube calloc() {
        return OVRLayerCube.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static OVRLayerCube create() {
        return new OVRLayerCube(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRLayerCube create(long address) {
        return new OVRLayerCube(address, null);
    }

    @Nullable
    public static OVRLayerCube createSafe(long address) {
        return address == 0L ? null : OVRLayerCube.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRLayerCube.create(OVRLayerCube.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRLayerCube.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRLayerCube.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRLayerCube.create(address, capacity);
    }

    public static OVRLayerCube mallocStack() {
        return OVRLayerCube.mallocStack(MemoryStack.stackGet());
    }

    public static OVRLayerCube callocStack() {
        return OVRLayerCube.callocStack(MemoryStack.stackGet());
    }

    public static OVRLayerCube mallocStack(MemoryStack stack) {
        return OVRLayerCube.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRLayerCube callocStack(MemoryStack stack) {
        return OVRLayerCube.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRLayerCube.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRLayerCube.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRLayerCube.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRLayerCube.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return OVRLayerHeader.create(struct + (long)HEADER);
    }

    public static OVRQuatf nOrientation(long struct) {
        return OVRQuatf.create(struct + (long)ORIENTATION);
    }

    public static long nCubeMapTexture(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CUBEMAPTEXTURE);
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HEADER, OVRLayerHeader.SIZEOF);
    }

    public static void nOrientation(long struct, OVRQuatf value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ORIENTATION, OVRQuatf.SIZEOF);
    }

    public static void nCubeMapTexture(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)CUBEMAPTEXTURE, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CUBEMAPTEXTURE));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            OVRLayerCube.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = OVRLayerCube.__struct(OVRLayerCube.__member(OVRLayerHeader.SIZEOF, OVRLayerHeader.ALIGNOF), OVRLayerCube.__member(OVRQuatf.SIZEOF, OVRQuatf.ALIGNOF), OVRLayerCube.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADER = layout.offsetof(0);
        ORIENTATION = layout.offsetof(1);
        CUBEMAPTEXTURE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OVRLayerCube, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRLayerCube newInstance(long address) {
            return new OVRLayerCube(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrLayerHeader")
        public OVRLayerHeader Header() {
            return OVRLayerCube.nHeader(this.address());
        }

        public Buffer Header(Consumer<OVRLayerHeader> consumer) {
            consumer.accept(this.Header());
            return this;
        }

        @NativeType(value="ovrQuatf")
        public OVRQuatf Orientation() {
            return OVRLayerCube.nOrientation(this.address());
        }

        public Buffer Orientation(Consumer<OVRQuatf> consumer) {
            consumer.accept(this.Orientation());
            return this;
        }

        @NativeType(value="ovrTextureSwapChain")
        public long CubeMapTexture() {
            return OVRLayerCube.nCubeMapTexture(this.address());
        }

        public Buffer Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
            OVRLayerCube.nHeader(this.address(), value);
            return this;
        }

        public Buffer Orientation(@NativeType(value="ovrQuatf") OVRQuatf value) {
            OVRLayerCube.nOrientation(this.address(), value);
            return this;
        }

        public Buffer CubeMapTexture(@NativeType(value="ovrTextureSwapChain") long value) {
            OVRLayerCube.nCubeMapTexture(this.address(), value);
            return this;
        }
    }
}

