/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRCameraExtrinsics;
import org.lwjgl.ovr.OVRCameraIntrinsics;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrExternalCamera")
public class OVRExternalCamera
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int INTRINSICS;
    public static final int EXTRINSICS;

    OVRExternalCamera(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRExternalCamera(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRExternalCamera.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[32]")
    public ByteBuffer Name() {
        return OVRExternalCamera.nName(this.address());
    }

    @NativeType(value="char[32]")
    public String NameString() {
        return OVRExternalCamera.nNameString(this.address());
    }

    @NativeType(value="ovrCameraIntrinsics")
    public OVRCameraIntrinsics Intrinsics() {
        return OVRExternalCamera.nIntrinsics(this.address());
    }

    public OVRExternalCamera Intrinsics(Consumer<OVRCameraIntrinsics> consumer) {
        consumer.accept(this.Intrinsics());
        return this;
    }

    @NativeType(value="ovrCameraExtrinsics")
    public OVRCameraExtrinsics Extrinsics() {
        return OVRExternalCamera.nExtrinsics(this.address());
    }

    public OVRExternalCamera Extrinsics(Consumer<OVRCameraExtrinsics> consumer) {
        consumer.accept(this.Extrinsics());
        return this;
    }

    public static OVRExternalCamera malloc() {
        return OVRExternalCamera.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static OVRExternalCamera calloc() {
        return OVRExternalCamera.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static OVRExternalCamera create() {
        return new OVRExternalCamera(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRExternalCamera create(long address) {
        return new OVRExternalCamera(address, null);
    }

    @Nullable
    public static OVRExternalCamera createSafe(long address) {
        return address == 0L ? null : OVRExternalCamera.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRExternalCamera.create(OVRExternalCamera.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRExternalCamera.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRExternalCamera.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRExternalCamera.create(address, capacity);
    }

    public static OVRExternalCamera mallocStack() {
        return OVRExternalCamera.mallocStack(MemoryStack.stackGet());
    }

    public static OVRExternalCamera callocStack() {
        return OVRExternalCamera.callocStack(MemoryStack.stackGet());
    }

    public static OVRExternalCamera mallocStack(MemoryStack stack) {
        return OVRExternalCamera.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRExternalCamera callocStack(MemoryStack stack) {
        return OVRExternalCamera.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRExternalCamera.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRExternalCamera.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRExternalCamera.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRExternalCamera.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)NAME, 32);
    }

    public static String nNameString(long struct) {
        return MemoryUtil.memASCII(struct + (long)NAME);
    }

    public static OVRCameraIntrinsics nIntrinsics(long struct) {
        return OVRCameraIntrinsics.create(struct + (long)INTRINSICS);
    }

    public static OVRCameraExtrinsics nExtrinsics(long struct) {
        return OVRCameraExtrinsics.create(struct + (long)EXTRINSICS);
    }

    static {
        Struct.Layout layout = OVRExternalCamera.__struct(OVRExternalCamera.__array(1, 32), OVRExternalCamera.__member(OVRCameraIntrinsics.SIZEOF, OVRCameraIntrinsics.ALIGNOF), OVRExternalCamera.__member(OVRCameraExtrinsics.SIZEOF, OVRCameraExtrinsics.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        INTRINSICS = layout.offsetof(1);
        EXTRINSICS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OVRExternalCamera, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRExternalCamera newInstance(long address) {
            return new OVRExternalCamera(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="char[32]")
        public ByteBuffer Name() {
            return OVRExternalCamera.nName(this.address());
        }

        @NativeType(value="char[32]")
        public String NameString() {
            return OVRExternalCamera.nNameString(this.address());
        }

        @NativeType(value="ovrCameraIntrinsics")
        public OVRCameraIntrinsics Intrinsics() {
            return OVRExternalCamera.nIntrinsics(this.address());
        }

        public Buffer Intrinsics(Consumer<OVRCameraIntrinsics> consumer) {
            consumer.accept(this.Intrinsics());
            return this;
        }

        @NativeType(value="ovrCameraExtrinsics")
        public OVRCameraExtrinsics Extrinsics() {
            return OVRExternalCamera.nExtrinsics(this.address());
        }

        public Buffer Extrinsics(Consumer<OVRCameraExtrinsics> consumer) {
            consumer.accept(this.Extrinsics());
            return this;
        }
    }
}

