/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.VRTextureDepthInfo;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VRTextureWithPoseAndDepth_t")
public class VRTextureWithPoseAndDepth
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DEPTH;

    VRTextureWithPoseAndDepth(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VRTextureWithPoseAndDepth(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VRTextureWithPoseAndDepth.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VRTextureDepthInfo_t")
    public VRTextureDepthInfo depth() {
        return VRTextureWithPoseAndDepth.ndepth(this.address());
    }

    public VRTextureWithPoseAndDepth depth(Consumer<VRTextureDepthInfo> consumer) {
        consumer.accept(this.depth());
        return this;
    }

    public VRTextureWithPoseAndDepth depth(@NativeType(value="VRTextureDepthInfo_t") VRTextureDepthInfo value) {
        VRTextureWithPoseAndDepth.ndepth(this.address(), value);
        return this;
    }

    public VRTextureWithPoseAndDepth set(VRTextureWithPoseAndDepth src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VRTextureWithPoseAndDepth malloc() {
        return VRTextureWithPoseAndDepth.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VRTextureWithPoseAndDepth calloc() {
        return VRTextureWithPoseAndDepth.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VRTextureWithPoseAndDepth create() {
        return new VRTextureWithPoseAndDepth(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VRTextureWithPoseAndDepth create(long address) {
        return new VRTextureWithPoseAndDepth(address, null);
    }

    @Nullable
    public static VRTextureWithPoseAndDepth createSafe(long address) {
        return address == 0L ? null : VRTextureWithPoseAndDepth.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VRTextureWithPoseAndDepth.create(VRTextureWithPoseAndDepth.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VRTextureWithPoseAndDepth.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VRTextureWithPoseAndDepth.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VRTextureWithPoseAndDepth.create(address, capacity);
    }

    public static VRTextureWithPoseAndDepth mallocStack() {
        return VRTextureWithPoseAndDepth.mallocStack(MemoryStack.stackGet());
    }

    public static VRTextureWithPoseAndDepth callocStack() {
        return VRTextureWithPoseAndDepth.callocStack(MemoryStack.stackGet());
    }

    public static VRTextureWithPoseAndDepth mallocStack(MemoryStack stack) {
        return VRTextureWithPoseAndDepth.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VRTextureWithPoseAndDepth callocStack(MemoryStack stack) {
        return VRTextureWithPoseAndDepth.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VRTextureWithPoseAndDepth.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VRTextureWithPoseAndDepth.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VRTextureWithPoseAndDepth.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VRTextureWithPoseAndDepth.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VRTextureDepthInfo ndepth(long struct) {
        return VRTextureDepthInfo.create(struct + (long)DEPTH);
    }

    public static void ndepth(long struct, VRTextureDepthInfo value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DEPTH, VRTextureDepthInfo.SIZEOF);
    }

    public static void validate(long struct) {
        VRTextureDepthInfo.validate(struct + (long)DEPTH);
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VRTextureWithPoseAndDepth.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VRTextureWithPoseAndDepth.__struct(VRTextureWithPoseAndDepth.__member(VRTextureDepthInfo.SIZEOF, VRTextureDepthInfo.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DEPTH = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<VRTextureWithPoseAndDepth, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VRTextureWithPoseAndDepth newInstance(long address) {
            return new VRTextureWithPoseAndDepth(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VRTextureDepthInfo_t")
        public VRTextureDepthInfo depth() {
            return VRTextureWithPoseAndDepth.ndepth(this.address());
        }

        public Buffer depth(Consumer<VRTextureDepthInfo> consumer) {
            consumer.accept(this.depth());
            return this;
        }

        public Buffer depth(@NativeType(value="VRTextureDepthInfo_t") VRTextureDepthInfo value) {
            VRTextureWithPoseAndDepth.ndepth(this.address(), value);
            return this;
        }
    }
}

