/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.openvr.InputAnalogActionData;
import org.lwjgl.openvr.InputDigitalActionData;
import org.lwjgl.openvr.InputOriginInfo;
import org.lwjgl.openvr.InputPoseActionData;
import org.lwjgl.openvr.InputSkeletalActionData;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.openvr.VRActiveActionSet;
import org.lwjgl.openvr.VRBoneTransform;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class VRInput {
    protected VRInput() {
        throw new UnsupportedOperationException();
    }

    public static int nVRInput_SetActionManifestPath(long pchActionManifestPath) {
        long __functionAddress = OpenVR.VRInput.SetActionManifestPath;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, pchActionManifestPath);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_SetActionManifestPath(@NativeType(value="char const *") ByteBuffer pchActionManifestPath) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchActionManifestPath);
        }
        return VRInput.nVRInput_SetActionManifestPath(MemoryUtil.memAddress(pchActionManifestPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRInputError")
    public static int VRInput_SetActionManifestPath(@NativeType(value="char const *") CharSequence pchActionManifestPath) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchActionManifestPathEncoded = stack.ASCII(pchActionManifestPath);
            int n = VRInput.nVRInput_SetActionManifestPath(MemoryUtil.memAddress(pchActionManifestPathEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRInput_GetActionSetHandle(long pchActionSetName, long pHandle) {
        long __functionAddress = OpenVR.VRInput.GetActionSetHandle;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, pchActionSetName, pHandle);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetActionSetHandle(@NativeType(value="char const *") ByteBuffer pchActionSetName, @NativeType(value="VRActionSetHandle_t *") LongBuffer pHandle) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchActionSetName);
            Checks.check((Buffer)pHandle, 1);
        }
        return VRInput.nVRInput_GetActionSetHandle(MemoryUtil.memAddress(pchActionSetName), MemoryUtil.memAddress(pHandle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRInputError")
    public static int VRInput_GetActionSetHandle(@NativeType(value="char const *") CharSequence pchActionSetName, @NativeType(value="VRActionSetHandle_t *") LongBuffer pHandle) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pHandle, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchActionSetNameEncoded = stack.ASCII(pchActionSetName);
            int n = VRInput.nVRInput_GetActionSetHandle(MemoryUtil.memAddress(pchActionSetNameEncoded), MemoryUtil.memAddress(pHandle));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRInput_GetActionHandle(long pchActionName, long pHandle) {
        long __functionAddress = OpenVR.VRInput.GetActionHandle;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, pchActionName, pHandle);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetActionHandle(@NativeType(value="char const *") ByteBuffer pchActionName, @NativeType(value="VRActionHandle_t *") LongBuffer pHandle) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchActionName);
            Checks.check((Buffer)pHandle, 1);
        }
        return VRInput.nVRInput_GetActionHandle(MemoryUtil.memAddress(pchActionName), MemoryUtil.memAddress(pHandle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRInputError")
    public static int VRInput_GetActionHandle(@NativeType(value="char const *") CharSequence pchActionName, @NativeType(value="VRActionHandle_t *") LongBuffer pHandle) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pHandle, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchActionNameEncoded = stack.ASCII(pchActionName);
            int n = VRInput.nVRInput_GetActionHandle(MemoryUtil.memAddress(pchActionNameEncoded), MemoryUtil.memAddress(pHandle));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRInput_GetInputSourceHandle(long pchInputSourcePath, long pHandle) {
        long __functionAddress = OpenVR.VRInput.GetInputSourceHandle;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, pchInputSourcePath, pHandle);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetInputSourceHandle(@NativeType(value="char const *") ByteBuffer pchInputSourcePath, @NativeType(value="VRInputValueHandle_t *") LongBuffer pHandle) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchInputSourcePath);
            Checks.check((Buffer)pHandle, 1);
        }
        return VRInput.nVRInput_GetInputSourceHandle(MemoryUtil.memAddress(pchInputSourcePath), MemoryUtil.memAddress(pHandle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRInputError")
    public static int VRInput_GetInputSourceHandle(@NativeType(value="char const *") CharSequence pchInputSourcePath, @NativeType(value="VRInputValueHandle_t *") LongBuffer pHandle) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pHandle, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchInputSourcePathEncoded = stack.ASCII(pchInputSourcePath);
            int n = VRInput.nVRInput_GetInputSourceHandle(MemoryUtil.memAddress(pchInputSourcePathEncoded), MemoryUtil.memAddress(pHandle));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRInput_UpdateActionState(long pSets, int unSizeOfVRSelectedActionSet_t, int unSetCount) {
        long __functionAddress = OpenVR.VRInput.UpdateActionState;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, pSets, unSizeOfVRSelectedActionSet_t, unSetCount);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_UpdateActionState(@NativeType(value="VRActiveActionSet_t *") VRActiveActionSet.Buffer pSets, @NativeType(value="uint32_t") int unSizeOfVRSelectedActionSet_t) {
        return VRInput.nVRInput_UpdateActionState(pSets.address(), unSizeOfVRSelectedActionSet_t, pSets.remaining());
    }

    public static int nVRInput_GetDigitalActionData(long action, long pActionData, int unActionDataSize, long ulRestrictToDevice) {
        long __functionAddress = OpenVR.VRInput.GetDigitalActionData;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPJI(__functionAddress, action, pActionData, unActionDataSize, ulRestrictToDevice);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetDigitalActionData(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="InputDigitalActionData_t *") InputDigitalActionData.Buffer pActionData, @NativeType(value="VRInputValueHandle_t") long ulRestrictToDevice) {
        return VRInput.nVRInput_GetDigitalActionData(action, pActionData.address(), pActionData.remaining(), ulRestrictToDevice);
    }

    public static int nVRInput_GetAnalogActionData(long action, long pActionData, int unActionDataSize, long ulRestrictToDevice) {
        long __functionAddress = OpenVR.VRInput.GetAnalogActionData;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPJI(__functionAddress, action, pActionData, unActionDataSize, ulRestrictToDevice);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetAnalogActionData(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="InputAnalogActionData_t *") InputAnalogActionData.Buffer pActionData, @NativeType(value="VRInputValueHandle_t") long ulRestrictToDevice) {
        return VRInput.nVRInput_GetAnalogActionData(action, pActionData.address(), pActionData.remaining(), ulRestrictToDevice);
    }

    public static int nVRInput_GetPoseActionData(long action, int eOrigin, float fPredictedSecondsFromNow, long pActionData, int unActionDataSize, long ulRestrictToDevice) {
        long __functionAddress = OpenVR.VRInput.GetPoseActionData;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPJI(__functionAddress, action, eOrigin, fPredictedSecondsFromNow, pActionData, unActionDataSize, ulRestrictToDevice);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetPoseActionData(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="ETrackingUniverseOrigin") int eOrigin, float fPredictedSecondsFromNow, @NativeType(value="InputPoseActionData_t *") InputPoseActionData.Buffer pActionData, @NativeType(value="VRInputValueHandle_t") long ulRestrictToDevice) {
        return VRInput.nVRInput_GetPoseActionData(action, eOrigin, fPredictedSecondsFromNow, pActionData.address(), pActionData.remaining(), ulRestrictToDevice);
    }

    public static int nVRInput_GetSkeletalActionData(long action, long pActionData, int unActionDataSize, long ulRestrictToDevice) {
        long __functionAddress = OpenVR.VRInput.GetSkeletalActionData;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPJI(__functionAddress, action, pActionData, unActionDataSize, ulRestrictToDevice);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetSkeletalActionData(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="InputSkeletalActionData_t *") InputSkeletalActionData.Buffer pActionData, @NativeType(value="VRInputValueHandle_t") long ulRestrictToDevice) {
        return VRInput.nVRInput_GetSkeletalActionData(action, pActionData.address(), pActionData.remaining(), ulRestrictToDevice);
    }

    public static int nVRInput_GetSkeletalBoneData(long action, int eTransformSpace, int eMotionRange, long pTransformArray, int unTransformArrayCount, long ulRestrictToDevice) {
        long __functionAddress = OpenVR.VRInput.GetSkeletalBoneData;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPJI(__functionAddress, action, eTransformSpace, eMotionRange, pTransformArray, unTransformArrayCount, ulRestrictToDevice);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetSkeletalBoneData(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="EVRSkeletalTransformSpace") int eTransformSpace, @NativeType(value="EVRSkeletalMotionRange") int eMotionRange, @NativeType(value="VRBoneTransform_t *") VRBoneTransform.Buffer pTransformArray, @NativeType(value="VRInputValueHandle_t") long ulRestrictToDevice) {
        return VRInput.nVRInput_GetSkeletalBoneData(action, eTransformSpace, eMotionRange, pTransformArray.address(), pTransformArray.remaining(), ulRestrictToDevice);
    }

    public static int nVRInput_GetSkeletalBoneDataCompressed(long action, int eTransformSpace, int eMotionRange, long pvCompressedData, int unCompressedSize, long punRequiredCompressedSize, long ulRestrictToDevice) {
        long __functionAddress = OpenVR.VRInput.GetSkeletalBoneDataCompressed;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPJI(__functionAddress, action, eTransformSpace, eMotionRange, pvCompressedData, unCompressedSize, punRequiredCompressedSize, ulRestrictToDevice);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetSkeletalBoneDataCompressed(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="EVRSkeletalTransformSpace") int eTransformSpace, @NativeType(value="EVRSkeletalMotionRange") int eMotionRange, @Nullable @NativeType(value="void *") ByteBuffer pvCompressedData, @Nullable @NativeType(value="uint32_t *") IntBuffer punRequiredCompressedSize, @NativeType(value="VRInputValueHandle_t") long ulRestrictToDevice) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)punRequiredCompressedSize, 1);
        }
        return VRInput.nVRInput_GetSkeletalBoneDataCompressed(action, eTransformSpace, eMotionRange, MemoryUtil.memAddressSafe(pvCompressedData), Checks.remainingSafe(pvCompressedData), MemoryUtil.memAddressSafe(punRequiredCompressedSize), ulRestrictToDevice);
    }

    public static int nVRInput_UncompressSkeletalActionData(long pvCompressedBuffer, int unCompressedBufferSize, long peTransformSpace, long pTransformArray, int unTransformArrayCount) {
        long __functionAddress = OpenVR.VRInput.UncompressSkeletalActionData;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, pvCompressedBuffer, unCompressedBufferSize, peTransformSpace, pTransformArray, unTransformArrayCount);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_UncompressSkeletalActionData(@NativeType(value="void *") ByteBuffer pvCompressedBuffer, @NativeType(value="EVRSkeletalTransformSpace *") IntBuffer peTransformSpace, @NativeType(value="VRBoneTransform_t *") VRBoneTransform.Buffer pTransformArray) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peTransformSpace, 1);
        }
        return VRInput.nVRInput_UncompressSkeletalActionData(MemoryUtil.memAddress(pvCompressedBuffer), pvCompressedBuffer.remaining(), MemoryUtil.memAddress(peTransformSpace), pTransformArray.address(), pTransformArray.remaining());
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_TriggerHapticVibrationAction(@NativeType(value="VRActionHandle_t") long action, float fStartSecondsFromNow, float fDurationSeconds, float fFrequency, float fAmplitude, @NativeType(value="VRInputValueHandle_t") long ulRestrictToDevice) {
        long __functionAddress = OpenVR.VRInput.TriggerHapticVibrationAction;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJJI(__functionAddress, action, fStartSecondsFromNow, fDurationSeconds, fFrequency, fAmplitude, ulRestrictToDevice);
    }

    public static int nVRInput_GetActionOrigins(long actionSetHandle, long digitalActionHandle, long originsOut, int originOutCount) {
        long __functionAddress = OpenVR.VRInput.GetActionOrigins;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJJPI(__functionAddress, actionSetHandle, digitalActionHandle, originsOut, originOutCount);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetActionOrigins(@NativeType(value="VRActionSetHandle_t") long actionSetHandle, @NativeType(value="VRActionHandle_t") long digitalActionHandle, @NativeType(value="VRInputValueHandle_t *") LongBuffer originsOut) {
        return VRInput.nVRInput_GetActionOrigins(actionSetHandle, digitalActionHandle, MemoryUtil.memAddress(originsOut), originsOut.remaining());
    }

    public static int nVRInput_GetOriginLocalizedName(long origin, long pchNameArray, int unNameArraySize) {
        long __functionAddress = OpenVR.VRInput.GetOriginLocalizedName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, origin, pchNameArray, unNameArraySize);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetOriginLocalizedName(@NativeType(value="VRInputValueHandle_t") long origin, @NativeType(value="char *") ByteBuffer pchNameArray) {
        return VRInput.nVRInput_GetOriginLocalizedName(origin, MemoryUtil.memAddress(pchNameArray), pchNameArray.remaining());
    }

    public static int nVRInput_GetOriginTrackedDeviceInfo(long origin, long pOriginInfo, int unOriginInfoSize) {
        long __functionAddress = OpenVR.VRInput.GetOriginTrackedDeviceInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, origin, pOriginInfo, unOriginInfoSize);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetOriginTrackedDeviceInfo(@NativeType(value="VRInputValueHandle_t") long origin, @NativeType(value="InputOriginInfo_t *") InputOriginInfo.Buffer pOriginInfo) {
        return VRInput.nVRInput_GetOriginTrackedDeviceInfo(origin, pOriginInfo.address(), pOriginInfo.remaining());
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_ShowActionOrigins(@NativeType(value="VRActionSetHandle_t") long actionSetHandle, @NativeType(value="VRActionHandle_t") long ulActionHandle) {
        long __functionAddress = OpenVR.VRInput.ShowActionOrigins;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJJI(__functionAddress, actionSetHandle, ulActionHandle);
    }

    public static int nVRInput_ShowBindingsForActionSet(long pSets, int unSizeOfVRSelectedActionSet_t, int unSetCount, long originToHighlight) {
        long __functionAddress = OpenVR.VRInput.ShowBindingsForActionSet;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJI(__functionAddress, pSets, unSizeOfVRSelectedActionSet_t, unSetCount, originToHighlight);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_ShowBindingsForActionSet(@NativeType(value="VRActiveActionSet_t *") VRActiveActionSet.Buffer pSets, @NativeType(value="uint32_t") int unSizeOfVRSelectedActionSet_t, @NativeType(value="VRInputValueHandle_t") long originToHighlight) {
        return VRInput.nVRInput_ShowBindingsForActionSet(pSets.address(), unSizeOfVRSelectedActionSet_t, pSets.remaining(), originToHighlight);
    }
}

