/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VRControllerAxis_t")
public class VRControllerAxis
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    VRControllerAxis(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VRControllerAxis(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VRControllerAxis.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return VRControllerAxis.nx(this.address());
    }

    public float y() {
        return VRControllerAxis.ny(this.address());
    }

    public VRControllerAxis x(float value) {
        VRControllerAxis.nx(this.address(), value);
        return this;
    }

    public VRControllerAxis y(float value) {
        VRControllerAxis.ny(this.address(), value);
        return this;
    }

    public VRControllerAxis set(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public VRControllerAxis set(VRControllerAxis src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VRControllerAxis malloc() {
        return VRControllerAxis.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VRControllerAxis calloc() {
        return VRControllerAxis.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VRControllerAxis create() {
        return new VRControllerAxis(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VRControllerAxis create(long address) {
        return new VRControllerAxis(address, null);
    }

    @Nullable
    public static VRControllerAxis createSafe(long address) {
        return address == 0L ? null : VRControllerAxis.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VRControllerAxis.create(VRControllerAxis.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VRControllerAxis.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VRControllerAxis.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VRControllerAxis.create(address, capacity);
    }

    public static VRControllerAxis mallocStack() {
        return VRControllerAxis.mallocStack(MemoryStack.stackGet());
    }

    public static VRControllerAxis callocStack() {
        return VRControllerAxis.callocStack(MemoryStack.stackGet());
    }

    public static VRControllerAxis mallocStack(MemoryStack stack) {
        return VRControllerAxis.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VRControllerAxis callocStack(MemoryStack stack) {
        return VRControllerAxis.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VRControllerAxis.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VRControllerAxis.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VRControllerAxis.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VRControllerAxis.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = VRControllerAxis.__struct(VRControllerAxis.__member(4), VRControllerAxis.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VRControllerAxis, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VRControllerAxis newInstance(long address) {
            return new VRControllerAxis(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float x() {
            return VRControllerAxis.nx(this.address());
        }

        public float y() {
            return VRControllerAxis.ny(this.address());
        }

        public Buffer x(float value) {
            VRControllerAxis.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            VRControllerAxis.ny(this.address(), value);
            return this;
        }
    }
}

