/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct InputSkeletalActionData_t")
public class InputSkeletalActionData
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BACTIVE;
    public static final int ACTIVEORIGIN;
    public static final int BONECOUNT;

    InputSkeletalActionData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public InputSkeletalActionData(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), InputSkeletalActionData.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bool")
    public boolean bActive() {
        return InputSkeletalActionData.nbActive(this.address());
    }

    @NativeType(value="VRInputValueHandle_t")
    public long activeOrigin() {
        return InputSkeletalActionData.nactiveOrigin(this.address());
    }

    @NativeType(value="uint32_t")
    public int boneCount() {
        return InputSkeletalActionData.nboneCount(this.address());
    }

    public static InputSkeletalActionData malloc() {
        return InputSkeletalActionData.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static InputSkeletalActionData calloc() {
        return InputSkeletalActionData.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static InputSkeletalActionData create() {
        return new InputSkeletalActionData(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static InputSkeletalActionData create(long address) {
        return new InputSkeletalActionData(address, null);
    }

    @Nullable
    public static InputSkeletalActionData createSafe(long address) {
        return address == 0L ? null : InputSkeletalActionData.create(address);
    }

    public static Buffer malloc(int capacity) {
        return InputSkeletalActionData.create(InputSkeletalActionData.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return InputSkeletalActionData.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(InputSkeletalActionData.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : InputSkeletalActionData.create(address, capacity);
    }

    public static InputSkeletalActionData mallocStack() {
        return InputSkeletalActionData.mallocStack(MemoryStack.stackGet());
    }

    public static InputSkeletalActionData callocStack() {
        return InputSkeletalActionData.callocStack(MemoryStack.stackGet());
    }

    public static InputSkeletalActionData mallocStack(MemoryStack stack) {
        return InputSkeletalActionData.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static InputSkeletalActionData callocStack(MemoryStack stack) {
        return InputSkeletalActionData.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return InputSkeletalActionData.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return InputSkeletalActionData.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return InputSkeletalActionData.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return InputSkeletalActionData.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static boolean nbActive(long struct) {
        return MemoryUtil.memGetByte(struct + (long)BACTIVE) != 0;
    }

    public static long nactiveOrigin(long struct) {
        return MemoryUtil.memGetLong(struct + (long)ACTIVEORIGIN);
    }

    public static int nboneCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BONECOUNT);
    }

    static {
        Struct.Layout layout = InputSkeletalActionData.__struct(InputSkeletalActionData.__member(1), InputSkeletalActionData.__member(8), InputSkeletalActionData.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BACTIVE = layout.offsetof(0);
        ACTIVEORIGIN = layout.offsetof(1);
        BONECOUNT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<InputSkeletalActionData, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected InputSkeletalActionData newInstance(long address) {
            return new InputSkeletalActionData(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="bool")
        public boolean bActive() {
            return InputSkeletalActionData.nbActive(this.address());
        }

        @NativeType(value="VRInputValueHandle_t")
        public long activeOrigin() {
            return InputSkeletalActionData.nactiveOrigin(this.address());
        }

        @NativeType(value="uint32_t")
        public int boneCount() {
            return InputSkeletalActionData.nboneCount(this.address());
        }
    }
}

