/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct InputDigitalActionData_t")
public class InputDigitalActionData
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BACTIVE;
    public static final int ACTIVEORIGIN;
    public static final int BSTATE;
    public static final int BCHANGED;
    public static final int FUPDATETIME;

    InputDigitalActionData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public InputDigitalActionData(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), InputDigitalActionData.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bool")
    public boolean bActive() {
        return InputDigitalActionData.nbActive(this.address());
    }

    @NativeType(value="VRInputValueHandle_t")
    public long activeOrigin() {
        return InputDigitalActionData.nactiveOrigin(this.address());
    }

    @NativeType(value="bool")
    public boolean bState() {
        return InputDigitalActionData.nbState(this.address());
    }

    @NativeType(value="bool")
    public boolean bChanged() {
        return InputDigitalActionData.nbChanged(this.address());
    }

    public float fUpdateTime() {
        return InputDigitalActionData.nfUpdateTime(this.address());
    }

    public static InputDigitalActionData malloc() {
        return InputDigitalActionData.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static InputDigitalActionData calloc() {
        return InputDigitalActionData.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static InputDigitalActionData create() {
        return new InputDigitalActionData(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static InputDigitalActionData create(long address) {
        return new InputDigitalActionData(address, null);
    }

    @Nullable
    public static InputDigitalActionData createSafe(long address) {
        return address == 0L ? null : InputDigitalActionData.create(address);
    }

    public static Buffer malloc(int capacity) {
        return InputDigitalActionData.create(InputDigitalActionData.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return InputDigitalActionData.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(InputDigitalActionData.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : InputDigitalActionData.create(address, capacity);
    }

    public static InputDigitalActionData mallocStack() {
        return InputDigitalActionData.mallocStack(MemoryStack.stackGet());
    }

    public static InputDigitalActionData callocStack() {
        return InputDigitalActionData.callocStack(MemoryStack.stackGet());
    }

    public static InputDigitalActionData mallocStack(MemoryStack stack) {
        return InputDigitalActionData.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static InputDigitalActionData callocStack(MemoryStack stack) {
        return InputDigitalActionData.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return InputDigitalActionData.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return InputDigitalActionData.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return InputDigitalActionData.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return InputDigitalActionData.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static boolean nbActive(long struct) {
        return MemoryUtil.memGetByte(struct + (long)BACTIVE) != 0;
    }

    public static long nactiveOrigin(long struct) {
        return MemoryUtil.memGetLong(struct + (long)ACTIVEORIGIN);
    }

    public static boolean nbState(long struct) {
        return MemoryUtil.memGetByte(struct + (long)BSTATE) != 0;
    }

    public static boolean nbChanged(long struct) {
        return MemoryUtil.memGetByte(struct + (long)BCHANGED) != 0;
    }

    public static float nfUpdateTime(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FUPDATETIME);
    }

    static {
        Struct.Layout layout = InputDigitalActionData.__struct(InputDigitalActionData.__member(1), InputDigitalActionData.__member(8), InputDigitalActionData.__member(1), InputDigitalActionData.__member(1), InputDigitalActionData.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BACTIVE = layout.offsetof(0);
        ACTIVEORIGIN = layout.offsetof(1);
        BSTATE = layout.offsetof(2);
        BCHANGED = layout.offsetof(3);
        FUPDATETIME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<InputDigitalActionData, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected InputDigitalActionData newInstance(long address) {
            return new InputDigitalActionData(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="bool")
        public boolean bActive() {
            return InputDigitalActionData.nbActive(this.address());
        }

        @NativeType(value="VRInputValueHandle_t")
        public long activeOrigin() {
            return InputDigitalActionData.nactiveOrigin(this.address());
        }

        @NativeType(value="bool")
        public boolean bState() {
            return InputDigitalActionData.nbState(this.address());
        }

        @NativeType(value="bool")
        public boolean bChanged() {
            return InputDigitalActionData.nbChanged(this.address());
        }

        public float fUpdateTime() {
            return InputDigitalActionData.nfUpdateTime(this.address());
        }
    }
}

