/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdMatrix44_t")
public class HmdMatrix44
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M;

    HmdMatrix44(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public HmdMatrix44(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), HmdMatrix44.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[16]")
    public FloatBuffer m() {
        return HmdMatrix44.nm(this.address());
    }

    public float m(int index) {
        return HmdMatrix44.nm(this.address(), index);
    }

    public HmdMatrix44 m(@NativeType(value="float[16]") FloatBuffer value) {
        HmdMatrix44.nm(this.address(), value);
        return this;
    }

    public HmdMatrix44 m(int index, float value) {
        HmdMatrix44.nm(this.address(), index, value);
        return this;
    }

    public HmdMatrix44 set(HmdMatrix44 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HmdMatrix44 malloc() {
        return HmdMatrix44.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static HmdMatrix44 calloc() {
        return HmdMatrix44.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static HmdMatrix44 create() {
        return new HmdMatrix44(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static HmdMatrix44 create(long address) {
        return new HmdMatrix44(address, null);
    }

    @Nullable
    public static HmdMatrix44 createSafe(long address) {
        return address == 0L ? null : HmdMatrix44.create(address);
    }

    public static Buffer malloc(int capacity) {
        return HmdMatrix44.create(HmdMatrix44.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return HmdMatrix44.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(HmdMatrix44.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : HmdMatrix44.create(address, capacity);
    }

    public static HmdMatrix44 mallocStack() {
        return HmdMatrix44.mallocStack(MemoryStack.stackGet());
    }

    public static HmdMatrix44 callocStack() {
        return HmdMatrix44.callocStack(MemoryStack.stackGet());
    }

    public static HmdMatrix44 mallocStack(MemoryStack stack) {
        return HmdMatrix44.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HmdMatrix44 callocStack(MemoryStack stack) {
        return HmdMatrix44.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return HmdMatrix44.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return HmdMatrix44.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdMatrix44.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdMatrix44.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nm(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)M, 16);
    }

    public static float nm(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)M + Checks.check(index, 16) * 4L);
    }

    public static void nm(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 16);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)M, value.remaining() * 4);
    }

    public static void nm(long struct, int index, float value) {
        MemoryUtil.memPutFloat(struct + (long)M + Checks.check(index, 16) * 4L, value);
    }

    static {
        Struct.Layout layout = HmdMatrix44.__struct(HmdMatrix44.__array(4, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<HmdMatrix44, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected HmdMatrix44 newInstance(long address) {
            return new HmdMatrix44(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="float[16]")
        public FloatBuffer m() {
            return HmdMatrix44.nm(this.address());
        }

        public float m(int index) {
            return HmdMatrix44.nm(this.address(), index);
        }

        public Buffer m(@NativeType(value="float[16]") FloatBuffer value) {
            HmdMatrix44.nm(this.address(), value);
            return this;
        }

        public Buffer m(int index, float value) {
            HmdMatrix44.nm(this.address(), index, value);
            return this;
        }
    }
}

