/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdMatrix33_t")
public class HmdMatrix33
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M;

    HmdMatrix33(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public HmdMatrix33(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), HmdMatrix33.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[9]")
    public FloatBuffer m() {
        return HmdMatrix33.nm(this.address());
    }

    public float m(int index) {
        return HmdMatrix33.nm(this.address(), index);
    }

    public HmdMatrix33 m(@NativeType(value="float[9]") FloatBuffer value) {
        HmdMatrix33.nm(this.address(), value);
        return this;
    }

    public HmdMatrix33 m(int index, float value) {
        HmdMatrix33.nm(this.address(), index, value);
        return this;
    }

    public HmdMatrix33 set(HmdMatrix33 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HmdMatrix33 malloc() {
        return HmdMatrix33.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static HmdMatrix33 calloc() {
        return HmdMatrix33.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static HmdMatrix33 create() {
        return new HmdMatrix33(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static HmdMatrix33 create(long address) {
        return new HmdMatrix33(address, null);
    }

    @Nullable
    public static HmdMatrix33 createSafe(long address) {
        return address == 0L ? null : HmdMatrix33.create(address);
    }

    public static Buffer malloc(int capacity) {
        return HmdMatrix33.create(HmdMatrix33.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return HmdMatrix33.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(HmdMatrix33.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : HmdMatrix33.create(address, capacity);
    }

    public static HmdMatrix33 mallocStack() {
        return HmdMatrix33.mallocStack(MemoryStack.stackGet());
    }

    public static HmdMatrix33 callocStack() {
        return HmdMatrix33.callocStack(MemoryStack.stackGet());
    }

    public static HmdMatrix33 mallocStack(MemoryStack stack) {
        return HmdMatrix33.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HmdMatrix33 callocStack(MemoryStack stack) {
        return HmdMatrix33.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return HmdMatrix33.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return HmdMatrix33.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdMatrix33.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdMatrix33.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nm(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)M, 9);
    }

    public static float nm(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)M + Checks.check(index, 9) * 4L);
    }

    public static void nm(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 9);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)M, value.remaining() * 4);
    }

    public static void nm(long struct, int index, float value) {
        MemoryUtil.memPutFloat(struct + (long)M + Checks.check(index, 9) * 4L, value);
    }

    static {
        Struct.Layout layout = HmdMatrix33.__struct(HmdMatrix33.__array(4, 9));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<HmdMatrix33, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected HmdMatrix33 newInstance(long address) {
            return new HmdMatrix33(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="float[9]")
        public FloatBuffer m() {
            return HmdMatrix33.nm(this.address());
        }

        public float m(int index) {
            return HmdMatrix33.nm(this.address(), index);
        }

        public Buffer m(@NativeType(value="float[9]") FloatBuffer value) {
            HmdMatrix33.nm(this.address(), value);
            return this;
        }

        public Buffer m(int index, float value) {
            HmdMatrix33.nm(this.address(), index, value);
            return this;
        }
    }
}

