/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct cl_buffer_region")
public class CLBufferRegion
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ORIGIN;
    public static final int SIZE;

    CLBufferRegion(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public CLBufferRegion(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), CLBufferRegion.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long origin() {
        return CLBufferRegion.norigin(this.address());
    }

    @NativeType(value="size_t")
    public long size() {
        return CLBufferRegion.nsize(this.address());
    }

    public CLBufferRegion origin(@NativeType(value="size_t") long value) {
        CLBufferRegion.norigin(this.address(), value);
        return this;
    }

    public CLBufferRegion size(@NativeType(value="size_t") long value) {
        CLBufferRegion.nsize(this.address(), value);
        return this;
    }

    public CLBufferRegion set(long origin, long size) {
        this.origin(origin);
        this.size(size);
        return this;
    }

    public CLBufferRegion set(CLBufferRegion src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CLBufferRegion malloc() {
        return CLBufferRegion.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CLBufferRegion calloc() {
        return CLBufferRegion.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CLBufferRegion create() {
        return new CLBufferRegion(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static CLBufferRegion create(long address) {
        return new CLBufferRegion(address, null);
    }

    @Nullable
    public static CLBufferRegion createSafe(long address) {
        return address == 0L ? null : CLBufferRegion.create(address);
    }

    public static Buffer malloc(int capacity) {
        return CLBufferRegion.create(CLBufferRegion.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CLBufferRegion.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(CLBufferRegion.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CLBufferRegion.create(address, capacity);
    }

    public static CLBufferRegion mallocStack() {
        return CLBufferRegion.mallocStack(MemoryStack.stackGet());
    }

    public static CLBufferRegion callocStack() {
        return CLBufferRegion.callocStack(MemoryStack.stackGet());
    }

    public static CLBufferRegion mallocStack(MemoryStack stack) {
        return CLBufferRegion.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CLBufferRegion callocStack(MemoryStack stack) {
        return CLBufferRegion.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CLBufferRegion.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CLBufferRegion.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CLBufferRegion.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CLBufferRegion.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long norigin(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ORIGIN);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SIZE);
    }

    public static void norigin(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)ORIGIN, value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = CLBufferRegion.__struct(CLBufferRegion.__member(POINTER_SIZE), CLBufferRegion.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ORIGIN = layout.offsetof(0);
        SIZE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CLBufferRegion, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected CLBufferRegion newInstance(long address) {
            return new CLBufferRegion(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="size_t")
        public long origin() {
            return CLBufferRegion.norigin(this.address());
        }

        @NativeType(value="size_t")
        public long size() {
            return CLBufferRegion.nsize(this.address());
        }

        public Buffer origin(@NativeType(value="size_t") long value) {
            CLBufferRegion.norigin(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="size_t") long value) {
            CLBufferRegion.nsize(this.address(), value);
            return this;
        }
    }
}

