/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class CL10GL {
    public static final int CL_INVALID_GL_OBJECT = -60;
    public static final int CL_INVALID_MIP_LEVEL = -62;
    public static final int CL_GL_OBJECT_BUFFER = 8192;
    public static final int CL_GL_OBJECT_TEXTURE2D = 8193;
    public static final int CL_GL_OBJECT_TEXTURE3D = 8194;
    public static final int CL_GL_OBJECT_RENDERBUFFER = 8195;
    public static final int CL_GL_TEXTURE_TARGET = 8196;
    public static final int CL_GL_MIPMAP_LEVEL = 8197;

    protected CL10GL() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(CLCapabilities caps) {
        return Checks.checkFunctions(caps.clCreateFromGLBuffer, caps.clCreateFromGLTexture2D, caps.clCreateFromGLTexture3D, caps.clCreateFromGLRenderbuffer, caps.clGetGLObjectInfo, caps.clGetGLTextureInfo, caps.clEnqueueAcquireGLObjects, caps.clEnqueueReleaseGLObjects);
    }

    public static long nclCreateFromGLBuffer(long context, long flags, int bufobj, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromGLBuffer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
        }
        return JNI.callPJPP(__functionAddress, context, flags, bufobj, errcode_ret);
    }

    @NativeType(value="cl_mem")
    public static long clCreateFromGLBuffer(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="GLuint") int bufobj, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10GL.nclCreateFromGLBuffer(context, flags, bufobj, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long nclCreateFromGLTexture2D(long context, long flags, int texture_target, int miplevel, int texture, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromGLTexture2D;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
        }
        return JNI.callPJPP(__functionAddress, context, flags, texture_target, miplevel, texture, errcode_ret);
    }

    @NativeType(value="cl_mem")
    public static long clCreateFromGLTexture2D(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="GLenum") int texture_target, @NativeType(value="GLint") int miplevel, @NativeType(value="GLuint") int texture, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10GL.nclCreateFromGLTexture2D(context, flags, texture_target, miplevel, texture, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long nclCreateFromGLTexture3D(long context, long flags, int texture_target, int miplevel, int texture, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromGLTexture3D;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
        }
        return JNI.callPJPP(__functionAddress, context, flags, texture_target, miplevel, texture, errcode_ret);
    }

    @NativeType(value="cl_mem")
    public static long clCreateFromGLTexture3D(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="GLenum") int texture_target, @NativeType(value="GLint") int miplevel, @NativeType(value="GLuint") int texture, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10GL.nclCreateFromGLTexture3D(context, flags, texture_target, miplevel, texture, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long nclCreateFromGLRenderbuffer(long context, long flags, int renderbuffer, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromGLRenderbuffer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
        }
        return JNI.callPJPP(__functionAddress, context, flags, renderbuffer, errcode_ret);
    }

    @NativeType(value="cl_mem")
    public static long clCreateFromGLRenderbuffer(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="GLuint") int renderbuffer, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10GL.nclCreateFromGLRenderbuffer(context, flags, renderbuffer, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static int nclGetGLObjectInfo(long memobj, long gl_object_type, long gl_object_name) {
        long __functionAddress = CL.getICD().clGetGLObjectInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(memobj);
        }
        return JNI.callPPPI(__functionAddress, memobj, gl_object_type, gl_object_name);
    }

    @NativeType(value="cl_int")
    public static int clGetGLObjectInfo(@NativeType(value="cl_mem") long memobj, @Nullable @NativeType(value="cl_gl_object_type *") IntBuffer gl_object_type, @Nullable @NativeType(value="GLuint *") IntBuffer gl_object_name) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)gl_object_type, 1);
            Checks.checkSafe((Buffer)gl_object_name, 1);
        }
        return CL10GL.nclGetGLObjectInfo(memobj, MemoryUtil.memAddressSafe(gl_object_type), MemoryUtil.memAddressSafe(gl_object_name));
    }

    public static int nclGetGLTextureInfo(long memobj, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetGLTextureInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(memobj);
        }
        return JNI.callPPPPI(__functionAddress, memobj, param_name, param_value_size, param_value, param_value_size_ret);
    }

    @NativeType(value="cl_int")
    public static int clGetGLTextureInfo(@NativeType(value="cl_mem") long memobj, @NativeType(value="cl_gl_texture_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10GL.nclGetGLTextureInfo(memobj, param_name, Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetGLTextureInfo(@NativeType(value="cl_mem") long memobj, @NativeType(value="cl_gl_texture_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10GL.nclGetGLTextureInfo(memobj, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int nclEnqueueAcquireGLObjects(long command_queue, int num_objects, long mem_objects, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueAcquireGLObjects;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPPPPI(__functionAddress, command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueAcquireGLObjects(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem const *") PointerBuffer mem_objects, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL10GL.nclEnqueueAcquireGLObjects(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clEnqueueAcquireGLObjects(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem const *") long mem_object, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer mem_objects = stack.pointers(mem_object);
            int n = CL10GL.nclEnqueueAcquireGLObjects(command_queue, 1, MemoryUtil.memAddress(mem_objects), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nclEnqueueReleaseGLObjects(long command_queue, int num_objects, long mem_objects, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueReleaseGLObjects;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPPPPI(__functionAddress, command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReleaseGLObjects(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem const *") PointerBuffer mem_objects, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL10GL.nclEnqueueReleaseGLObjects(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clEnqueueReleaseGLObjects(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem const *") long mem_object, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer mem_objects = stack.pointers(mem_object);
            int n = CL10GL.nclEnqueueReleaseGLObjects(command_queue, 1, MemoryUtil.memAddress(mem_objects), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="cl_mem")
    public static long clCreateFromGLBuffer(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="GLuint") int bufobj, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromGLBuffer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPP(__functionAddress, context, flags, bufobj, errcode_ret);
    }

    @NativeType(value="cl_mem")
    public static long clCreateFromGLTexture2D(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="GLenum") int texture_target, @NativeType(value="GLint") int miplevel, @NativeType(value="GLuint") int texture, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromGLTexture2D;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPP(__functionAddress, context, flags, texture_target, miplevel, texture, errcode_ret);
    }

    @NativeType(value="cl_mem")
    public static long clCreateFromGLTexture3D(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="GLenum") int texture_target, @NativeType(value="GLint") int miplevel, @NativeType(value="GLuint") int texture, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromGLTexture3D;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPP(__functionAddress, context, flags, texture_target, miplevel, texture, errcode_ret);
    }

    @NativeType(value="cl_mem")
    public static long clCreateFromGLRenderbuffer(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="GLuint") int renderbuffer, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromGLRenderbuffer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPP(__functionAddress, context, flags, renderbuffer, errcode_ret);
    }

    @NativeType(value="cl_int")
    public static int clGetGLObjectInfo(@NativeType(value="cl_mem") long memobj, @Nullable @NativeType(value="cl_gl_object_type *") int[] gl_object_type, @Nullable @NativeType(value="GLuint *") int[] gl_object_name) {
        long __functionAddress = CL.getICD().clGetGLObjectInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(memobj);
            Checks.checkSafe(gl_object_type, 1);
            Checks.checkSafe(gl_object_name, 1);
        }
        return JNI.callPPPI(__functionAddress, memobj, gl_object_type, gl_object_name);
    }

    @NativeType(value="cl_int")
    public static int clGetGLTextureInfo(@NativeType(value="cl_mem") long memobj, @NativeType(value="cl_gl_texture_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetGLTextureInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(memobj);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(__functionAddress, memobj, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 2, param_value, MemoryUtil.memAddressSafe(param_value_size_ret));
    }
}

